/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProtocolHeaderCodec;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdSoapCodec;
import org.talend.esb.sam.agent.message.FlowIdHelper;

public class FlowIdProducerOut<T extends Message>
extends AbstractPhaseInterceptor<T> {
    protected static Logger logger = Logger.getLogger(FlowIdProducerOut.class.getName());

    public FlowIdProducerOut() {
        super("user-logical");
    }

    public void handleMessage(T message) throws Fault {
        logger.finest("FlowIdProducerOut Interceptor called. isOutbound: " + MessageUtils.isOutbound(message) + ", isRequestor: " + MessageUtils.isRequestor(message));
        if (MessageUtils.isRequestor(message)) {
            this.handleRequestOut(message);
        } else {
            this.handleResponseOut(message);
        }
        String flowId = FlowIdHelper.getFlowId(message);
        FlowIdProtocolHeaderCodec.writeFlowId(message, flowId);
        FlowIdSoapCodec.writeFlowId(message, flowId);
    }

    protected void handleResponseOut(T message) throws Fault {
        logger.fine("handleResponseOut");
        Message reqMsg = message.getExchange().getInMessage();
        if (reqMsg == null) {
            logger.warning("getInMessage is null");
            return;
        }
        String reqFid = FlowIdHelper.getFlowId(reqMsg);
        FlowIdHelper.setFlowId(message, reqFid);
    }

    protected void handleRequestOut(T message) throws Fault {
        WeakReference wrPreviousMessage;
        Message previousMessage;
        String flowId = FlowIdHelper.getFlowId(message);
        if (flowId == null && message.containsKey((Object)PhaseInterceptorChain.PREVIOUS_MESSAGE) && (flowId = FlowIdHelper.getFlowId(previousMessage = (Message)(wrPreviousMessage = (WeakReference)message.get((Object)PhaseInterceptorChain.PREVIOUS_MESSAGE)).get())) != null) {
            logger.fine("flowId '" + flowId + "' found in previous message");
        }
        if (flowId == null) {
            flowId = ContextUtils.generateUUID();
            logger.fine("Created new FlowId '" + flowId + "'");
        }
        FlowIdHelper.setFlowId(message, flowId);
    }
}

