/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Message;
import org.talend.esb.sam.agent.message.FlowIdHelper;
import org.w3c.dom.Node;

public class FlowIdSoapCodec {
    protected static Logger logger = Logger.getLogger(FlowIdSoapCodec.class.getName());

    public static String readFlowId(Message message) {
        if (!(message instanceof SoapMessage)) {
            return null;
        }
        String flowId = null;
        SoapMessage soapMessage = (SoapMessage)message;
        Header hdFlowId = soapMessage.getHeader(FlowIdHelper.FLOW_ID_QNAME);
        if (hdFlowId != null) {
            if (hdFlowId.getObject() instanceof String) {
                flowId = (String)hdFlowId.getObject();
            } else if (hdFlowId.getObject() instanceof Node) {
                Node headerNode = (Node)hdFlowId.getObject();
                flowId = headerNode.getTextContent();
            } else {
                logger.warning("Found FlowId soap header but value is not a String or a Node! Value: " + hdFlowId.getObject().toString());
            }
        }
        return flowId;
    }

    public static void writeFlowId(Message message, String flowId) {
        if (!(message instanceof SoapMessage)) {
            return;
        }
        SoapMessage soapMessage = (SoapMessage)message;
        Header hdFlowId = soapMessage.getHeader(FlowIdHelper.FLOW_ID_QNAME);
        if (hdFlowId != null) {
            logger.warning("FlowId already existing in soap header, need not to write FlowId header.");
            return;
        }
        List headers = soapMessage.getHeaders();
        try {
            Header flowIdHeader = new Header(FlowIdHelper.FLOW_ID_QNAME, (Object)flowId, (DataBinding)new JAXBDataBinding(new Class[]{String.class}));
            headers.add(flowIdHeader);
            logger.fine("Stored flowId '" + flowId + "' in soap header: " + FlowIdHelper.FLOW_ID_QNAME.toString());
        }
        catch (JAXBException e) {
            logger.log(Level.SEVERE, "Couldn't create flowId header.", e);
        }
    }
}

