/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.serviceclient;

import java.util.ArrayList;
import java.util.List;
import org.talend.esb.sam._2011._03.common.EventType;
import org.talend.esb.sam.agent.serviceclient.EventMapper;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.MonitoringException;
import org.talend.esb.sam.common.service.MonitoringService;

public class MonitoringServiceWrapper
implements MonitoringService {
    private org.talend.esb.sam.monitoringservice.v1.MonitoringService monitoringService;
    private int numberOfRetries = 3;
    private long delayBetweenRetry = 1000L;

    public void setNumberOfRetries(int numberOfRetries) {
        if (numberOfRetries <= 0) {
            throw new IllegalStateException("Number of retries must be > 0 but was " + numberOfRetries);
        }
        this.numberOfRetries = numberOfRetries;
    }

    public void setDelayBetweenRetry(long delayBetweenRetry) {
        if (delayBetweenRetry <= 0L) {
            throw new IllegalStateException("Delay between retries must be > 0 but was " + delayBetweenRetry);
        }
        this.delayBetweenRetry = delayBetweenRetry;
    }

    public void setMonitoringService(org.talend.esb.sam.monitoringservice.v1.MonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }

    public void putEvents(List<Event> events) {
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        for (Event event : events) {
            EventType eventType = EventMapper.map(event);
            eventTypes.add(eventType);
        }
        int i = 0;
        Exception lastException = null;
        while (i < this.numberOfRetries) {
            try {
                this.monitoringService.putEvents(eventTypes);
                break;
            }
            catch (Exception e) {
                lastException = e;
                ++i;
                try {
                    Thread.sleep(this.delayBetweenRetry);
                }
                catch (Exception e1) {}
            }
        }
        if (i == this.numberOfRetries) {
            throw new MonitoringException("1104", "Could not send events to monitoring service after " + this.numberOfRetries + " retries.", (Throwable)lastException, events);
        }
    }
}

