/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventproducer;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.talend.esb.sam.agent.message.CustomInfo;
import org.talend.esb.sam.agent.message.FlowIdHelper;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;

public class MessageToEventMapper {
    private Logger log = Logger.getLogger(MessageToEventMapper.class.getName());
    private int maxContentLength = -1;

    public Event mapToEvent(Message message) {
        AuthorizationPolicy authPolicy;
        SoapBinding soapBinding;
        Event event = new Event();
        MessageInfo messageInfo = new MessageInfo();
        Originator originator = new Originator();
        event.setMessageInfo(messageInfo);
        event.setOriginator(originator);
        String content = this.getPayload(message);
        event.setContent(content);
        this.handleContentLength(event);
        event.setEventType(null);
        Date date = new Date();
        event.setTimestamp(date);
        messageInfo.setMessageId(this.getMessageId(message));
        messageInfo.setFlowId(FlowIdHelper.getFlowId(message));
        String opName = message.getExchange().getBindingOperationInfo().getName().toString();
        messageInfo.setOperationName(opName);
        String portTypeName = message.getExchange().getBinding().getBindingInfo().getService().getInterface().getName().toString();
        messageInfo.setPortType(portTypeName);
        if (message.getExchange().getBinding() instanceof SoapBinding && (soapBinding = (SoapBinding)message.getExchange().getBinding()).getBindingInfo() instanceof SoapBindingInfo) {
            SoapBindingInfo soapBindingInfo = (SoapBindingInfo)soapBinding.getBindingInfo();
            messageInfo.setTransportType(soapBindingInfo.getTransportURI());
        }
        if (messageInfo.getTransportType() == null) {
            messageInfo.setTransportType("Unknown transport type");
        }
        String addr = message.getExchange().getEndpoint().getEndpointInfo().getAddress();
        event.getCustomInfo().put("address", addr);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            originator.setIp(inetAddress.getHostAddress());
            originator.setHostname(inetAddress.getHostName());
        }
        catch (UnknownHostException e) {
            originator.setHostname("Unknown hostname");
            originator.setIp("Unknown ip address");
        }
        String mxName = ManagementFactory.getRuntimeMXBean().getName();
        String pId = mxName.split("@")[0];
        originator.setProcessId(pId);
        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
        if (sc != null && sc.getUserPrincipal() != null) {
            originator.setPrincipal(sc.getUserPrincipal().getName());
        }
        if (originator.getPrincipal() == null && (authPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class)) != null) {
            originator.setPrincipal(authPolicy.getUserName());
        }
        EventTypeEnum eventType = this.getEventType(message);
        event.setEventType(eventType);
        CustomInfo customInfo = CustomInfo.getOrCreateCustomInfo(message);
        event.getCustomInfo().putAll(customInfo);
        return event;
    }

    private String getMessageId(Message message) {
        String messageId = null;
        AddressingPropertiesImpl addrProp = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)MessageUtils.isOutbound((Message)message));
        messageId = addrProp != null ? addrProp.getMessageID().getValue() : ContextUtils.generateUUID();
        return messageId;
    }

    private EventTypeEnum getEventType(Message message) {
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isFault = MessageUtils.isFault((Message)message);
        boolean isOutbound = MessageUtils.isOutbound((Message)message);
        if (isOutbound) {
            if (isFault) {
                return EventTypeEnum.FAULT_OUT;
            }
            return isRequestor ? EventTypeEnum.REQ_OUT : EventTypeEnum.RESP_OUT;
        }
        if (isFault) {
            return EventTypeEnum.FAULT_IN;
        }
        return isRequestor ? EventTypeEnum.RESP_IN : EventTypeEnum.REQ_IN;
    }

    protected String getPayload(Message message) {
        try {
            CachedOutputStream cos;
            String encoding = (String)message.get((Object)Message.ENCODING);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if ((cos = (CachedOutputStream)message.getContent(CachedOutputStream.class)) == null) {
                this.log.warning("Could not find CachedOutputStream in message. Continuing without message content");
                return "";
            }
            return new String(cos.getBytes(), encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    private void handleContentLength(Event event) {
        String CUT_START_TAG = "<cut><![CDATA[";
        String CUT_END_TAG = "]]></cut>";
        if (event.getContent() == null) {
            return;
        }
        if (this.maxContentLength == -1 || event.getContent().length() <= this.maxContentLength) {
            return;
        }
        if (this.maxContentLength < CUT_START_TAG.length() + CUT_END_TAG.length()) {
            event.setContent("");
            event.setContentCut(true);
            return;
        }
        int contentLength = this.maxContentLength - CUT_START_TAG.length() - CUT_END_TAG.length();
        event.setContent(CUT_START_TAG + event.getContent().substring(0, contentLength) + CUT_END_TAG);
        event.setContentCut(true);
    }
}

