/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.feature;

import java.util.Queue;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.springframework.beans.factory.InitializingBean;
import org.talend.esb.sam.agent.eventproducer.EventProducerInterceptor;
import org.talend.esb.sam.agent.eventproducer.MessageToEventMapper;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProducerIn;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProducerOut;
import org.talend.esb.sam.agent.wiretap.WireTapIn;
import org.talend.esb.sam.agent.wiretap.WireTapOut;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.spi.EventHandler;

public class EventFeature
extends AbstractFeature
implements InitializingBean {
    private boolean logMessageContent = true;
    private int maxContentLength = -1;
    private Queue<Event> queue;
    private EventProducerInterceptor epi;
    protected static Logger logger = Logger.getLogger(EventFeature.class.getName());

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        super.initializeProvider(provider, bus);
        if (!this.detectWSAddressingFeature(provider, bus)) {
            this.addWSAddressingInterceptors(provider);
        }
        FlowIdProducerIn flowIdProducerIn = new FlowIdProducerIn();
        provider.getInInterceptors().add(flowIdProducerIn);
        provider.getInFaultInterceptors().add(flowIdProducerIn);
        FlowIdProducerOut flowIdProducerOut = new FlowIdProducerOut();
        provider.getOutInterceptors().add(flowIdProducerOut);
        provider.getOutFaultInterceptors().add(flowIdProducerOut);
        WireTapIn wireTapIn = new WireTapIn(this.logMessageContent);
        provider.getInInterceptors().add(wireTapIn);
        provider.getInInterceptors().add(this.epi);
        provider.getInFaultInterceptors().add(this.epi);
        WireTapOut wireTapOut = new WireTapOut((Interceptor<Message>)this.epi, this.logMessageContent);
        provider.getOutInterceptors().add(wireTapOut);
        provider.getOutFaultInterceptors().add(wireTapOut);
    }

    public void setLogMessageContent(boolean logMessageContent) {
        this.logMessageContent = logMessageContent;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void setQueue(Queue<Event> queue) {
        this.queue = queue;
        if (this.epi == null) {
            MessageToEventMapper mapper = new MessageToEventMapper();
            mapper.setMaxContentLength(this.maxContentLength);
            this.epi = new EventProducerInterceptor(mapper, queue);
        }
    }

    public void setHandler(EventHandler handler) {
        if (this.epi != null) {
            this.epi.setHandler(handler);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    private boolean detectWSAddressingFeature(InterceptorProvider provider, Bus bus) {
        if (bus.getFeatures() != null) {
            for (AbstractFeature busFeature : bus.getFeatures()) {
                if (!(busFeature instanceof WSAddressingFeature)) continue;
                return true;
            }
        }
        for (Interceptor ic : provider.getInInterceptors()) {
            if (!(ic instanceof MAPAggregator)) continue;
            return true;
        }
        return false;
    }

    private void addWSAddressingInterceptors(InterceptorProvider provider) {
        MAPAggregator mapAggregator = new MAPAggregator();
        MAPCodec mapCodec = new MAPCodec();
        provider.getInInterceptors().add(mapAggregator);
        provider.getInInterceptors().add(mapCodec);
        provider.getOutInterceptors().add(mapAggregator);
        provider.getOutInterceptors().add(mapCodec);
        provider.getInFaultInterceptors().add(mapAggregator);
        provider.getInFaultInterceptors().add(mapCodec);
        provider.getOutFaultInterceptors().add(mapAggregator);
        provider.getOutFaultInterceptors().add(mapCodec);
    }
}

