/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;

public class FlowIdProtocolHeaderCodec {
    public static final String FLOWID_HTTP_HEADER_NAME = "flowid";
    protected static Logger logger = Logger.getLogger(FlowIdProtocolHeaderCodec.class.getName());

    private static Map<String, List<String>> getOrCreateProtocolHeader(Message message) {
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }

    public static String readFlowId(Message message) {
        String flowId = null;
        Map<String, List<String>> headers = FlowIdProtocolHeaderCodec.getOrCreateProtocolHeader(message);
        List<String> flowIds = headers.get(FLOWID_HTTP_HEADER_NAME);
        if (flowIds != null && flowIds.size() > 0) {
            flowId = flowIds.get(0);
            logger.fine("HTTP header 'flowid' found: " + flowId);
        } else {
            logger.fine("No HTTP header 'flowid' found");
        }
        return flowId;
    }

    public static void writeFlowId(Message message, String flowId) {
        Map<String, List<String>> headers = FlowIdProtocolHeaderCodec.getOrCreateProtocolHeader(message);
        headers.put(FLOWID_HTTP_HEADER_NAME, Arrays.asList(flowId));
        logger.fine("HTTP header 'flowid' set to: " + flowId);
    }
}

