/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.lifecycle;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.talend.esb.sam.agent.util.Converter;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;
import org.talend.esb.sam.common.service.MonitoringService;

public class ServiceListenerImpl
implements ServerLifeCycleListener {
    private static Logger logger = Logger.getLogger(ServiceListenerImpl.class.getName());
    private boolean sendLifecycleEvent;
    private Queue<Event> queue;
    private MonitoringService monitoringServiceClient;

    public void setSendLifecycleEvent(boolean sendLifecycleEvent) {
        this.sendLifecycleEvent = sendLifecycleEvent;
    }

    public void setQueue(Queue<Event> queue) {
        this.queue = queue;
    }

    public void setMonitoringServiceClient(MonitoringService monitoringServiceClient) {
        this.monitoringServiceClient = monitoringServiceClient;
    }

    public void startServer(Server server) {
        if (!this.sendLifecycleEvent) {
            return;
        }
        Event event = this.createEvent(server, EventTypeEnum.SERVICE_START);
        this.queue.add(event);
    }

    public void stopServer(Server server) {
        if (!this.sendLifecycleEvent) {
            return;
        }
        Event event = this.createEvent(server, EventTypeEnum.SERVICE_STOP);
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(event);
        this.monitoringServiceClient.putEvents(eventList);
        logger.info("Send SERVICE_STOP event to SAM Server successful!");
    }

    private Event createEvent(Server server, EventTypeEnum type) {
        SoapBinding soapBinding;
        String portType = server.getEndpoint().getBinding().getBindingInfo().getService().getInterface().getName().toString();
        String transportType = null;
        if (server.getEndpoint().getBinding() instanceof SoapBinding && (soapBinding = (SoapBinding)server.getEndpoint().getBinding()).getBindingInfo() instanceof SoapBindingInfo) {
            SoapBindingInfo soapBindingInfo = (SoapBindingInfo)soapBinding.getBindingInfo();
            transportType = soapBindingInfo.getTransportURI();
        }
        String address = server.getEndpoint().getEndpointInfo().getAddress();
        Event event = new Event();
        MessageInfo messageInfo = new MessageInfo();
        Originator originator = new Originator();
        event.setMessageInfo(messageInfo);
        event.setOriginator(originator);
        Date date = new Date();
        event.setTimestamp(date);
        event.setEventType(type);
        messageInfo.setPortType(portType);
        messageInfo.setTransportType(transportType);
        if (messageInfo.getTransportType() == null) {
            messageInfo.setTransportType("Unknown transport type");
        }
        originator.setProcessId(Converter.getPID());
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            originator.setIp(inetAddress.getHostAddress());
            originator.setHostname(inetAddress.getHostName());
        }
        catch (UnknownHostException e) {
            originator.setHostname("Unknown hostname");
            originator.setIp("Unknown ip address");
        }
        event.getCustomInfo().put("address", address);
        return event;
    }
}

