/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventproducer;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.talend.esb.sam.agent.eventproducer.MessageToEventMapper;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.spi.EventHandler;

public class EventProducerInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(EventProducerInterceptor.class.getName());
    private final MessageToEventMapper mapper;
    private final Queue<Event> queue;
    private EventHandler handler;

    public EventProducerInterceptor(MessageToEventMapper mapper, Queue<Event> queue) {
        super("pre-invoke");
        if (mapper == null) {
            throw new RuntimeException("Mapper must be set on EventFeature");
        }
        if (queue == null) {
            throw new RuntimeException("Queue must be set on EventFeature");
        }
        this.mapper = mapper;
        this.queue = queue;
    }

    public void setHandler(EventHandler handler) {
        this.handler = handler;
    }

    public void handleMessage(Message message) throws Fault {
        Event event = this.mapper.mapToEvent(message);
        if (this.handler != null) {
            this.handler.handleEvent(event);
        }
        if (LOG.isLoggable(Level.FINE)) {
            String id = event.getMessageInfo() != null ? event.getMessageInfo().getMessageId() : null;
            LOG.fine("Store event [message_id=" + id + "] in cache.");
        }
        this.queue.add(event);
    }
}

