/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.lang.ref.WeakReference;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.talend.esb.sam.agent.eventproducer.EventProducerInterceptor;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProtocolHeaderCodec;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdSoapCodec;
import org.talend.esb.sam.agent.message.FlowIdHelper;

public class FlowIdProducerOut<T extends Message>
extends AbstractPhaseInterceptor<T> {
    private static final Logger LOG = Logger.getLogger(FlowIdProducerOut.class.getName());

    public FlowIdProducerOut() {
        super("user-logical");
    }

    public void handleMessage(T message) throws Fault {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("FlowIdProducerOut Interceptor called. isOutbound: " + MessageUtils.isOutbound(message) + ", isRequestor: " + MessageUtils.isRequestor(message));
        }
        if (MessageUtils.isRequestor(message)) {
            this.handleRequestOut(message);
        } else {
            this.handleResponseOut(message);
        }
        String flowId = FlowIdHelper.getFlowId(message);
        FlowIdProtocolHeaderCodec.writeFlowId(message, flowId);
        FlowIdSoapCodec.writeFlowId(message, flowId);
    }

    protected void handleResponseOut(T message) throws Fault {
        Message inMsg;
        Message reqMsg = message.getExchange().getInMessage();
        if (reqMsg == null) {
            LOG.warning("InMessage is null!");
            return;
        }
        Exchange ex = reqMsg.getExchange();
        if (ex.isOneWay()) {
            return;
        }
        String reqFid = FlowIdHelper.getFlowId(reqMsg);
        if (reqFid == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Some interceptor throws fault.Setting FlowId in response.");
            }
            reqFid = FlowIdProtocolHeaderCodec.readFlowId(message);
        }
        if (reqFid == null && null != (reqFid = FlowIdProtocolHeaderCodec.readFlowId(inMsg = ex.getInMessage()))) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("FlowId '" + reqFid + "' found in message of fault incoming exchange.");
                LOG.fine("Calling EventProducerInterceptor to log IN message");
            }
            this.handleINEvent(ex, reqFid);
        }
        if (reqFid == null) {
            reqFid = FlowIdSoapCodec.readFlowId(message);
        }
        if (reqFid != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("FlowId '" + reqFid + "' found in incoming message.");
            }
        } else {
            reqFid = ContextUtils.generateUUID();
            if (null != ex.getOutFaultMessage()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("FlowId '" + reqFid + "' generated for fault message.");
                    LOG.fine("Calling EventProducerInterceptor to log IN message");
                }
                this.handleINEvent(ex, reqFid);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No flowId found in incoming message! Generate new flowId " + reqFid);
            }
        }
        FlowIdHelper.setFlowId(message, reqFid);
    }

    protected void handleRequestOut(T message) throws Fault {
        WeakReference wrPreviousMessage;
        Message previousMessage;
        String flowId = FlowIdHelper.getFlowId(message);
        if (flowId == null && message.containsKey((Object)PhaseInterceptorChain.PREVIOUS_MESSAGE) && (flowId = FlowIdHelper.getFlowId(previousMessage = (Message)(wrPreviousMessage = (WeakReference)message.get((Object)PhaseInterceptorChain.PREVIOUS_MESSAGE)).get())) != null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("flowId '" + flowId + "' found in previous message");
        }
        if (flowId == null) {
            flowId = ContextUtils.generateUUID();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Generate new flowId '" + flowId + "'");
            }
        }
        FlowIdHelper.setFlowId(message, flowId);
    }

    protected void handleINEvent(Exchange exchange, String reqFid) throws Fault {
        Message inMsg = exchange.getInMessage();
        EventProducerInterceptor epi = null;
        FlowIdHelper.setFlowId(inMsg, reqFid);
        ListIterator interceptors = inMsg.getInterceptorChain().getIterator();
        while (interceptors.hasNext() && epi == null) {
            Interceptor interceptor = (Interceptor)interceptors.next();
            if (!(interceptor instanceof EventProducerInterceptor)) continue;
            epi = (EventProducerInterceptor)interceptor;
            epi.handleMessage(inMsg);
        }
    }
}

