/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Message;
import org.w3c.dom.Node;

public final class FlowIdSoapCodec {
    private static final Logger LOG = Logger.getLogger(FlowIdSoapCodec.class.getName());
    public static final QName FLOW_ID_QNAME = new QName("http://www.talend.com/esb/sam/flowId/v1", "flowId");

    private FlowIdSoapCodec() {
    }

    public static String readFlowId(Message message) {
        if (!(message instanceof SoapMessage)) {
            return null;
        }
        String flowId = null;
        Header hdFlowId = ((SoapMessage)message).getHeader(FLOW_ID_QNAME);
        if (hdFlowId != null) {
            if (hdFlowId.getObject() instanceof String) {
                flowId = (String)hdFlowId.getObject();
            } else if (hdFlowId.getObject() instanceof Node) {
                Node headerNode = (Node)hdFlowId.getObject();
                flowId = headerNode.getTextContent();
            } else {
                LOG.warning("Found FlowId soap header but value is not a String or a Node! Value: " + hdFlowId.getObject().toString());
            }
        }
        return flowId;
    }

    public static void writeFlowId(Message message, String flowId) {
        if (!(message instanceof SoapMessage)) {
            return;
        }
        SoapMessage soapMessage = (SoapMessage)message;
        Header hdFlowId = soapMessage.getHeader(FLOW_ID_QNAME);
        if (hdFlowId != null) {
            LOG.warning("FlowId already existing in soap header, need not to write FlowId header.");
            return;
        }
        try {
            soapMessage.getHeaders().add(new Header(FLOW_ID_QNAME, (Object)flowId, (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Stored flowId '" + flowId + "' in soap header: " + FLOW_ID_QNAME);
            }
        }
        catch (JAXBException e) {
            LOG.log(Level.SEVERE, "Couldn't create flowId header.", e);
        }
    }
}

