/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.wiretap;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.talend.esb.sam.agent.wiretap.WriterOutputStream;

public class WireTapOut
extends AbstractPhaseInterceptor<Message> {
    private Interceptor<Message> wireTap;
    private boolean logMessageContent;

    public WireTapOut(Interceptor<Message> wireTap, boolean logMessageContent) {
        super("pre-stream");
        this.wireTap = wireTap;
        this.logMessageContent = logMessageContent;
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (null == os) {
            Writer writer;
            String encoding = (String)message.get((Object)Message.ENCODING);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if (null != (writer = (Writer)message.getContent(Writer.class))) {
                os = new WriterOutputStream(writer, encoding);
                message.setContent(Writer.class, null);
            }
        }
        if (null != os) {
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
            message.setContent(OutputStream.class, (Object)newOut);
            if (os != null && this.logMessageContent) {
                message.setContent(CachedOutputStream.class, (Object)newOut);
            }
            if (this.wireTap != null) {
                newOut.registerCallback((CachedOutputStreamCallback)new CallBack(message));
            }
        }
    }

    private final class CallBack
    implements CachedOutputStreamCallback {
        private final Message message;

        private CallBack(Message message) {
            this.message = message;
        }

        public void onFlush(CachedOutputStream os) {
        }

        public void onClose(CachedOutputStream os) {
            WireTapOut.this.wireTap.handleMessage(this.message);
        }
    }
}

