/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventproducer;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.impl.AddressingPropertiesImpl;
import org.talend.esb.sam.agent.eventproducer.MessageToEventMapper;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.spi.EventHandler;

public class EventProducerInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(EventProducerInterceptor.class.getName());
    private final MessageToEventMapper mapper;
    private final Queue<Event> queue;
    private EventHandler handler;
    private static final String SAM_OPERATION = "{http://www.talend.org/esb/sam/MonitoringService/v1}putEvents";

    public EventProducerInterceptor(MessageToEventMapper mapper, Queue<Event> queue) {
        super("pre-invoke");
        if (mapper == null) {
            throw new RuntimeException("Mapper must be set on EventFeature");
        }
        if (queue == null) {
            throw new RuntimeException("Queue must be set on EventFeature");
        }
        this.mapper = mapper;
        this.queue = queue;
    }

    public void setHandler(EventHandler handler) {
        this.handler = handler;
    }

    public void handleMessage(Message message) throws Fault {
        String operationName;
        BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
        if (null != boi && SAM_OPERATION.equals(operationName = boi.getName().toString())) {
            return;
        }
        if (this.isRestWadlRequest(message)) {
            return;
        }
        this.checkMessageID(message);
        Event event = this.mapper.mapToEvent(message);
        if (null != this.handler) {
            this.handler.handleEvent(event);
        }
        if (LOG.isLoggable(Level.FINE)) {
            String id = event.getMessageInfo() != null ? event.getMessageInfo().getMessageId() : null;
            LOG.fine("Store event [message_id=" + id + "] in cache.");
        }
        if (null != event) {
            this.queue.add(event);
        }
    }

    private void checkMessageID(Message message) {
        if (!MessageUtils.isOutbound((Message)message)) {
            return;
        }
        AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)MessageUtils.isOutbound((Message)message));
        if (maps == null) {
            maps = new AddressingPropertiesImpl();
        }
        if (maps.getMessageID() == null) {
            String messageID = ContextUtils.generateUUID();
            boolean isRequestor = ContextUtils.isRequestor((Message)message);
            maps.setMessageID(ContextUtils.getAttributedURI((String)messageID));
            ContextUtils.storeMAPs((AddressingProperties)maps, (Message)message, (boolean)ContextUtils.isOutbound((Message)message), (boolean)isRequestor);
        }
    }

    private boolean isRestWadlRequest(Message message) {
        if (MessageToEventMapper.isRestMessage(message)) {
            Message requestMessage;
            Exchange ex;
            String queryString = (String)message.get((Object)Message.QUERY_STRING);
            boolean isRestWadlRequest = this.isRestWadlRequest(queryString);
            if (isRestWadlRequest) {
                return true;
            }
            if (MessageUtils.isOutbound((Message)message) && null != (ex = message.getExchange()) && null != (requestMessage = ex.getInMessage())) {
                queryString = (String)requestMessage.get((Object)Message.QUERY_STRING);
                return this.isRestWadlRequest(queryString);
            }
        }
        return false;
    }

    private boolean isRestWadlRequest(String requestQueryString) {
        if (null != requestQueryString) {
            String[] queryParams;
            for (String param : queryParams = requestQueryString.split("&")) {
                if (!"_wadl".equals(param) && !param.startsWith("_wadl=")) continue;
                return true;
            }
        }
        return false;
    }
}

