/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventadmin.translator.subject;

import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.talend.esb.sam.agent.eventadmin.translator.subject.AbstractSubjectExtractorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SubjectExtractor {
    private static final Logger LOG = Logger.getLogger(SubjectExtractor.class.getName());
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private final SAXParser parser;

    public SubjectExtractor() {
        this.parserFactory.setNamespaceAware(true);
        try {
            this.parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            this.parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        }
        catch (SAXNotRecognizedException ex) {
            LOG.fine("Property XMLConstants.FEATURE_SECURE_PROCESSING is not recognized");
        }
        catch (SAXNotSupportedException ex) {
            LOG.fine("Property XMLConstants.FEATURE_SECURE_PROCESSING is not recognized");
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.parser = this.parserFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubject(String document, AbstractSubjectExtractorHandler handler) throws Exception {
        if (document == null) {
            LOG.warning("Message content is null, couldn't get the Subject/Principal.");
            return null;
        }
        if (document.trim().isEmpty()) {
            LOG.warning("Message content is empty, couldn't get the Subject/Principal.");
            return null;
        }
        try {
            SAXParser sAXParser = this.parser;
            synchronized (sAXParser) {
                this.parser.parse(new InputSource(new StringReader(document)), (DefaultHandler)handler);
            }
        }
        catch (AbstractSubjectExtractorHandler.SubjectFoundException e) {
            return handler.getSubject();
        }
        catch (SAXParseException e) {
            LOG.log(Level.WARNING, "Parse message content failed, couldn't get the Subject/Principal.", e);
            return null;
        }
        return null;
    }
}

