/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.common.handler.impl;

import java.util.logging.Logger;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.spi.EventHandler;

public class ContentLengthHandler
implements EventHandler {
    private static Logger logger = Logger.getLogger(ContentLengthHandler.class.getName());
    static final String CUT_START_TAG = "<cut><![CDATA[";
    static final String CUT_END_TAG = "]]></cut>";
    private int length;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void handleEvent(Event event) {
        logger.fine("ContentLengthHandler called");
        if (CUT_START_TAG.length() + CUT_END_TAG.length() > this.length) {
            logger.warning("Trying to cut content. But length is shorter then needed for <cut><![CDATA[]]></cut>. So content is skipped.");
            event.setContent("");
            return;
        }
        int currentLength = this.length - CUT_START_TAG.length() - CUT_END_TAG.length();
        if (event.getContent() != null && event.getContent().length() > this.length) {
            logger.fine("cutting content to " + currentLength + " characters. Original length was " + event.getContent().length());
            logger.fine("Content before cutting: " + event.getContent());
            event.setContent(CUT_START_TAG + event.getContent().substring(0, currentLength) + CUT_END_TAG);
            logger.fine("Content after cutting: " + event.getContent());
        }
    }
}

