/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.common.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.esb.sam.common.event.Event;

public class MonitoringException
extends RuntimeException {
    private static final Logger LOG = Logger.getLogger(MonitoringException.class.getName());
    private static final long serialVersionUID = 3127641209174705808L;
    private final String code;
    private final String message;
    private final List<Event> events = new ArrayList<Event>();

    public MonitoringException(String code, String message, Throwable t) {
        this(code, message, t, Collections.emptyList());
    }

    public MonitoringException(String code, String message, Throwable t, Event event) {
        this(code, message, t, Collections.singletonList(event));
    }

    public MonitoringException(String code, String message, Throwable t, List<Event> events) {
        super(t);
        this.code = code;
        this.message = message;
        this.events.addAll(events);
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void logException(Level level) {
        if (!LOG.isLoggable(level)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n----------------------------------------------------");
        builder.append("\nMonitoringException");
        builder.append("\n----------------------------------------------------");
        builder.append("\nCode:    ").append(this.code);
        builder.append("\nMessage: ").append(this.message);
        builder.append("\n----------------------------------------------------");
        if (this.events != null) {
            for (Event event : this.events) {
                builder.append("\nEvent:");
                if (event.getMessageInfo() != null) {
                    builder.append("\nMessage id: ").append(event.getMessageInfo().getMessageId());
                    builder.append("\nFlow id:    ").append(event.getMessageInfo().getFlowId());
                    builder.append("\n----------------------------------------------------");
                    continue;
                }
                builder.append("\nNo message id and no flow id");
            }
        }
        builder.append("\n----------------------------------------------------\n");
        LOG.log(level, builder.toString(), this);
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void addEvents(Collection<Event> eventCollection) {
        this.events.addAll(eventCollection);
    }
}

