/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.talend.esb.sam.server.ui.UIProvider;

public abstract class AbstractAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger log = LoggerFactory.getLogger(AbstractAPIServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        try {
            UIProvider provider = (UIProvider)ctx.getBean("uiProvider");
            resp.setContentType("application/json");
            this.processRequest(req, resp, provider);
        }
        catch (Exception e) {
            this.log.error("Exception processing request " + req.getRequestURI() + " with parameters " + req.getQueryString(), (Throwable)e);
            resp.setStatus(500);
            resp.getWriter().println(this.toJSON(e));
        }
    }

    abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2, UIProvider var3) throws Exception;

    private JsonObject toJSON(Exception e) {
        JsonObject result = new JsonObject();
        result.add("message", (JsonElement)new JsonPrimitive(String.valueOf(e.getMessage())));
        return result;
    }

    protected String getBaseUrl(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        String base = url.substring(0, url.length() - req.getRequestURI().length());
        base = base + req.getContextPath();
        base = base + "/api/v1.0/";
        return base;
    }
}

