/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.talend.esb.sam.server.persistence.criterias.Criteria;
import org.talend.esb.sam.server.persistence.criterias.DateCriteria;
import org.talend.esb.sam.server.persistence.criterias.PatternCriteria;
import org.talend.esb.sam.server.persistence.dialects.QueryFilter;
import org.talend.esb.sam.server.ui.UIProviderImpl;

public class CriteriaAdapter
implements SqlParameterSource,
QueryFilter {
    private static final String CONSUMER_EVENT_TYPES = "(EI_EVENT_TYPE = 'REQ_OUT' or EI_EVENT_TYPE = 'RESP_IN')";
    private static final String PROVIDER_EVENT_TYPES = "(EI_EVENT_TYPE = 'REQ_IN' or EI_EVENT_TYPE = 'RESP_OUT')";
    private Logger log = LoggerFactory.getLogger(UIProviderImpl.class);
    private final Map<String, Criteria> criterias;
    private long offset;
    private long limit;
    private static final Criteria[] FILTER_CRITERIAS = new Criteria[]{new PatternCriteria("transport", "MI_TRANSPORT_TYPE"), new PatternCriteria("port", "MI_PORT_TYPE"), new PatternCriteria("operation", "MI_OPERATION_NAME"), new DateCriteria("timestamp_before", "EI_TIMESTAMP"), new DateCriteria("timestamp_after", "EI_TIMESTAMP"), new DateCriteria("timestamp_on", "EI_TIMESTAMP"), new PatternCriteria("flowID", "MI_FLOW_ID"), new PatternCriteria("consumer_ip", "ORIG_IP", "(EI_EVENT_TYPE = 'REQ_OUT' or EI_EVENT_TYPE = 'RESP_IN')"), new PatternCriteria("consumer_host", "ORIG_HOSTNAME", "(EI_EVENT_TYPE = 'REQ_OUT' or EI_EVENT_TYPE = 'RESP_IN')"), new PatternCriteria("provider_ip", "ORIG_IP", "(EI_EVENT_TYPE = 'REQ_IN' or EI_EVENT_TYPE = 'RESP_OUT')"), new PatternCriteria("provider_host", "ORIG_HOSTNAME", "(EI_EVENT_TYPE = 'REQ_IN' or EI_EVENT_TYPE = 'RESP_OUT')")};
    private static final String LIMIT_NAME = "limit";
    private static final String OFFSET_NAME = "offset";

    public CriteriaAdapter(long offset, long limit, Map<String, String[]> params) {
        this.offset = offset;
        this.limit = limit;
        this.criterias = this.getCriterias(params);
    }

    private Map<String, Criteria> getCriterias(Map<String, String[]> params) {
        HashMap<String, Criteria> result = new HashMap<String, Criteria>();
        Set<String> keys = params.keySet();
        block2: for (String key : keys) {
            for (Criteria criteria : FILTER_CRITERIAS) {
                if (!criteria.getName().equals(key)) continue;
                try {
                    Criteria[] parsedCriterias;
                    String value = params.get(key)[0];
                    for (Criteria parsedCriteria : parsedCriterias = criteria.parseValue(value)) {
                        result.put(parsedCriteria.getName(), parsedCriteria);
                    }
                    continue block2;
                }
                catch (Exception e) {
                    this.log.error("Error parsing parameter " + key, (Throwable)e);
                    continue block2;
                }
            }
        }
        return result;
    }

    public boolean hasValue(String paramName) {
        return this.criterias.containsKey(paramName) || LIMIT_NAME.equals(paramName) || OFFSET_NAME.equals(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("Can't find criteria with name " + paramName);
        }
        if (LIMIT_NAME.equals(paramName)) {
            return this.limit;
        }
        if (OFFSET_NAME.equals(paramName)) {
            return this.offset;
        }
        return ((Criteria)this.criterias.get(paramName)).getValue();
    }

    public int getSqlType(String paramName) {
        if (!this.hasValue(paramName)) {
            return Integer.MIN_VALUE;
        }
        Object value = this.getValue(paramName);
        return StatementCreatorUtils.javaTypeToSqlParameterType(value.getClass());
    }

    public String getTypeName(String paramName) {
        return null;
    }

    public String getWhereClause() {
        StringBuilder result = new StringBuilder();
        ArrayList names = new ArrayList(this.criterias.keySet());
        Collections.sort(names);
        for (String key : names) {
            Criteria criteria = (Criteria)this.criterias.get(key);
            if (result.length() > 0) {
                result.append(" AND ");
            }
            result.append("(");
            result.append((CharSequence)criteria.getFilterClause());
            result.append(")");
        }
        return result.toString();
    }
}

