/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class JsonRowMapper
implements RowMapper<JsonObject> {
    private Map<String, String> nameMapping = new HashMap();
    private RowMapper<Map<String, Object>> nestedMapper = new ColumnMapRowMapper();
    final Gson gson;

    public JsonRowMapper() {
        this.nameMapping.put("ID", "id");
        this.nameMapping.put("MI_FLOW_ID", "flowID");
        this.nameMapping.put("EI_TIMESTAMP", "timestamp");
        this.nameMapping.put("EI_EVENT_TYPE", "type");
        this.nameMapping.put("MI_PORT_TYPE", "port");
        this.nameMapping.put("MI_OPERATION_NAME", "operation");
        this.nameMapping.put("MI_TRANSPORT_TYPE", "transport");
        this.nameMapping.put("ORIG_HOSTNAME", "host");
        this.nameMapping.put("ORIG_IP", "ip");
        this.nameMapping.put("ORIG_CUSTOM_ID", "customID");
        this.nameMapping.put("ORIG_PROCESS_ID", "process");
        this.nameMapping.put("ORIG_PRINCIPAL", "principal");
        this.nameMapping.put("MI_MESSAGE_ID", "messageID");
        this.nameMapping.put("CONTENT_CUT", "contentCut");
        this.nameMapping.put("MESSAGE_CONTENT", "content");
        this.nameMapping.put("CUST_KEY", "custKey");
        this.nameMapping.put("CUST_VALUE", "custValue");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Timestamp.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.gson = builder.create();
    }

    public JsonObject mapRow(ResultSet rs, int rowNum) throws SQLException {
        Map map = (Map)this.nestedMapper.mapRow(rs, rowNum);
        JsonObject row = new JsonObject();
        for (String key : map.keySet()) {
            String jsonName = (String)this.nameMapping.get(key);
            if (jsonName == null) {
                jsonName = key;
            }
            row.add(jsonName, this.gson.toJsonTree(map.get(key)));
        }
        return row;
    }
}

