/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.talend.esb.sam.server.ui.UIProvider;
import org.talend.esb.sam.server.ui.servlets.NotFoundException;

public abstract class AbstractAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger log = LoggerFactory.getLogger(AbstractAPIServlet.class);
    private final boolean noCache;

    protected AbstractAPIServlet() {
        this.noCache = true;
    }

    protected AbstractAPIServlet(boolean cachingAllowed) {
        this.noCache = !cachingAllowed;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String callback = req.getParameter("callback");
        try {
            UIProvider provider = (UIProvider)ctx.getBean("uiProvider");
            JsonObject result = this.process(req, provider);
            if (this.noCache) {
                resp.setHeader("Cache-Control", "no-cache, must-revalidate");
                resp.setHeader("Expires", "Thu, 09 May 1974 03:35:00 GMT");
                resp.setHeader("Pragma", "no-cache");
            }
            this.writeResponse(resp, result, callback);
        }
        catch (NotFoundException e) {
            resp.setStatus(404);
            this.writeResponse(resp, this.toJSON((Exception)((Object)e)), callback);
        }
        catch (Exception e) {
            this.log.error("Exception processing request " + req.getRequestURI() + " with parameters " + req.getQueryString(), (Throwable)e);
            resp.setStatus(500);
            this.writeResponse(resp, this.toJSON(e), callback);
        }
    }

    abstract JsonObject process(HttpServletRequest var1, UIProvider var2) throws Exception;

    private void writeResponse(HttpServletResponse resp, JsonObject output, String callback) throws IOException {
        if (null == callback || callback.trim().isEmpty()) {
            resp.setContentType("application/json");
            resp.getWriter().println(output);
        } else {
            resp.setContentType("text/javascript");
            resp.getWriter().println(callback + "(" + output + ");");
        }
    }

    private JsonObject toJSON(Exception e) {
        JsonObject result = new JsonObject();
        result.add("error", (JsonElement)new JsonPrimitive(String.valueOf(e.getMessage())));
        return result;
    }

    protected String getBaseUrl(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        String base = url.substring(0, url.length() - req.getRequestURI().length());
        base = base + req.getContextPath();
        base = base + "/api/v1.0/";
        return base;
    }
}

