/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.https;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;
import org.talend.esb.security.https.FakeX509TrustManager;

public class HttpsConnectionHelper {
    private HttpsConnectionHelper() {
    }

    public static void trustAllForUrlConnection() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, new TrustManager[]{new FakeX509TrustManager()}, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public static void trustAllForHttpConduit(HTTPConduit conduit) {
        TLSClientParameters tlsClientParams = conduit.getTlsClientParameters();
        if (tlsClientParams == null) {
            tlsClientParams = new TLSClientParameters();
            conduit.setTlsClientParameters(tlsClientParams);
        }
        tlsClientParams.setTrustManagers(new TrustManager[]{new FakeX509TrustManager()});
        tlsClientParams.setDisableCNCheck(true);
    }
}

