/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.saml;

import java.util.Map;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.rs.security.saml.SamlHeaderInHandler;
import org.apache.cxf.rs.security.saml.SamlHeaderOutInterceptor;
import org.apache.cxf.ws.security.trust.STSClient;
import org.talend.esb.security.saml.STSRESTOutInterceptor;
import org.talend.esb.security.saml.WSPasswordCallbackHandler;

public class SAMLRESTUtils {
    public static final String SIGNATURE_PASSWORD = "ws-security.signature.password";
    private static final String SAML2_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    private static final String BEARER_KEYTYPE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";

    private SAMLRESTUtils() {
    }

    public static void configureClient(AbstractJAXRSFactoryBean clientFactory, STSClient stsClient) {
        stsClient.setAllowRenewingAfterExpiry(true);
        stsClient.setEnableLifetime(true);
        stsClient.setTokenType(SAML2_TOKEN_TYPE);
        stsClient.setKeyType(BEARER_KEYTYPE);
        STSRESTOutInterceptor outInterceptor = new STSRESTOutInterceptor();
        outInterceptor.setStsClient(stsClient);
        clientFactory.getOutInterceptors().add(outInterceptor);
        clientFactory.getOutInterceptors().add(new SamlHeaderOutInterceptor());
    }

    public static void configureServer(AbstractJAXRSFactoryBean serverFactory, Map<String, Object> securityProps) {
        Map props = serverFactory.getProperties(true);
        String username = (String)securityProps.get("security.signature.username");
        props.put("security.signature.username", username);
        props.put("security.callback-handler", new WSPasswordCallbackHandler(username, (String)securityProps.get(SIGNATURE_PASSWORD)));
        props.put("security.signature.properties", securityProps.get("security.signature.properties"));
        serverFactory.setProvider((Object)new SamlHeaderInHandler());
    }
}

