/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;

public class OidcClientUtils {
    public static final String OIDC_TOKEN_ENDPOINT_LOCATION = "org.talend.esb.job.oidc.token.endpoint";
    public static final String OIDC_VALIDATION_ENDPOINT_LOCATION = "org.talend.esb.job.oidc.validation.endpoint";
    public static final String OIDC_PUBLIC_CLIENT_ID = "org.talend.esb.job.oidc.public.client.id";
    public static final String OIDC_SCOPE = "org.talend.esb.job.oidc.scope";
    private static final String DEFAULT_OIDC_SCOPE = "openid";
    private static final String DEFAULT_PUBLIC_CLIENT_ID = "aFSloIZSXHRQtA";
    private static Map<String, String> oidcProperties = new HashMap<String, String>();

    public OidcClientUtils(Map<String, String> oidcProperties) {
        OidcClientUtils.oidcProperties = oidcProperties;
    }

    public static String getTokenEndpointLocation() {
        if (System.getProperty(OIDC_TOKEN_ENDPOINT_LOCATION) != null) {
            return System.getProperty(OIDC_TOKEN_ENDPOINT_LOCATION);
        }
        return oidcProperties.get(OIDC_TOKEN_ENDPOINT_LOCATION);
    }

    public static String getValidationEndpointLocation() {
        if (System.getProperty(OIDC_VALIDATION_ENDPOINT_LOCATION) != null) {
            return System.getProperty(OIDC_VALIDATION_ENDPOINT_LOCATION);
        }
        return oidcProperties.get(OIDC_VALIDATION_ENDPOINT_LOCATION);
    }

    public static String getPublicClientID() {
        if (System.getProperty(OIDC_PUBLIC_CLIENT_ID) != null) {
            return System.getProperty(OIDC_PUBLIC_CLIENT_ID);
        }
        if (null == oidcProperties.get(OIDC_PUBLIC_CLIENT_ID)) {
            return DEFAULT_PUBLIC_CLIENT_ID;
        }
        return oidcProperties.get(OIDC_PUBLIC_CLIENT_ID);
    }

    public static String getScope() {
        if (System.getProperty(OIDC_SCOPE) != null) {
            return System.getProperty(OIDC_SCOPE);
        }
        if (null == oidcProperties.get(OIDC_SCOPE)) {
            return DEFAULT_OIDC_SCOPE;
        }
        return oidcProperties.get(OIDC_SCOPE);
    }

    public static Map<String, String> getOidcSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(OIDC_TOKEN_ENDPOINT_LOCATION, OidcClientUtils.getTokenEndpointLocation());
        settings.put(OIDC_VALIDATION_ENDPOINT_LOCATION, OidcClientUtils.getValidationEndpointLocation());
        settings.put(OIDC_PUBLIC_CLIENT_ID, OidcClientUtils.getPublicClientID());
        settings.put(OIDC_SCOPE, OidcClientUtils.getScope());
        return settings;
    }

    public static Map<String, String> parseJson(InputStream is) throws IOException {
        String str = IOUtils.readStringFromStream((InputStream)is).trim();
        if (str.length() == 0) {
            return Collections.emptyMap();
        }
        if (!str.startsWith("{") || !str.endsWith("}")) {
            throw new IOException("JSON Sequence is broken: " + str);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        str = str.substring(1, str.length() - 1).trim();
        String[] jsonPairs = str.split(",");
        for (int i = 0; i < jsonPairs.length; ++i) {
            String value;
            String pair = jsonPairs[i].trim();
            if (pair.length() == 0) continue;
            int index = pair.indexOf(":");
            String key = pair.substring(0, index).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if ((value = pair.substring(index + 1).trim()).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            map.put(key, value);
        }
        return map;
    }

    public static String oidcClientBearer(String oidcUsername, String oidcPassword) throws Exception {
        return OidcClientUtils.oidcClientBearer(oidcUsername, oidcPassword, OidcClientUtils.getOidcSettings());
    }

    public static String oidcClientBearer(String oidcUsername, String oidcPassword, Map<String, String> settings) throws Exception {
        Map<String, String> responseMap;
        if (oidcUsername == null || oidcUsername.isEmpty()) {
            throw new IllegalArgumentException("OIDC username is a required parameter");
        }
        if (oidcPassword == null) {
            throw new IllegalArgumentException("OIDC password is a required parameter");
        }
        String tokenEndpoint = settings.get(OIDC_TOKEN_ENDPOINT_LOCATION);
        if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
            throw new Exception("Token endpoint setting is null or empty");
        }
        String clientId = settings.get(OIDC_PUBLIC_CLIENT_ID);
        if (clientId == null || clientId.isEmpty()) {
            throw new Exception("OIDC client ID setting is null or empty");
        }
        String scope = settings.get(OIDC_SCOPE);
        if (scope == null || scope.isEmpty()) {
            scope = DEFAULT_OIDC_SCOPE;
        }
        WebClient webClient = WebClient.create((String)tokenEndpoint, Collections.singletonList(new JSONProvider())).type("application/x-www-form-urlencoded");
        Response response = webClient.post((Object)("grant_type=password&scope=" + scope + "&username=" + oidcUsername + "&password=" + oidcPassword + "&client_id=" + clientId));
        try {
            responseMap = OidcClientUtils.parseJson((InputStream)response.getEntity());
        }
        catch (Exception ex) {
            throw new Exception("Can not parse response from  OIDC Access Token service: ", ex);
        }
        if (response.getStatus() != 200) {
            if (responseMap.get("error") != null) {
                throw new Exception("OIDC Access Token request failed: " + responseMap.get("error"));
            }
            throw new Exception("OIDC token endpoint replied with HTTTP " + response.getStatus() + " on token request");
        }
        if (!"Bearer".equals(responseMap.get("token_type"))) {
            throw new Exception("Token returned from OIDC Access Token service is not of Bearer type");
        }
        return "Bearer " + responseMap.get("access_token");
    }
}

