/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.saml.SamlFormOutInterceptor;
import org.apache.cxf.rs.security.saml.SamlHeaderOutInterceptor;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;

public class STSRESTOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private STSClient stsClient;
    private SecurityToken securityToken;

    public STSRESTOutInterceptor() {
        super("write");
        this.addBefore(SamlFormOutInterceptor.class.getName());
        this.addBefore(SamlHeaderOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        if (!this.isRequestor(message)) {
            return;
        }
        if (null != this.securityToken && !this.securityToken.isExpired() && null != this.securityToken.getToken()) {
            message.put((Object)"rs-security.saml.token.element", (Object)this.securityToken.getToken());
            return;
        }
        if (null == this.stsClient) {
            return;
        }
        try {
            Object o;
            Object token = message.getContextualProperty("security.sts.token.act-as");
            if (token != null) {
                this.stsClient.setActAs(token);
            }
            if ((token = message.getContextualProperty("security.sts.token.on-behalf-of")) != null) {
                this.stsClient.setOnBehalfOf(token);
            }
            String appliesTo = null == (o = message.getContextualProperty("security.sts.applies-to")) ? null : o.toString();
            appliesTo = null == appliesTo ? message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString() : appliesTo;
            this.stsClient.setMessage(message);
            SecurityToken tok = null;
            tok = null == this.securityToken ? this.stsClient.requestSecurityToken(appliesTo) : this.stsClient.renewSecurityToken(this.securityToken);
            this.securityToken = tok;
            if (null != this.securityToken && !this.securityToken.isExpired() && null != this.securityToken.getToken()) {
                message.put((Object)"rs-security.saml.token.element", (Object)this.securityToken.getToken());
                return;
            }
        }
        catch (RuntimeException ex) {
            throw new Fault((Throwable)ex);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    public STSClient getStsClient() {
        return this.stsClient;
    }

    public void setStsClient(STSClient stsClient) {
        this.stsClient = stsClient;
    }
}

