/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.saml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.trust.STSClient;
import org.talend.esb.security.saml.ClaimsBuilder;

public class STSClientUtils {
    private static final String STS_WSDL_LOCATION = "sts.wsdl.location";
    private static final String STS_X509_WSDL_LOCATION = "sts.x509.wsdl.location";
    private static final String STS_NAMESPACE = "sts.namespace";
    private static final String STS_SERVICE_NAME = "sts.service.name";
    private static final String STS_ENDPOINT_NAME = "sts.endpoint.name";
    private static final String STS_X509_ENDPOINT_NAME = "sts.x509.endpoint.name";
    private static final String STS_TOKEN_TYPE = "sts.tokentype";
    private static final String STS_KEY_TYPE = "sts.keytype";
    private static final String STS_ALLOW_RENEWING = "sts.allow.renewing";
    private static Map<String, String> stsProperties;

    public STSClientUtils(Map<String, String> stsProperties) {
        STSClientUtils.stsProperties = stsProperties;
    }

    public static STSClient createSTSClient(Bus bus, Map<String, String> stsProps) {
        STSClient stsClient = STSClientUtils.createClient(bus, stsProps);
        stsClient.setWsdlLocation(stsProps.get(STS_WSDL_LOCATION));
        stsClient.setEndpointQName(new QName(stsProps.get(STS_NAMESPACE), stsProps.get(STS_ENDPOINT_NAME)));
        return stsClient;
    }

    public static STSClient createSTSClient(Bus bus, String username, String password) {
        HashMap<String, String> stsProps = new HashMap<String, String>(stsProperties);
        stsProps.put("security.username", username);
        stsProps.put("security.password", password);
        return STSClientUtils.createSTSClient(bus, stsProps);
    }

    public static STSClient createSTSX509Client(Bus bus, Map<String, String> stsProps) {
        STSClient stsClient = STSClientUtils.createClient(bus, stsProps);
        stsClient.setWsdlLocation(stsProps.get(STS_X509_WSDL_LOCATION));
        stsClient.setEndpointQName(new QName(stsProps.get(STS_NAMESPACE), stsProps.get(STS_X509_ENDPOINT_NAME)));
        return stsClient;
    }

    public static STSClient createSTSX509Client(Bus bus, String alias) {
        HashMap<String, String> stsProps = new HashMap<String, String>(stsProperties);
        stsProps.put("security.sts.token.username", alias);
        return STSClientUtils.createSTSX509Client(bus, stsProps);
    }

    public static void applyAuthorization(STSClient stsClient, String role) {
        if (null != role && role.length() > 0) {
            stsClient.setClaims((Object)ClaimsBuilder.createClaimValue(role));
        } else {
            stsClient.setClaims((Object)ClaimsBuilder.createClaimType());
        }
    }

    private static STSClient createClient(Bus bus, Map<String, String> stsProps) {
        STSClient stsClient = new STSClient(bus);
        stsClient.setServiceQName(new QName(stsProps.get(STS_NAMESPACE), stsProps.get(STS_SERVICE_NAME)));
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : stsProps.entrySet()) {
            if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
            props.put(entry.getKey(), STSClientUtils.processFileURI(entry.getValue()));
        }
        stsClient.setProperties(props);
        stsClient.setEnableLifetime(true);
        if (stsProps.get(STS_TOKEN_TYPE) != null) {
            stsClient.setTokenType(stsProps.get(STS_TOKEN_TYPE));
        }
        if (stsProps.get(STS_KEY_TYPE) != null) {
            stsClient.setKeyType(stsProps.get(STS_KEY_TYPE));
        }
        stsClient.setAllowRenewingAfterExpiry(true);
        if (stsProps.get(STS_ALLOW_RENEWING) != null) {
            stsClient.setAllowRenewing(Boolean.valueOf(stsProps.get(STS_ALLOW_RENEWING)).booleanValue());
        }
        return stsClient;
    }

    private static Object processFileURI(String fileURI) {
        if (null != fileURI && fileURI.startsWith("file:")) {
            try {
                return new URL(fileURI);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURI;
    }
}

