/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.talend.esb.security.oidc.OIDCRESTOutInterceptor;
import org.talend.esb.security.oidc.OidcConfiguration;

public class OidcClientUtils {
    private static OidcConfiguration oidcConfiguration = new OidcConfiguration();

    public OidcClientUtils(Map<String, String> oidcProperties) {
        oidcConfiguration = new OidcConfiguration(oidcProperties);
    }

    public OidcClientUtils(OidcConfiguration oidcConfiguration) {
        OidcClientUtils.oidcConfiguration = oidcConfiguration;
    }

    public static String getValidationEndpoint() {
        return oidcConfiguration.getValidationEndpoint();
    }

    public static String getTokenEndpoint() {
        return oidcConfiguration.getTokenEndpoint();
    }

    public static String getScope() {
        return oidcConfiguration.getScope();
    }

    public static String getPublicClientID() {
        return oidcConfiguration.getPublicClientId();
    }

    public static OidcConfiguration getOidcConfiguration() {
        return oidcConfiguration;
    }

    public static Map<String, String> parseJson(InputStream is) throws IOException {
        String str = IOUtils.readStringFromStream((InputStream)is).trim();
        if (str.length() == 0) {
            return Collections.emptyMap();
        }
        if (!str.startsWith("{") || !str.endsWith("}")) {
            throw new IOException("JSON Sequence is broken: " + str);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        str = str.substring(1, str.length() - 1).trim();
        String[] jsonPairs = str.split(",");
        for (int i = 0; i < jsonPairs.length; ++i) {
            String value;
            String pair = jsonPairs[i].trim();
            if (pair.length() == 0) continue;
            int index = pair.indexOf(":");
            String key = pair.substring(0, index).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if ((value = pair.substring(index + 1).trim()).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            map.put(key, value);
        }
        return map;
    }

    public static String oidcClientBearer(String oidcUsername, String oidcPassword) throws Exception {
        return OidcClientUtils.oidcClientBearer(oidcUsername, oidcPassword, oidcConfiguration);
    }

    public static String oidcClientBearer(String oidcUsername, String oidcPassword, Map<String, String> oidcProperties) throws Exception {
        return OidcClientUtils.oidcClientBearer(oidcUsername, oidcPassword, new OidcConfiguration(oidcProperties));
    }

    public static String oidcClientBearer(String oidcUsername, String oidcPassword, OidcConfiguration oidcConfiguration) throws Exception {
        Map<String, String> responseMap;
        if (oidcConfiguration == null) {
            throw new IllegalArgumentException("OIDC configuration is not set");
        }
        if (oidcUsername == null || oidcUsername.isEmpty()) {
            throw new IllegalArgumentException("OIDC username is a required parameter");
        }
        if (oidcPassword == null) {
            throw new IllegalArgumentException("OIDC password is a required parameter");
        }
        String tokenEndpoint = oidcConfiguration.getTokenEndpoint();
        if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
            throw new Exception("Token endpoint setting is null or empty");
        }
        String clientId = oidcConfiguration.getPublicClientId();
        if (clientId == null || clientId.isEmpty()) {
            throw new Exception("OIDC client ID setting is null or empty");
        }
        String scope = oidcConfiguration.getScope();
        WebClient webClient = WebClient.create((String)tokenEndpoint, Collections.singletonList(new JSONProvider())).type("application/x-www-form-urlencoded");
        Response response = webClient.post((Object)("grant_type=password&scope=" + scope + "&username=" + oidcUsername + "&password=" + oidcPassword + "&client_id=" + clientId));
        try {
            responseMap = OidcClientUtils.parseJson((InputStream)response.getEntity());
        }
        catch (Exception ex) {
            throw new Exception("Can not parse response from  OIDC Access Token service: ", ex);
        }
        if (response.getStatus() != 200) {
            if (responseMap.get("error") != null) {
                throw new Exception("OIDC Access Token request failed: " + responseMap.get("error"));
            }
            throw new Exception("OIDC token endpoint replied with HTTTP " + response.getStatus() + " on token request");
        }
        if (!"Bearer".equals(responseMap.get("token_type"))) {
            throw new Exception("Token returned from OIDC Access Token service is not of Bearer type");
        }
        return "Bearer " + responseMap.get("access_token");
    }

    public static void configureClient(AbstractJAXRSFactoryBean clientFactory, String username, String password, Map<String, String> oidcProperties) {
        OIDCRESTOutInterceptor outInterceptor = new OIDCRESTOutInterceptor(username, password, oidcProperties);
        clientFactory.getOutInterceptors().add(outInterceptor);
    }
}

