/*
 * Decompiled with CFR 0.152.
 */
package org.tamilnadujug;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.tamilnadujug.sql.ParamMapper;
import org.tamilnadujug.sql.RowMapper;
import org.tamilnadujug.sql.Sql;
import org.tamilnadujug.sql.StatementMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class SqlBuilder
implements Sql<Integer> {
    private final String sql;

    protected SqlBuilder(String theSql) {
        this.sql = theSql;
    }

    public static CallableSqlBuilder prepareCall(String theSql) {
        return new CallableSqlBuilder(theSql);
    }

    public static PreparedSqlBuilder prepareSql(String theSql) {
        return new PreparedSqlBuilder(theSql);
    }

    public static SqlBuilder sql(String theSql) {
        return new SqlBuilder(theSql);
    }

    protected String getSql() {
        return this.sql;
    }

    @Override
    public Integer execute(Connection connection) throws SQLException {
        int updatedRows;
        try (Statement stmt = connection.createStatement();){
            updatedRows = stmt.executeUpdate(this.getSql());
        }
        return updatedRows;
    }

    public Sql<Boolean> queryForExists() {
        return this::exists;
    }

    public Sql<Byte> queryForByte() {
        return this.queryForOne(RowMapper.BYTE_MAPPER);
    }

    public Sql<List<Byte>> queryForListOfByte() {
        return this.queryForList(RowMapper.BYTE_MAPPER);
    }

    public Sql<byte[]> queryForBytes() {
        return this.queryForOne(RowMapper.BYTES_MAPPER);
    }

    public Sql<List<byte[]>> queryForListOfBytes() {
        return this.queryForList(RowMapper.BYTES_MAPPER);
    }

    public Sql<Integer> queryForInt() {
        return this.queryForOne(RowMapper.INTEGER_MAPPER);
    }

    public Sql<List<Integer>> queryForListOfInt() {
        return this.queryForList(RowMapper.INTEGER_MAPPER);
    }

    public Sql<Short> queryForShort() {
        return this.queryForOne(RowMapper.SHORT_MAPPER);
    }

    public Sql<List<Short>> queryForListOfShort() {
        return this.queryForList(RowMapper.SHORT_MAPPER);
    }

    public Sql<String> queryForString() {
        return this.queryForOne(RowMapper.STRING_MAPPER);
    }

    public Sql<List<String>> queryForListOfString() {
        return this.queryForList(RowMapper.STRING_MAPPER);
    }

    public Sql<URL> queryForURL() {
        return this.queryForOne(RowMapper.URL_MAPPER);
    }

    public Sql<List<URL>> queryForListOfURL() {
        return this.queryForList(RowMapper.URL_MAPPER);
    }

    public Sql<Double> queryForDouble() {
        return this.queryForOne(RowMapper.DOUBLE_MAPPER);
    }

    public Sql<List<Double>> queryForListOfDouble() {
        return this.queryForList(RowMapper.DOUBLE_MAPPER);
    }

    public Sql<Float> queryForFloat() {
        return this.queryForOne(RowMapper.FLOAT_MAPPER);
    }

    public Sql<List<Float>> queryForListOfFloat() {
        return this.queryForList(RowMapper.FLOAT_MAPPER);
    }

    public Sql<BigDecimal> queryForBigDecimal() {
        return this.queryForOne(RowMapper.BIG_DECIMAL_MAPPER);
    }

    public Sql<List<BigDecimal>> queryForListOfBigDecimal() {
        return this.queryForList(RowMapper.BIG_DECIMAL_MAPPER);
    }

    public Sql<Boolean> queryForBoolean() {
        return this.queryForOne(RowMapper.BOOLEAN_MAPPER);
    }

    public Sql<List<Boolean>> queryForListOfBoolean() {
        return this.queryForList(RowMapper.BOOLEAN_MAPPER);
    }

    public Sql<Long> queryForLong() {
        return this.queryForOne(RowMapper.LONG_MAPPER);
    }

    public Sql<List<Long>> queryForListOfLong() {
        return this.queryForList(RowMapper.LONG_MAPPER);
    }

    public Sql<Date> queryForDate() {
        return this.queryForOne(RowMapper.DATE_MAPPER);
    }

    public Sql<List<Date>> queryForListOfDate() {
        return this.queryForList(RowMapper.DATE_MAPPER);
    }

    public Sql<Time> queryForTime() {
        return this.queryForOne(RowMapper.TIME_MAPPER);
    }

    public Sql<List<Time>> queryForListOfTime() {
        return this.queryForList(RowMapper.TIME_MAPPER);
    }

    public Sql<Timestamp> queryForTimestamp() {
        return this.queryForOne(RowMapper.TIMESTAMP_MAPPER);
    }

    public Sql<List<Timestamp>> queryForListOfTimestamp() {
        return this.queryForList(RowMapper.TIMESTAMP_MAPPER);
    }

    public Sql<Object> queryForObject() {
        return this.queryForOne(RowMapper.OBJECT_MAPPER);
    }

    public Sql<List<Object>> queryForListOfObject() {
        return this.queryForList(RowMapper.OBJECT_MAPPER);
    }

    public <T> Sql<T> queryForOne(RowMapper<T> rowMapper) {
        return connection -> {
            Object result = null;
            try (Statement stmt = connection.createStatement();
                 ResultSet rs = stmt.executeQuery(this.getSql());){
                if (rs.next()) {
                    result = rowMapper.get(rs);
                }
            }
            return result;
        };
    }

    public <T> Sql<List<T>> queryForList(RowMapper<T> rowMapper) {
        return connection -> {
            ArrayList result = new ArrayList();
            try (Statement stmt = connection.createStatement();
                 ResultSet rs = stmt.executeQuery(this.getSql());){
                while (rs.next()) {
                    result.add(rowMapper.get(rs));
                }
            }
            return result;
        };
    }

    protected boolean exists(Connection connection) throws SQLException {
        boolean exists;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.getSql());){
            exists = rs.next();
        }
        return exists;
    }

    public Batch addBatch(String sqlQuery) {
        return new Batch(sqlQuery);
    }

    public Sql<Byte> queryGeneratedKeyForByte() {
        return this.queryGeneratedKeys(RowMapper.BYTE_MAPPER);
    }

    public Sql<List<Byte>> queryGeneratedKeysAsListOfByte() {
        return this.queryGeneratedKeysAsList(RowMapper.BYTE_MAPPER);
    }

    public Sql<byte[]> queryGeneratedKeyForBytes() {
        return this.queryGeneratedKeys(RowMapper.BYTES_MAPPER);
    }

    public Sql<List<byte[]>> queryGeneratedKeysAsListOfBytes() {
        return this.queryGeneratedKeysAsList(RowMapper.BYTES_MAPPER);
    }

    public Sql<Integer> queryGeneratedKeyForInt() {
        return this.queryGeneratedKeys(RowMapper.INTEGER_MAPPER);
    }

    public Sql<List<Integer>> queryGeneratedKeysAsListOfInt() {
        return this.queryGeneratedKeysAsList(RowMapper.INTEGER_MAPPER);
    }

    public Sql<Short> queryGeneratedKeyForShort() {
        return this.queryGeneratedKeys(RowMapper.SHORT_MAPPER);
    }

    public Sql<List<Short>> queryGeneratedKeysAsListOfShort() {
        return this.queryGeneratedKeysAsList(RowMapper.SHORT_MAPPER);
    }

    public Sql<String> queryGeneratedKeyForString() {
        return this.queryGeneratedKeys(RowMapper.STRING_MAPPER);
    }

    public Sql<List<String>> queryGeneratedKeysAsListOfString() {
        return this.queryGeneratedKeysAsList(RowMapper.STRING_MAPPER);
    }

    public Sql<URL> queryGeneratedKeyForURL() {
        return this.queryGeneratedKeys(RowMapper.URL_MAPPER);
    }

    public Sql<List<URL>> queryGeneratedKeysAsListOfURL() {
        return this.queryGeneratedKeysAsList(RowMapper.URL_MAPPER);
    }

    public Sql<Double> queryGeneratedKeyForDouble() {
        return this.queryGeneratedKeys(RowMapper.DOUBLE_MAPPER);
    }

    public Sql<List<Double>> queryGeneratedKeysAsListOfDouble() {
        return this.queryGeneratedKeysAsList(RowMapper.DOUBLE_MAPPER);
    }

    public Sql<Float> queryGeneratedKeyForFloat() {
        return this.queryGeneratedKeys(RowMapper.FLOAT_MAPPER);
    }

    public Sql<List<Float>> queryGeneratedKeysAsListOfFloat() {
        return this.queryGeneratedKeysAsList(RowMapper.FLOAT_MAPPER);
    }

    public Sql<BigDecimal> queryGeneratedKeyForBigDecimal() {
        return this.queryGeneratedKeys(RowMapper.BIG_DECIMAL_MAPPER);
    }

    public Sql<List<BigDecimal>> queryGeneratedKeysAsListOfBigDecimal() {
        return this.queryGeneratedKeysAsList(RowMapper.BIG_DECIMAL_MAPPER);
    }

    public Sql<Boolean> queryGeneratedKeyForBoolean() {
        return this.queryGeneratedKeys(RowMapper.BOOLEAN_MAPPER);
    }

    public Sql<List<Boolean>> queryGeneratedKeysAsListOfBoolean() {
        return this.queryGeneratedKeysAsList(RowMapper.BOOLEAN_MAPPER);
    }

    public Sql<Long> queryGeneratedKeyForLong() {
        return this.queryGeneratedKeys(RowMapper.LONG_MAPPER);
    }

    public Sql<List<Long>> queryGeneratedKeysAsListOfLong() {
        return this.queryGeneratedKeysAsList(RowMapper.LONG_MAPPER);
    }

    public Sql<Date> queryGeneratedKeyForDate() {
        return this.queryGeneratedKeys(RowMapper.DATE_MAPPER);
    }

    public Sql<List<Date>> queryGeneratedKeysAsListOfDate() {
        return this.queryGeneratedKeysAsList(RowMapper.DATE_MAPPER);
    }

    public Sql<Time> queryGeneratedKeyForTime() {
        return this.queryGeneratedKeys(RowMapper.TIME_MAPPER);
    }

    public Sql<List<Time>> queryGeneratedKeysAsListOfTime() {
        return this.queryGeneratedKeysAsList(RowMapper.TIME_MAPPER);
    }

    public Sql<Timestamp> queryGeneratedKeyForTimestamp() {
        return this.queryGeneratedKeys(RowMapper.TIMESTAMP_MAPPER);
    }

    public Sql<List<Timestamp>> queryGeneratedKeysAsListOfTimestamp() {
        return this.queryGeneratedKeysAsList(RowMapper.TIMESTAMP_MAPPER);
    }

    public Sql<Object> queryGeneratedKeyForObject() {
        return this.queryGeneratedKeys(RowMapper.OBJECT_MAPPER);
    }

    public Sql<List<Object>> queryGeneratedKeysAsListOfObject() {
        return this.queryGeneratedKeysAsList(RowMapper.OBJECT_MAPPER);
    }

    public <T> Sql<T> queryGeneratedKeys(RowMapper<T> rowMapper) {
        return connection -> {
            Object result = null;
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate(this.getSql(), 1);
                try (ResultSet rs = stmt.getGeneratedKeys();){
                    if (rs.next()) {
                        result = rowMapper.get(rs);
                    }
                }
            }
            return result;
        };
    }

    public <T> Sql<List<T>> queryGeneratedKeysAsList(RowMapper<T> rowMapper) {
        return connection -> {
            ArrayList result = new ArrayList();
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate(this.getSql(), 1);
                try (ResultSet rs = stmt.getGeneratedKeys();){
                    while (rs.next()) {
                        result.add(rowMapper.get(rs));
                    }
                }
            }
            return result;
        };
    }

    public static final class CallableSqlBuilder
    implements Sql<Boolean> {
        private final PreparedSqlBuilder preparedSqlBuilder;
        private final CallableSqlBuilderWrapper callableSqlBuilderWrapper;

        public CallableSqlBuilder(String theSql) {
            this.preparedSqlBuilder = new PreparedSqlBuilder(theSql);
            this.callableSqlBuilderWrapper = new CallableSqlBuilderWrapper();
        }

        @Override
        public Boolean execute(Connection connection) throws SQLException {
            boolean success;
            try (CallableStatement ps = this.getStatement(connection, this.preparedSqlBuilder.getSql());){
                success = ps.execute();
            }
            return success;
        }

        private CallableStatement getStatement(Connection connection, String theSql) throws SQLException {
            CallableStatement ps = connection.prepareCall(theSql);
            this.prepare(ps);
            return ps;
        }

        private PreparedStatement prepare(PreparedStatement ps) throws SQLException {
            return this.prepare(ps, this.preparedSqlBuilder.paramMappers);
        }

        private PreparedStatement prepare(PreparedStatement ps, List<ParamMapper> pMappers) throws SQLException {
            for (int i = 0; i < pMappers.size(); ++i) {
                pMappers.get(i).set(ps, i + 1);
            }
            return ps;
        }

        public CallableSqlBuilder paramNull() {
            this.preparedSqlBuilder.paramNull();
            return this;
        }

        public CallableSqlBuilder paramNull(int sqlType, String typeName) {
            this.preparedSqlBuilder.paramNull(sqlType, typeName);
            return this;
        }

        public CallableSqlBuilder param(Integer value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Short value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(String value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Double value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Boolean value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Long value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Date value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Float value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(byte[] value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(BigDecimal value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Time value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Timestamp value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Object value) {
            return this.inParam(value);
        }

        public CallableSqlBuilder param(Object value, int targetSqlType) {
            this.preparedSqlBuilder.param(value, targetSqlType);
            return this;
        }

        public CallableSqlBuilderWrapper outParam(int type) {
            this.preparedSqlBuilder.param((PreparedStatement ps, int index) -> ((CallableStatement)ps).registerOutParameter(index, type));
            return this.callableSqlBuilderWrapper;
        }

        private <T> CallableSqlBuilderWrapper inOutParam(int type, T value) {
            this.preparedSqlBuilder.param((PreparedStatement ps, int index) -> {
                new PreparedSqlBuilder((String)this.preparedSqlBuilder.getSql()).param((Object)value).paramMappers.get(0).set(ps, index);
                ((CallableStatement)ps).registerOutParameter(index, type);
            });
            return this.callableSqlBuilderWrapper;
        }

        private <T> CallableSqlBuilder inParam(T value) {
            this.preparedSqlBuilder.param(value);
            return this;
        }

        public CallableSqlBuilderWrapper outParam(int type, Integer value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Short value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, String value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Double value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Boolean value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Long value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Date value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Float value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, byte[] value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, BigDecimal value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Time value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Timestamp value) {
            return this.inOutParam(type, value);
        }

        public CallableSqlBuilderWrapper outParam(int type, Object value) {
            return this.inOutParam(type, value);
        }

        private <T> Sql<T> queryOutParams(StatementMapper<T> mapper) {
            return connection -> {
                Object result;
                try (CallableStatement ps = this.getStatement(connection, this.preparedSqlBuilder.getSql());){
                    ps.execute();
                    result = mapper.get(ps);
                }
                return result;
            };
        }

        public CallableBatch addBatch() {
            return new CallableBatch();
        }

        public final class CallableSqlBuilderWrapper
        implements Sql<Boolean> {
            private final CallableSqlBuilder callableSqlBuilder;

            private CallableSqlBuilderWrapper() {
                this.callableSqlBuilder = CallableSqlBuilder.this;
            }

            public CallableSqlBuilderWrapper param(Short value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            @Override
            public Boolean execute(Connection connection) throws SQLException {
                return this.callableSqlBuilder.execute(connection);
            }

            public CallableSqlBuilderWrapper outParam(int type, String value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper paramNull() {
                this.callableSqlBuilder.paramNull();
                return this;
            }

            public CallableSqlBuilderWrapper outParam(int type, Float value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper param(Float value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper param(Date value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper paramNull(int sqlType, String typeName) {
                this.callableSqlBuilder.paramNull(sqlType, typeName);
                return this;
            }

            public CallableSqlBuilderWrapper param(Integer value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper param(BigDecimal value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper outParam(int type, Date value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper outParam(int type, Time value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper param(Long value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper param(Time value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper outParam(int type) {
                return this.callableSqlBuilder.outParam(type);
            }

            public CallableSqlBuilderWrapper outParam(int type, BigDecimal value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper outParam(int type, Timestamp value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper param(String value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper outParam(int type, byte[] value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper outParam(int type, Object value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper outParam(int type, Double value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper param(Object value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper outParam(int type, Boolean value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper outParam(int type, Long value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public <T> Sql<T> queryOutParams(StatementMapper<T> mapper) {
                return this.callableSqlBuilder.queryOutParams(mapper);
            }

            public CallableSqlBuilderWrapper param(Object value, int targetSqlType) {
                this.callableSqlBuilder.param(value, targetSqlType);
                return this;
            }

            public CallableSqlBuilderWrapper param(Double value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper param(byte[] value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper outParam(int type, Integer value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper outParam(int type, Short value) {
                return this.callableSqlBuilder.outParam(type, value);
            }

            public CallableSqlBuilderWrapper param(Boolean value) {
                this.callableSqlBuilder.param(value);
                return this;
            }

            public CallableSqlBuilderWrapper param(Timestamp value) {
                this.callableSqlBuilder.param(value);
                return this;
            }
        }

        public final class CallableBatch {
            private final int paramsPerBatch;
            private final PreparedSqlBuilder preparedSqlBuilder;
            private int capacity;

            private CallableBatch() {
                this.capacity = this.paramsPerBatch = CallableSqlBuilder.this.preparedSqlBuilder.paramMappers.size();
                this.preparedSqlBuilder = new PreparedSqlBuilder(CallableSqlBuilder.this.preparedSqlBuilder.getSql());
            }

            public CallableBatch addBatch() throws SQLException {
                this.validate();
                this.capacity += this.paramsPerBatch;
                return this;
            }

            private void validate() throws SQLException {
                if (this.preparedSqlBuilder.paramMappers.size() != this.capacity) {
                    throw new SQLException("Parameters do not match with first set of parameters");
                }
            }

            public int[] executeBatch(DataSource dataSource) throws SQLException {
                int[] updatedRows;
                this.validate();
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement ps = connection.prepareStatement(this.preparedSqlBuilder.getSql());){
                    this.prepare(ps);
                    updatedRows = ps.executeBatch();
                }
                return updatedRows;
            }

            private void prepare(PreparedStatement ps) throws SQLException {
                int batchCount = this.preparedSqlBuilder.paramMappers.size() / this.paramsPerBatch;
                CallableSqlBuilder.this.prepare(ps, CallableSqlBuilder.this.preparedSqlBuilder.paramMappers).addBatch();
                for (int i = 0; i < batchCount; ++i) {
                    int from = i * this.paramsPerBatch;
                    CallableSqlBuilder.this.prepare(ps, this.preparedSqlBuilder.paramMappers.subList(from, from + this.paramsPerBatch)).addBatch();
                }
            }

            public CallableBatch paramNull() {
                this.preparedSqlBuilder.paramNull();
                return this;
            }

            public CallableBatch paramNull(int sqlType, String typeName) {
                this.preparedSqlBuilder.paramNull(sqlType, typeName);
                return this;
            }

            public <T> CallableBatch callableParam(T value) {
                this.preparedSqlBuilder.param(value);
                return this;
            }

            public CallableBatch param(Short value) {
                return this.callableParam(value);
            }

            public CallableBatch param(String value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Integer value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Double value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Boolean value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Long value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Date value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Float value) {
                return this.callableParam(value);
            }

            public CallableBatch param(byte[] value) {
                return this.callableParam(value);
            }

            public CallableBatch param(BigDecimal value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Time value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Timestamp value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Object value) {
                return this.callableParam(value);
            }

            public CallableBatch param(Object value, int targetSqlType) {
                this.preparedSqlBuilder.param(value, targetSqlType);
                return this;
            }
        }
    }

    public static final class PreparedSqlBuilder
    extends SqlBuilder {
        private final List<ParamMapper> paramMappers = new ArrayList<ParamMapper>();

        private PreparedSqlBuilder(String theSql) {
            super(theSql);
        }

        @Override
        public Integer execute(Connection connection) throws SQLException {
            int updatedRows;
            try (PreparedStatement ps = this.getStatement(connection, this.getSql());){
                updatedRows = ps.executeUpdate();
            }
            return updatedRows;
        }

        public PreparedSqlBuilder paramNull() {
            return this.param((PreparedStatement ps, int index) -> ps.setObject(index, null));
        }

        public PreparedSqlBuilder paramNull(int sqlType, String typeName) {
            return this.param((PreparedStatement ps, int index) -> ps.setNull(index, sqlType, typeName));
        }

        public PreparedSqlBuilder param(Integer value) {
            return this.param((PreparedStatement ps, int index) -> ps.setInt(index, value));
        }

        public PreparedSqlBuilder param(Short value) {
            return this.param((PreparedStatement ps, int index) -> ps.setShort(index, value));
        }

        public PreparedSqlBuilder param(String value) {
            return this.param((PreparedStatement ps, int index) -> ps.setString(index, value));
        }

        public PreparedSqlBuilder param(Double value) {
            return this.param((PreparedStatement ps, int index) -> ps.setDouble(index, value));
        }

        public PreparedSqlBuilder param(Boolean value) {
            return this.param((PreparedStatement ps, int index) -> ps.setBoolean(index, value));
        }

        public PreparedSqlBuilder param(Long value) {
            return this.param((PreparedStatement ps, int index) -> ps.setLong(index, value));
        }

        public PreparedSqlBuilder param(Date value) {
            return this.param((PreparedStatement ps, int index) -> ps.setDate(index, value));
        }

        public PreparedSqlBuilder param(Float value) {
            return this.param((PreparedStatement ps, int index) -> ps.setFloat(index, value.floatValue()));
        }

        public PreparedSqlBuilder param(byte[] value) {
            return this.param((PreparedStatement ps, int index) -> ps.setBytes(index, value));
        }

        public PreparedSqlBuilder param(BigDecimal value) {
            return this.param((PreparedStatement ps, int index) -> ps.setBigDecimal(index, value));
        }

        public PreparedSqlBuilder param(Time value) {
            return this.param((PreparedStatement ps, int index) -> ps.setTime(index, value));
        }

        public PreparedSqlBuilder param(Timestamp value) {
            return this.param((PreparedStatement ps, int index) -> ps.setTimestamp(index, value));
        }

        public PreparedSqlBuilder param(Object value) {
            return this.param((PreparedStatement ps, int index) -> ps.setObject(index, value));
        }

        public PreparedSqlBuilder param(Object value, int targetSqlType) {
            return this.param((PreparedStatement ps, int index) -> ps.setObject(index, value, targetSqlType));
        }

        private PreparedSqlBuilder param(ParamMapper paramMapper) {
            this.paramMappers.add(paramMapper);
            return this;
        }

        private PreparedStatement prepare(PreparedStatement ps, List<ParamMapper> pMappers) throws SQLException {
            for (int i = 0; i < pMappers.size(); ++i) {
                pMappers.get(i).set(ps, i + 1);
            }
            return ps;
        }

        private PreparedStatement getStatement(Connection connection, String theSql) throws SQLException {
            return this.prepare(connection.prepareStatement(theSql), this.paramMappers);
        }

        private PreparedStatement getStatement(Connection connection, String theSql, int resultSetType) throws SQLException {
            return this.prepare(connection.prepareStatement(theSql, resultSetType), this.paramMappers);
        }

        @Override
        protected boolean exists(Connection connection) throws SQLException {
            boolean exists;
            try (PreparedStatement ps = this.getStatement(connection, this.getSql());
                 ResultSet rs = ps.executeQuery();){
                exists = rs.next();
            }
            return exists;
        }

        @Override
        public <T> Sql<T> queryForOne(RowMapper<T> query) {
            return connection -> {
                Object result = null;
                try (PreparedStatement ps = this.getStatement(connection, this.getSql());
                     ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = query.get(rs);
                    }
                }
                return result;
            };
        }

        @Override
        public <T> Sql<List<T>> queryForList(RowMapper<T> query) {
            return connection -> {
                ArrayList result = new ArrayList();
                try (PreparedStatement ps = this.getStatement(connection, this.getSql());
                     ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(query.get(rs));
                    }
                }
                return result;
            };
        }

        @Override
        public <T> Sql<T> queryGeneratedKeys(RowMapper<T> rowMapper) {
            return connection -> {
                Object result = null;
                try (PreparedStatement ps = this.getStatement(connection, this.getSql(), 1);){
                    ps.executeUpdate();
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        if (rs.next()) {
                            result = rowMapper.get(rs);
                        }
                    }
                }
                return result;
            };
        }

        @Override
        public <T> Sql<List<T>> queryGeneratedKeysAsList(RowMapper<T> rowMapper) {
            return connection -> {
                ArrayList result = new ArrayList();
                try (PreparedStatement ps = this.getStatement(connection, this.getSql(), 1);){
                    ps.executeUpdate();
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        while (rs.next()) {
                            result.add(rowMapper.get(rs));
                        }
                    }
                }
                return result;
            };
        }

        public PreparedBatch addBatch() {
            return new PreparedBatch();
        }

        public final class PreparedBatch {
            private final int paramsPerBatch;
            private final PreparedSqlBuilder preparedSqlBuilder;
            private int capacity;

            private PreparedBatch() {
                this.capacity = this.paramsPerBatch = PreparedSqlBuilder.this.paramMappers.size();
                this.preparedSqlBuilder = new PreparedSqlBuilder(PreparedSqlBuilder.this.getSql());
            }

            public PreparedBatch addBatch() throws SQLException {
                this.validate();
                this.capacity += this.paramsPerBatch;
                return this;
            }

            private void validate() throws SQLException {
                if (this.preparedSqlBuilder.paramMappers.size() != this.capacity) {
                    throw new SQLException("Parameters do not match with first set of parameters");
                }
            }

            public int[] executeBatch(DataSource dataSource) throws SQLException {
                int[] updatedRows;
                this.validate();
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement ps = connection.prepareStatement(PreparedSqlBuilder.this.getSql());){
                    this.prepare(ps);
                    updatedRows = ps.executeBatch();
                }
                return updatedRows;
            }

            private void prepare(PreparedStatement ps) throws SQLException {
                int batchCount = this.preparedSqlBuilder.paramMappers.size() / this.paramsPerBatch;
                PreparedSqlBuilder.this.prepare(ps, PreparedSqlBuilder.this.paramMappers).addBatch();
                for (int i = 0; i < batchCount; ++i) {
                    int from = i * this.paramsPerBatch;
                    PreparedSqlBuilder.this.prepare(ps, this.preparedSqlBuilder.paramMappers.subList(from, from + this.paramsPerBatch)).addBatch();
                }
            }

            public PreparedBatch paramNull() {
                this.preparedSqlBuilder.paramNull();
                return this;
            }

            public PreparedBatch paramNull(int sqlType, String typeName) {
                this.preparedSqlBuilder.paramNull(sqlType, typeName);
                return this;
            }

            public <T> PreparedBatch preparedParam(T value) {
                this.preparedSqlBuilder.param(value);
                return this;
            }

            public PreparedBatch param(Short value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(String value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Integer value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Double value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Boolean value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Long value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Date value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Float value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(byte[] value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(BigDecimal value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Time value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Timestamp value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Object value) {
                return this.preparedParam(value);
            }

            public PreparedBatch param(Object value, int targetSqlType) {
                this.preparedSqlBuilder.param(value, targetSqlType);
                return this;
            }
        }
    }

    public class Batch {
        private final List<String> sqls = new ArrayList<String>();

        public Batch(String sqlQuery) {
            this.addBatch(sqlQuery);
        }

        public Batch addBatch(String sqlQuery) {
            this.sqls.add(sqlQuery);
            return this;
        }

        public int[] executeBatch(DataSource dataSource) throws SQLException {
            int[] updatedRows;
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.addBatch(SqlBuilder.this.getSql());
                for (String batchSql : this.sqls) {
                    statement.addBatch(batchSql);
                }
                updatedRows = statement.executeBatch();
            }
            return updatedRows;
        }
    }
}

