/*
 * Decompiled with CFR 0.152.
 */
package org.tamilnadujug;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.function.Function;
import org.tamilnadujug.sql.Sql;

public class Transaction<T>
implements Sql<T> {
    private final Sql<T> sql;

    protected Transaction(Sql<T> theSql) {
        this.sql = theSql;
    }

    public static <T> Transaction<T> begin(Sql<T> sql) {
        return new Transaction<T>(sql);
    }

    public <R> Transaction<R> thenApply(Function<T, Sql<R>> tSqlFunction) {
        return new Transaction<Object>(connection -> {
            T t = this.sql.execute(connection);
            return ((Sql)tSqlFunction.apply(t)).execute(connection);
        });
    }

    @Override
    public T execute(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        T t = this.sql.execute(connection);
        connection.commit();
        connection.setAutoCommit(true);
        return t;
    }

    public <R> Transaction<R> savePoint(String savePointId, Function<T, Transaction<R>> transactionFn) {
        return new Transaction<Object>(connection -> {
            T t = this.sql.execute(connection);
            Savepoint savepoint = connection.setSavepoint(savePointId);
            Object r = null;
            try {
                r = ((Transaction)transactionFn.apply(t)).sql.execute(connection);
            }
            catch (SQLException sqlException) {
                connection.rollback(savepoint);
            }
            return r;
        });
    }
}

