/*
 * Decompiled with CFR 0.152.
 */
package org.tamilnadujug.sql;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public interface RowMapper<T> {
    public static final RowMapper<String> STRING_MAPPER = rs -> rs.getString(1);
    public static final RowMapper<Integer> INTEGER_MAPPER = rs -> rs.getInt(1);
    public static final RowMapper<Byte> BYTE_MAPPER = rs -> rs.getByte(1);
    public static final RowMapper<byte[]> BYTES_MAPPER = rs -> rs.getBytes(1);
    public static final RowMapper<Short> SHORT_MAPPER = rs -> rs.getShort(1);
    public static final RowMapper<URL> URL_MAPPER = rs -> rs.getURL(1);
    public static final RowMapper<Double> DOUBLE_MAPPER = rs -> rs.getDouble(1);
    public static final RowMapper<Float> FLOAT_MAPPER = rs -> Float.valueOf(rs.getFloat(1));
    public static final RowMapper<BigDecimal> BIG_DECIMAL_MAPPER = rs -> rs.getBigDecimal(1);
    public static final RowMapper<Boolean> BOOLEAN_MAPPER = rs -> rs.getBoolean(1);
    public static final RowMapper<Long> LONG_MAPPER = rs -> rs.getLong(1);
    public static final RowMapper<Date> DATE_MAPPER = rs -> rs.getDate(1);
    public static final RowMapper<Time> TIME_MAPPER = rs -> rs.getTime(1);
    public static final RowMapper<Timestamp> TIMESTAMP_MAPPER = rs -> rs.getTimestamp(1);
    public static final RowMapper<Object> OBJECT_MAPPER = rs -> rs.getObject(1);

    public T get(ResultSet var1) throws SQLException;
}

