/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.ArgParser;
import jive.CommonPanel;
import jive.ConsolePanel;
import jive.JiveUtils;
import jive.TransferableString;

class CommandPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TangoConst,
MouseListener,
ClipboardOwner,
DragGestureListener,
DragSourceListener {
    private CommandInfo[] cmdList;
    private ConsolePanel console;
    private DeviceProxy device;
    private CommonPanel common;
    private JList commandList;
    private JScrollPane commandView;
    private JComboBox arginCombo;
    private JLabel arginLabel;
    private JLabel descrLabel;
    private JLabel arginTypeLabel;
    private JTextField arginTypeText;
    private JLabel argoutTypeLabel;
    private JTextField argoutTypeText;
    private JButton argDescrBtn;
    private JButton executeBtn;
    private JButton plotBtn;
    private JFrame chartDlg = null;
    private JLChart chart;
    private JLDataView plotData;
    private JFrame argDescriptionDlg = null;
    private JScrollPane arginDescrView;
    private JScrollPane argoutDescrView;
    private JTextArea arginDescrText;
    private JTextArea argoutDescrText;
    private JPopupMenu copyMenu;
    private JMenuItem copyCommandMenuItem;
    private JMenuItem copyDevCommandMenuItem;

    CommandPanel(DeviceProxy ds, ConsolePanel console, CommonPanel common) throws DevFailed {
        this.setLayout(null);
        this.console = console;
        this.common = common;
        this.device = ds;
        this.cmdList = this.getCommandList();
        DefaultListModel<String> ml = new DefaultListModel<String>();
        for (int i = 0; i < this.cmdList.length; ++i) {
            ml.add(i, this.cmdList[i].cmd_name);
        }
        this.commandList = new JList(ml);
        this.commandList.addListSelectionListener(this);
        this.commandList.addMouseListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.commandList, 2, this);
        this.commandView = new JScrollPane(this.commandList);
        this.add(this.commandView);
        this.arginLabel = new JLabel("Argin value");
        this.arginLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginLabel);
        this.descrLabel = new JLabel();
        this.descrLabel.setFont(ATKConstant.labelFont);
        this.descrLabel.setHorizontalAlignment(4);
        this.add(this.descrLabel);
        this.arginCombo = new JComboBox();
        this.arginCombo.setEditable(true);
        this.arginCombo.setFont(ATKConstant.labelFont);
        this.add(this.arginCombo);
        this.arginTypeLabel = new JLabel("Argin Type");
        this.arginTypeLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginTypeLabel);
        this.arginTypeText = new JTextField();
        this.arginTypeText.setMargin(JiveUtils.noMargin);
        this.arginTypeText.setEditable(false);
        this.add(this.arginTypeText);
        this.argDescrBtn = new JButton("Show description");
        this.argDescrBtn.setFont(ATKConstant.labelFont);
        this.argDescrBtn.addActionListener(this);
        this.add(this.argDescrBtn);
        this.argoutTypeLabel = new JLabel("Argout Type");
        this.argoutTypeLabel.setFont(ATKConstant.labelFont);
        this.add(this.argoutTypeLabel);
        this.argoutTypeText = new JTextField();
        this.argoutTypeText.setMargin(JiveUtils.noMargin);
        this.argoutTypeText.setEditable(false);
        this.add(this.argoutTypeText);
        this.argDescrBtn = new JButton("Show description");
        this.argDescrBtn.setFont(ATKConstant.labelFont);
        this.argDescrBtn.addActionListener(this);
        this.add(this.argDescrBtn);
        this.executeBtn = new JButton("Execute");
        this.executeBtn.setFont(ATKConstant.labelFont);
        this.add(this.executeBtn);
        this.executeBtn.addActionListener(this);
        this.plotBtn = new JButton("Plot");
        this.plotBtn.setFont(ATKConstant.labelFont);
        this.add(this.plotBtn);
        this.plotBtn.addActionListener(this);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                CommandPanel.this.placeComponents(CommandPanel.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                CommandPanel.this.placeComponents(CommandPanel.this.getSize());
            }
        });
        this.commandList.setSelectedIndex(0);
        this.copyMenu = new JPopupMenu();
        this.copyCommandMenuItem = new JMenuItem("Copy command");
        this.copyCommandMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyCommandMenuItem);
        this.copyDevCommandMenuItem = new JMenuItem("Copy device->command");
        this.copyDevCommandMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyDevCommandMenuItem);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int idx = this.commandList.getSelectedIndex();
        if (!e.getValueIsAdjusting()) {
            this.arginCombo.setEnabled(this.cmdList[idx].in_type != 0);
            this.descrLabel.setText(this.getExample(this.cmdList[idx].in_type));
            this.arginTypeText.setText(Tango_CmdArgTypeName[this.cmdList[idx].in_type]);
            this.argoutTypeText.setText(Tango_CmdArgTypeName[this.cmdList[idx].out_type]);
            if (this.argDescriptionDlg != null) {
                this.arginDescrText.setText("Argin description:\n" + this.cmdList[idx].in_type_desc);
                this.arginDescrText.setCaretPosition(0);
                this.argoutDescrText.setText("Argout description:\n" + this.cmdList[idx].out_type_desc);
                this.argoutDescrText.setCaretPosition(0);
                this.arginDescrView.revalidate();
                this.argoutDescrView.revalidate();
            }
            this.plotBtn.setEnabled(this.isPlotable(this.cmdList[idx].out_type));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object src = e.getSource();
        if (src == this.commandList) {
            if (e.getButton() == 1 && e.getClickCount() == 2 && JOptionPane.showConfirmDialog(this, "Do you want to execute " + this.cmdList[this.commandList.getSelectedIndex()].cmd_name + "?", "Confirmation", 0) == 0) {
                this.executeCommand();
            }
            if (e.getButton() == 3) {
                this.copyMenu.show(this.commandList, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new TransferableString(this.getCopyString(false)), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext context = dragSourceDragEvent.getDragSourceContext();
        context.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.executeBtn) {
            this.executeCommand();
        } else if (src == this.plotBtn) {
            this.plotCommand();
        } else if (src == this.argDescrBtn) {
            this.showDescription();
        } else if (src == this.copyCommandMenuItem) {
            this.copyCommandToClipboard(true);
        } else if (src == this.copyDevCommandMenuItem) {
            this.copyCommandToClipboard(false);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 210);
    }

    private String getCopyString(boolean copyCmdOnly) {
        String arginStr;
        Object copyStr = "";
        CommandInfo ci = this.cmdList[this.commandList.getSelectedIndex()];
        copyStr = copyCmdOnly ? ci.cmd_name : this.device.get_name() + "->" + ci.cmd_name;
        if (this.arginCombo.isEnabled() && (arginStr = (String)this.arginCombo.getEditor().getItem()) != null && arginStr.length() > 0) {
            this.addArgin(arginStr);
            copyStr = (String)copyStr + "(" + arginStr + ")";
        }
        return copyStr;
    }

    private void copyCommandToClipboard(boolean copyCmdOnly) {
        StringSelection stringSelection = new StringSelection(this.getCopyString(copyCmdOnly));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private CommandInfo[] getCommandList() throws DevFailed {
        CommandInfo[] lst = this.device.command_list_query();
        boolean end = false;
        int j = lst.length - 1;
        while (!end) {
            end = true;
            for (int i = 0; i < j; ++i) {
                if (lst[i].cmd_name.compareToIgnoreCase(lst[i + 1].cmd_name) <= 0) continue;
                end = false;
                CommandInfo tmp = lst[i];
                lst[i] = lst[i + 1];
                lst[i + 1] = tmp;
            }
            --j;
        }
        return lst;
    }

    private boolean isPlotable(int outType) {
        switch (outType) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private void placeComponents(Dimension dim) {
        this.arginLabel.setBounds(10, 0, 80, 20);
        this.descrLabel.setBounds(90, 0, dim.width - 100, 20);
        this.arginCombo.setBounds(10, 20, dim.width - 20, 25);
        this.commandView.setBounds(10, 50, 190, dim.height - 60);
        this.commandView.revalidate();
        int dim2 = (dim.width - 220) / 2;
        this.arginTypeLabel.setBounds(205, 50, dim2, 20);
        this.arginTypeText.setBounds(205, 70, dim2, 25);
        this.argoutTypeLabel.setBounds(210 + dim2, 50, dim2, 20);
        this.argoutTypeText.setBounds(210 + dim2, 70, dim2, 25);
        int btnWidth = 200;
        int org = (dim.width - 220 - btnWidth) / 2;
        this.argDescrBtn.setBounds(205 + org, dim.height - 105, btnWidth, 25);
        this.executeBtn.setBounds(205 + org, dim.height - 70, btnWidth, 25);
        this.plotBtn.setBounds(205 + org, dim.height - 35, btnWidth, 25);
    }

    private void addArgin(String text) {
        boolean found = false;
        int i = 0;
        while (i < this.arginCombo.getItemCount() && !found) {
            found = text.equals(this.arginCombo.getItemAt(i).toString());
            if (found) continue;
            ++i;
        }
        if (!found) {
            this.arginCombo.addItem(text);
        }
    }

    private void plotCommand() {
        try {
            CommandInfo ci = this.cmdList[this.commandList.getSelectedIndex()];
            String arginStr = (String)this.arginCombo.getSelectedItem();
            if (arginStr != null) {
                this.addArgin(arginStr);
            }
            DeviceData argin = new DeviceData();
            this.insertData(arginStr, argin, ci.in_type);
            String cmd = ci.cmd_name;
            DeviceData argout = this.device.command_inout(cmd, argin);
            double[] values = this.extractPlotData(argout, ci.out_type);
            if (this.chartDlg == null) {
                this.chart = new JLChart();
                this.chart.setPreferredSize(new Dimension(640, 480));
                this.plotData = new JLDataView();
                this.chart.getY1Axis().addDataView(this.plotData);
                this.chart.getY1Axis().setAutoScale(true);
                this.chart.getXAxis().setAnnotation(2);
                this.chartDlg = new JFrame("Plot command [" + this.device.name() + "]");
                this.chartDlg.setContentPane((Container)this.chart);
            }
            this.plotData.reset();
            this.plotData.setName(cmd);
            for (int i = 0; i < values.length; ++i) {
                this.plotData.add((double)i, values[i]);
            }
            this.chart.repaint();
            if (!this.chartDlg.isVisible()) {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)this.chartDlg);
                this.chartDlg.setVisible(true);
            }
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + e1.getMessage());
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private void executeCommand() {
        try {
            CommandInfo ci = this.cmdList[this.commandList.getSelectedIndex()];
            String arginStr = (String)this.arginCombo.getSelectedItem();
            if (arginStr != null) {
                this.addArgin(arginStr);
            }
            DeviceData argin = new DeviceData();
            this.insertData(arginStr, argin, ci.in_type);
            String cmd = ci.cmd_name;
            long t0 = System.currentTimeMillis();
            DeviceData argout = this.device.command_inout(cmd, argin);
            long t1 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Command: " + this.device.name() + "/" + cmd + "\n");
            this.console.print("Duration: " + (t1 - t0) + " msec\n");
            if (arginStr != null) {
                this.console.print("Argin: " + arginStr + "\n");
            }
            if (ci.out_type == 0) {
                this.console.print("Command OK\n");
            } else {
                this.console.print("Output argument(s) :\n");
                this.console.print(this.extractData(argout, ci.out_type));
            }
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + e1.getMessage());
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private String getExample(int type) {
        Object ret_string = new String("Ex: ");
        switch (type) {
            case 0: {
                ret_string = new String("");
                break;
            }
            case 19: {
                ret_string = (String)ret_string + "0 (16bits value)";
                break;
            }
            case 1: {
                ret_string = (String)ret_string + "true,false or 0,1";
                break;
            }
            case 22: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 6: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                ret_string = (String)ret_string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 7: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 3: {
                ret_string = (String)ret_string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 4: {
                ret_string = (String)ret_string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                ret_string = (String)ret_string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                ret_string = "quotes needed for string with space or special char";
                break;
            }
            case 9: {
                ret_string = (String)ret_string + "2,0xa,'A' (signed 8bits)";
                break;
            }
            case 14: {
                ret_string = (String)ret_string + "2,0xa,4 (unsigned 16bits)";
                break;
            }
            case 10: {
                ret_string = (String)ret_string + "2,0xa,4 (signed 16bits)";
                break;
            }
            case 15: {
                ret_string = (String)ret_string + "2,0xa,4 (unsigned 32bits)";
                break;
            }
            case 11: {
                ret_string = (String)ret_string + "2,0xa,4 (signed 32bits)";
                break;
            }
            case 12: {
                ret_string = (String)ret_string + "2.3,4 (32bits floats)";
                break;
            }
            case 13: {
                ret_string = (String)ret_string + "2.3,4 (64bits floats)";
                break;
            }
            case 16: {
                ret_string = (String)ret_string + "Dance,\"the TANGO\" (quotes needed for string with space or special char)";
                break;
            }
            case 17: {
                ret_string = (String)ret_string + "[1,2][A,\"B C\",D] (quotes needed for string with space or special char)";
                break;
            }
            case 18: {
                ret_string = "[1.0,2.0][A,\"B C\",D] (quotes needed for string with space or special char)";
                break;
            }
            default: {
                ret_string = new String("");
            }
        }
        return ret_string;
    }

    private int getLimitMax(StringBuffer retStr, int length) {
        retStr.append("array length: " + length + "\n");
        if (length > this.common.getAnswerLimitMax()) {
            retStr.append("Array cannot be fully displayed. (You may change the AnswerLimitMax)\n");
            return this.common.getAnswerLimitMax();
        }
        return length;
    }

    private int getLimitMin(StringBuffer retStr, int length) {
        if (length <= this.common.getAnswerLimitMin()) {
            retStr.append("Array cannot be displayed. (You may change the AnswerLimitMin)\n");
            return length;
        }
        return this.common.getAnswerLimitMin();
    }

    private int getLimitMaxForPlot(int length) {
        if (length > this.common.getAnswerLimitMax()) {
            return this.common.getAnswerLimitMax();
        }
        return length;
    }

    private int getLimitMinForPlot(int length) {
        if (length <= this.common.getAnswerLimitMin()) {
            return length;
        }
        return this.common.getAnswerLimitMin();
    }

    private void insertData(String argin, DeviceData send, int outType) throws NumberFormatException {
        if (outType == 0) {
            return;
        }
        ArgParser arg = new ArgParser(argin);
        switch (outType) {
            case 1: {
                send.insert(arg.parse_boolean());
                break;
            }
            case 6: {
                send.insert_us(arg.parse_ushort());
                break;
            }
            case 2: {
                send.insert(arg.parse_short());
                break;
            }
            case 7: {
                send.insert_ul(arg.parse_ulong());
                break;
            }
            case 3: {
                send.insert(arg.parse_long());
                break;
            }
            case 23: {
                send.insert(arg.parse_long64());
                break;
            }
            case 24: {
                send.insert_u64(arg.parse_long64());
                break;
            }
            case 4: {
                send.insert(arg.parse_float());
                break;
            }
            case 5: {
                send.insert(arg.parse_double());
                break;
            }
            case 8: {
                send.insert(arg.parse_string());
                break;
            }
            case 9: {
                send.insert(arg.parse_char_array());
                break;
            }
            case 14: {
                send.insert_us(arg.parse_ushort_array());
                break;
            }
            case 10: {
                send.insert(arg.parse_short_array());
                break;
            }
            case 15: {
                send.insert_ul(arg.parse_ulong_array());
                break;
            }
            case 11: {
                send.insert(arg.parse_long_array());
                break;
            }
            case 25: {
                send.insert(arg.parse_long64_array());
                break;
            }
            case 26: {
                send.insert_u64(arg.parse_long64_array());
                break;
            }
            case 12: {
                send.insert(arg.parse_float_array());
                break;
            }
            case 13: {
                send.insert(arg.parse_double_array());
                break;
            }
            case 16: {
                send.insert(arg.parse_string_array());
                break;
            }
            case 17: {
                send.insert(new DevVarLongStringArray(arg.parse_long_array(), arg.parse_string_array()));
                break;
            }
            case 18: {
                send.insert(new DevVarDoubleStringArray(arg.parse_double_array(), arg.parse_string_array()));
                break;
            }
            case 19: {
                send.insert(DevState.from_int((int)arg.parse_ushort()));
                break;
            }
            default: {
                throw new NumberFormatException("Command type not supported code=" + outType);
            }
        }
    }

    private String extractData(DeviceData data, int outType) {
        StringBuffer ret_string = new StringBuffer();
        switch (outType) {
            case 0: {
                break;
            }
            case 1: {
                ret_string.append(Boolean.toString(data.extractBoolean()));
                ret_string.append("\n");
                break;
            }
            case 6: {
                ret_string.append(Integer.toString(data.extractUShort()));
                ret_string.append("\n");
                break;
            }
            case 2: {
                ret_string.append(Short.toString(data.extractShort()));
                ret_string.append("\n");
                break;
            }
            case 7: {
                ret_string.append(Long.toString(data.extractULong()));
                ret_string.append("\n");
                break;
            }
            case 24: {
                ret_string.append(Long.toString(data.extractULong64()));
                ret_string.append("\n");
                break;
            }
            case 3: {
                ret_string.append(Integer.toString(data.extractLong()));
                ret_string.append("\n");
                break;
            }
            case 23: {
                ret_string.append(Long.toString(data.extractLong64()));
                ret_string.append("\n");
                break;
            }
            case 4: {
                ret_string.append(Float.toString(data.extractFloat()));
                ret_string.append("\n");
                break;
            }
            case 5: {
                ret_string.append(Double.toString(data.extractDouble()));
                ret_string.append("\n");
                break;
            }
            case 8: 
            case 20: {
                ret_string.append(data.extractString());
                ret_string.append("\n");
                break;
            }
            case 9: {
                byte[] dummy = data.extractByteArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy[i]));
                    if (dummy[i] >= 32) {
                        ret_string.append(" '" + new Character((char)dummy[i]).toString() + "'");
                    } else {
                        ret_string.append(" '.'");
                    }
                    ret_string.append("\n");
                }
                break;
            }
            case 14: {
                int[] dummy = data.extractUShortArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 10: {
                short[] dummy = data.extractShortArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Short.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 15: {
                long[] dummy = data.extractULongArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Long.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 26: {
                long[] dummy = data.extractULong64Array();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Long.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 11: {
                int[] dummy = data.extractLongArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 25: {
                long[] dummy = data.extractULong64Array();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Long.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 12: {
                float[] dummy = data.extractFloatArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Float.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 13: {
                double[] dummy = data.extractDoubleArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t" + Double.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 16: {
                String[] dummy = data.extractStringArray();
                int start = this.getLimitMin(ret_string, dummy.length);
                int end = this.getLimitMax(ret_string, dummy.length);
                for (int i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + dummy[i] + "\n");
                }
                break;
            }
            case 17: {
                int i;
                DevVarLongStringArray dummy = data.extractLongStringArray();
                int start = this.getLimitMin(ret_string, dummy.lvalue.length);
                int end = this.getLimitMax(ret_string, dummy.lvalue.length);
                ret_string.append("lvalue:\n");
                for (i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy.lvalue[i]) + "\n");
                }
                start = this.getLimitMin(ret_string, dummy.svalue.length);
                end = this.getLimitMax(ret_string, dummy.svalue.length);
                ret_string.append("svalue:\n");
                for (i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + dummy.svalue[i] + "\n");
                }
                break;
            }
            case 18: {
                int i;
                DevVarDoubleStringArray dummy = data.extractDoubleStringArray();
                int start = this.getLimitMin(ret_string, dummy.dvalue.length);
                int end = this.getLimitMax(ret_string, dummy.dvalue.length);
                ret_string.append("dvalue:\n");
                for (i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + Double.toString(dummy.dvalue[i]) + "\n");
                }
                start = this.getLimitMin(ret_string, dummy.svalue.length);
                end = this.getLimitMax(ret_string, dummy.svalue.length);
                ret_string.append("svalue:\n");
                for (i = start; i < end; ++i) {
                    ret_string.append("[" + i + "]\t " + dummy.svalue[i] + "\n");
                }
                break;
            }
            case 19: {
                ret_string.append(Tango_DevStateName[data.extractDevState().value()]);
                ret_string.append("\n");
                break;
            }
            default: {
                ret_string.append("Unsupported command type code=" + outType);
                ret_string.append("\n");
            }
        }
        return ret_string.toString();
    }

    private double[] extractPlotData(DeviceData data, int outType) {
        double[] ret = new double[]{};
        switch (outType) {
            case 9: {
                byte[] dummy = data.extractByteArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
            case 14: {
                int[] dummy = data.extractUShortArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
            case 10: {
                short[] dummy = data.extractShortArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
            case 15: {
                long[] dummy = data.extractULongArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
            case 11: {
                int[] dummy = data.extractLongArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
            case 12: {
                float[] dummy = data.extractFloatArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
            case 13: {
                double[] dummy = data.extractDoubleArray();
                int start = this.getLimitMinForPlot(dummy.length);
                int end = this.getLimitMaxForPlot(dummy.length);
                ret = new double[end - start];
                for (int i = start; i < end; ++i) {
                    ret[i - start] = dummy[i];
                }
                break;
            }
        }
        return ret;
    }

    private void showDescription() {
        if (this.argDescriptionDlg == null) {
            JSplitPane innerPane = new JSplitPane(0);
            this.arginDescrText = new JTextArea();
            this.arginDescrText.setEditable(false);
            this.arginDescrView = new JScrollPane(this.arginDescrText);
            this.arginDescrView.setHorizontalScrollBarPolicy(32);
            this.arginDescrView.setVerticalScrollBarPolicy(22);
            innerPane.setTopComponent(this.arginDescrView);
            this.argoutDescrText = new JTextArea();
            this.argoutDescrText.setEditable(false);
            this.argoutDescrView = new JScrollPane(this.argoutDescrText);
            this.argoutDescrView.setHorizontalScrollBarPolicy(32);
            this.argoutDescrView.setVerticalScrollBarPolicy(22);
            innerPane.setBottomComponent(this.argoutDescrView);
            this.argoutDescrText.setPreferredSize(new Dimension(400, 150));
            this.arginDescrText.setPreferredSize(new Dimension(400, 150));
            this.argDescriptionDlg = new JFrame("Command description [" + this.device.name() + "]");
            this.argDescriptionDlg.setContentPane(innerPane);
        }
        int idx = this.commandList.getSelectedIndex();
        this.arginDescrText.setText("Argin description:\n" + this.cmdList[idx].in_type_desc);
        this.argoutDescrText.setText("Argout description:\n" + this.cmdList[idx].out_type_desc);
        if (!this.argDescriptionDlg.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.argDescriptionDlg);
            this.argDescriptionDlg.setVisible(true);
        } else {
            this.argDescriptionDlg.toFront();
        }
    }
}

