/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import jive.ClassPanel;
import jive.DevicePanel;
import jive.FinishPanel;
import jive.JiveUtils;
import jive.PropertyPanel;
import jive.ServerPanel;
import jive.WizardPanel;

public class DevWizard
extends JDialog
implements ActionListener {
    static final Font wizFont = new Font("Dialog", 0, 12);
    private JButton nextButton;
    private JButton backButton;
    private JButton skipButton;
    private JButton cancelButton;
    private JPanel buttoniPanel;
    private JPanel buttonPanel;
    private JPanel innerPanel;
    private JPanel helpPanel;
    private JTextArea helpText;
    private JTextArea helpIconText;
    private JLabel helpIcon;
    private JLabel helpLabel;
    private JPanel wizardContainer;
    private Vector allPanels;
    int activePanel = -1;
    private Database db;
    private String dbName;
    static DeviceProxy starter = null;
    public static String lastServStarted;

    public DevWizard(Frame parent) {
        super(parent, true);
        this.initComponents();
        starter = null;
        lastServStarted = null;
    }

    public DevWizard(Dialog parent) {
        super(parent, true);
        this.initComponents();
        starter = null;
        lastServStarted = null;
    }

    public DevWizard(Frame parent, DeviceProxy starter) {
        this(parent);
        DevWizard.starter = starter;
        lastServStarted = null;
    }

    public DevWizard(Dialog parent, DeviceProxy starter) {
        this(parent);
        DevWizard.starter = starter;
        lastServStarted = null;
    }

    public void showWizard(String[] serverList) {
        this.allPanels = new Vector();
        this.allPanels.add(new ServerPanel(this, serverList));
        this.displayWizard();
    }

    public void showClassesWizard(String serverName) {
        this.allPanels = new Vector();
        try {
            DeviceProxy admin = new DeviceProxy("dserver/" + serverName);
            this.addPanel(new ClassPanel(this, serverName, admin));
            this.displayWizard();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void showDevicesWizard(String serverName, String className) {
        this.allPanels = new Vector();
        DevicePanel devPanel = new DevicePanel(this, serverName, className);
        this.addPanel(devPanel);
        this.addPanel(new FinishPanel(this, serverName, null, devPanel));
        this.displayWizard();
    }

    public void showDeviceWizard(String serverName, String className, String devName) {
        this.allPanels = new Vector();
        try {
            DeviceData classData = new DeviceData();
            classData.insert(className);
            DeviceProxy adminDev = new DeviceProxy("dserver/" + serverName);
            DeviceData ret = adminDev.command_inout("QueryWizardDevProperty", classData);
            String[] conf = ret.extractStringArray();
            for (int j = 0; j < conf.length; j += 3) {
                this.addPanel(new PropertyPanel(this, 1, serverName, devName, conf[j], conf[j + 1], conf[j + 2], className));
            }
            this.addPanel(new FinishPanel(this, serverName, null, null));
            this.displayWizard();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private void displayWizard() {
        this.setActivePanel(0);
        JiveUtils.centerDialog(this);
        this.setVisible(true);
        this.dispose();
    }

    boolean canBack() {
        return this.activePanel > 0;
    }

    private void initComponents() {
        this.innerPanel = new JPanel(new BorderLayout());
        this.setContentPane(this.innerPanel);
        this.setResizable(false);
        this.backButton = new JButton("< Back");
        this.backButton.setFont(wizFont);
        this.backButton.addActionListener(this);
        this.nextButton = new JButton("Next >");
        this.nextButton.setFont(wizFont);
        this.nextButton.addActionListener(this);
        this.skipButton = new JButton("Skip");
        this.skipButton.setFont(wizFont);
        this.skipButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFont(wizFont);
        this.cancelButton.addActionListener(this);
        this.buttoniPanel = new JPanel();
        FlowLayout fl = new FlowLayout(2);
        this.buttoniPanel.setLayout(fl);
        this.buttoniPanel.add(this.backButton);
        this.buttoniPanel.add(this.nextButton);
        this.buttoniPanel.add(this.skipButton);
        this.buttoniPanel.add(new JLabel(" "));
        this.buttoniPanel.add(this.cancelButton);
        this.buttonPanel = new JPanel(new BorderLayout());
        this.buttonPanel.add((Component)this.buttoniPanel, "Center");
        JSeparator sep = new JSeparator();
        sep.setOrientation(0);
        this.buttonPanel.add((Component)sep, "North");
        this.innerPanel.add((Component)this.buttonPanel, "South");
        this.helpPanel = new JPanel(null);
        this.helpPanel.setPreferredSize(new Dimension(520, 240));
        this.helpIcon = new JLabel();
        this.helpIcon.setBounds(10, 10, 128, 128);
        this.helpPanel.add(this.helpIcon);
        this.helpLabel = new JLabel();
        this.helpLabel.setFont(new Font("Dialog", 1, 16));
        this.helpLabel.setBounds(140, 10, 370, 30);
        this.helpPanel.add(this.helpLabel);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setBorder(null);
        this.helpText.setBounds(140, 40, 370, 98);
        this.helpText.setBackground(this.innerPanel.getBackground());
        this.helpText.setLineWrap(true);
        this.helpText.setWrapStyleWord(true);
        this.helpPanel.add(this.helpText);
        this.helpIconText = new JTextArea();
        this.helpIconText.setEditable(false);
        this.helpIconText.setBorder(null);
        this.helpIconText.setMargin(new Insets(0, 0, 0, 0));
        this.helpIconText.setBackground(this.innerPanel.getBackground());
        this.helpIconText.setFont(new Font("Dialog", 1, 10));
        this.helpIconText.setLineWrap(true);
        this.helpIconText.setWrapStyleWord(true);
        this.helpIconText.setBounds(10, 140, 148, 95);
        this.helpPanel.add(this.helpIconText);
        this.innerPanel.add((Component)this.helpPanel, "North");
        this.wizardContainer = new JPanel(new GridLayout(1, 1));
        this.wizardContainer.setBorder(null);
        this.wizardContainer.setBounds(160, 140, 350, 95);
        this.helpPanel.add(this.wizardContainer);
        try {
            this.db = ApiUtil.get_db_obj();
            this.dbName = this.db.get_tango_host();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return;
        }
        this.setTitle("Tango Device Installation Wizard on " + this.dbName);
    }

    void addPanel(WizardPanel p) {
        this.allPanels.add(p);
    }

    void addPanel(int idx, WizardPanel p) {
        this.allPanels.add(idx, p);
    }

    WizardPanel getPanel(int i) {
        return (WizardPanel)this.allPanels.get(i);
    }

    Vector getPanels() {
        return this.allPanels;
    }

    private void setActivePanel(int p) {
        this.activePanel = p;
        WizardPanel panel = this.getPanel(p);
        this.helpIcon.setIcon(panel.getIcon());
        this.helpText.setText(panel.getDescription());
        this.helpLabel.setText(panel.getTitle());
        this.helpIconText.setText(panel.getSubTitle());
        this.wizardContainer.removeAll();
        this.wizardContainer.add(panel);
        this.backButton.setEnabled(panel.getBackState());
        this.backButton.setText(panel.getBackText());
        this.nextButton.setEnabled(panel.getNextState());
        this.nextButton.setText(panel.getNextText());
        this.skipButton.setVisible(panel.getSkipState());
        this.skipButton.setText(panel.getSkipText());
        this.innerPanel.revalidate();
        this.repaint();
    }

    private void goToNextPanel() {
        if (this.activePanel + 1 < this.allPanels.size()) {
            this.setActivePanel(this.activePanel + 1);
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.cancelButton) {
            if (JOptionPane.showConfirmDialog(this, "Do you want to exit wizard ?", "Confirmation", 0) == 0) {
                this.setVisible(false);
            }
        } else if (src == this.nextButton) {
            if (this.getPanel(this.activePanel).next()) {
                this.goToNextPanel();
            }
        } else if (src == this.backButton) {
            if (this.getPanel(this.activePanel).back()) {
                this.setActivePanel(this.activePanel - 1);
            }
        } else if (src == this.skipButton && this.getPanel(this.activePanel).skip()) {
            this.goToNextPanel();
        }
    }

    public static void main(String[] args) {
        DevWizard dlg = new DevWizard((Frame)null);
        dlg.showWizard(null);
        System.exit(0);
    }
}

