/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.DevWizard;
import jive.JiveUtils;
import jive.WizardPanel;

class FinishPanel
extends WizardPanel {
    WizardPanel backPointClass;
    WizardPanel backPointDevice;
    String serverName;

    public FinishPanel(DevWizard parent, String serverName, WizardPanel backPointC, WizardPanel backPointD) {
        this.setLayout(null);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/device_wz.gif"));
        this.parent = parent;
        this.backPointDevice = backPointD;
        this.backPointClass = backPointC;
        this.serverName = serverName;
    }

    @Override
    public String getTitle() {
        return "Configuration done";
    }

    @Override
    public String getDescription() {
        return "The configuration of the device is now ended.\nClick [New device] to add a device to this class.\nClick [New Class] to edit an other class\n";
    }

    @Override
    public boolean getNextState() {
        return this.backPointDevice != null;
    }

    @Override
    public String getNextText() {
        return "New Device";
    }

    @Override
    public boolean next() {
        this.parent.activePanel = this.parent.getPanels().indexOf(this.backPointDevice) - 1;
        return true;
    }

    @Override
    public boolean getBackState() {
        return this.backPointClass != null;
    }

    @Override
    public String getBackText() {
        return "New Class";
    }

    @Override
    public boolean back() {
        this.parent.activePanel = this.parent.getPanels().indexOf(this.backPointClass) + 1;
        return true;
    }

    @Override
    public String getSkipText() {
        return "Finish";
    }

    @Override
    public boolean getSkipState() {
        return true;
    }

    @Override
    public boolean skip() {
        if (JOptionPane.showConfirmDialog(this, "Would you like to reinitialize the server ?", "Server restart", 0) == 0) {
            try {
                DeviceProxy ds = new DeviceProxy("dserver/" + this.serverName);
                ds.command_inout("RestartServer");
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
        }
        return true;
    }
}

