/*
 * Decompiled with CFR 0.152.
 */
package jive;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import jive.Clipboard;
import jive.MessageDialog;

public class JiveUtils {
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static String[] att_prop_default = new String[]{"description", "label", "unit", "standard_unit", "display_unit", "format", "min_value", "max_value", "min_alarm", "max_alarm"};
    public static String[] att_prop_default_idl3 = new String[]{"min_warning", "max_warning", "delta_t", "delta_val", "rel_change", "abs_change", "event_period", "archive_abs_change", "archive_rel_change", "archive_period"};
    public static String[] logging_level = new String[]{"OFF", "FATAL", "ERROR", "WARNING", "INFO", "DEBUG", "TRACE"};
    public static Clipboard the_clipboard = new Clipboard();
    public static Frame parent = null;
    public static boolean readOnly = false;
    public static Vector savedClass = new Vector();
    public static Insets noMargin = new Insets(0, 0, 0, 0);
    public static boolean showSystemProperty = false;
    public static DeviceProxy hdbManager = null;
    public static boolean hdbEnabled = false;
    public static String atkPanelCmdLine = null;
    private static String starterDeviceHeader = null;

    public static int isInsideArray(String s, String[] arr) {
        boolean found = false;
        int i = 0;
        while (i < arr.length && !found) {
            found = arr[i].equalsIgnoreCase(s);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public static int isInsideVector(String s, Vector arr) {
        boolean found = false;
        int i = 0;
        while (i < arr.size() && !found) {
            found = ((String)arr.get(i)).equalsIgnoreCase(s);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public static boolean IsPollCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("is_polled") || s.equals("polling_period") || s.equals("poll_old_factor") || s.equals("poll_ring_depth");
    }

    public static int IsAttCfgItem(String s, int idl) {
        if (showSystemProperty) {
            return -1;
        }
        int i = JiveUtils.isInsideArray(s, att_prop_default);
        if (i < 0 && idl >= 3 && (i = JiveUtils.isInsideArray(s, att_prop_default_idl3)) >= 0) {
            i += att_prop_default.length;
        }
        return i;
    }

    public static boolean IsSystemItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("polled_cmd") || s.equals("polled_attr") || s.equals("non_auto_polled_cmd") || s.equals("non_auto_polled_attr");
    }

    public static boolean IsLogCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("logging_level") || s.equals("logging_target") || s.equals("current_logging_level") || s.equals("current_logging_target") || s.equals("logging_rft") || s.equals("logging_path");
    }

    public static boolean IsHdbCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("is_archived") || s.equals("archiving_settings");
    }

    public static boolean IsAlarmCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("Alarms");
    }

    public static boolean IsEventCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("Archive Event") || s.equals("Change Event") || s.equals("Periodic Event");
    }

    public static boolean isSavedClass(String className) {
        return JiveUtils.isInsideVector(className, savedClass) >= 0;
    }

    public static void addSavedClass(String className) {
        savedClass.add(className);
    }

    public static void sortList(String[] lst) {
        boolean end = false;
        int i = lst.length - 1;
        while (!end) {
            end = true;
            for (int j = 0; j < i; ++j) {
                boolean swap = false;
                int diff = lst[j].compareToIgnoreCase(lst[j + 1]);
                boolean bl = swap = diff > 0;
                if (!swap) continue;
                String tmp = lst[j + 1];
                lst[j + 1] = lst[j];
                lst[j] = tmp;
                end = false;
            }
            --i;
        }
    }

    public static void sortList(String[] lst, boolean[] v, int idl) {
        int i;
        boolean end = false;
        int[] weight = new int[lst.length];
        for (i = 0; i < lst.length; ++i) {
            weight[i] = JiveUtils.IsSystemItem(lst[i]) ? 0 : (JiveUtils.IsPollCfgItem(lst[i]) ? 1 : (JiveUtils.IsAlarmCfgItem(lst[i]) ? 2 : (JiveUtils.IsHdbCfgItem(lst[i]) ? 3 : (JiveUtils.IsLogCfgItem(lst[i]) ? 4 : (JiveUtils.IsAttCfgItem(lst[i], idl) >= 0 ? 5 : 6)))));
        }
        i = lst.length - 1;
        while (!end) {
            end = true;
            for (int j = 0; j < i; ++j) {
                boolean swap = false;
                if (weight[j] > weight[j + 1]) {
                    swap = true;
                } else if (weight[j] == weight[j + 1]) {
                    int diff = lst[j].compareToIgnoreCase(lst[j + 1]);
                    boolean bl = swap = diff > 0;
                }
                if (!swap) continue;
                String tmp = lst[j + 1];
                lst[j + 1] = lst[j];
                lst[j] = tmp;
                int tw = weight[j + 1];
                weight[j + 1] = weight[j];
                weight[j] = tw;
                if (v != null) {
                    boolean b = v[j];
                    v[j] = v[j + 1];
                    v[j + 1] = b;
                }
                end = false;
            }
            --i;
        }
    }

    public static boolean contains(String[] l, String item) {
        return JiveUtils.isInsideArray(item, l) >= 0;
    }

    public static boolean contains(int[] arr, int item) {
        boolean found = false;
        int i = 0;
        while (i < arr.length && !found) {
            found = arr[i] == item;
            if (found) continue;
            ++i;
        }
        return found;
    }

    public static String stringArrayToString(String[] res) {
        Object result = "";
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                result = (String)result + res[i];
                if (i + 1 >= res.length) continue;
                result = (String)result + "\n";
            }
        }
        return result;
    }

    public static String extractEndValue(String s) {
        int i = s.lastIndexOf(61);
        if (i != -1) {
            return s.substring(i + 2, s.length());
        }
        return "";
    }

    public static String[] extractPollingInfo(String s) {
        String[] splitted = s.split("\n");
        String[] ret = new String[5];
        ret[0] = splitted[0].startsWith("Polled attribute") ? "attribute" : "command";
        ret[1] = JiveUtils.extractEndValue(splitted[0]);
        ret[2] = JiveUtils.extractEndValue(splitted[1]);
        ret[3] = JiveUtils.extractEndValue(splitted[2]);
        Object status = "";
        for (int i = 3; i < splitted.length; ++i) {
            status = (String)status + splitted[i] + "\n";
        }
        ret[4] = status;
        return ret;
    }

    public static String[] makeStringArray(String value) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.split("\n");
    }

    public static DbDatum[] makeDbDatum(String prop_name, String value) {
        String[] splitted = JiveUtils.makeStringArray(value);
        DbDatum[] ret = new DbDatum[]{splitted.length == 1 ? new DbDatum(prop_name, splitted[0]) : new DbDatum(prop_name, splitted)};
        return ret;
    }

    public static String getPollingStatus(String devname, String name, String type, int field) {
        Object result;
        block4: {
            result = null;
            int i = 0;
            try {
                DeviceProxy ds = new DeviceProxy(devname);
                String[] pi = ds.polling_status();
                boolean found = false;
                String[] pinfo = null;
                i = 0;
                while (i < pi.length && !found) {
                    pinfo = JiveUtils.extractPollingInfo(pi[i]);
                    found = pinfo[0].equalsIgnoreCase(type) && pinfo[1].equalsIgnoreCase(name);
                    if (found) continue;
                    ++i;
                }
                if (!found) break block4;
                result = pinfo[field];
            }
            catch (DevFailed e) {
                if (field != 4) break block4;
                result = "";
                for (i = 0; i < e.errors.length; ++i) {
                    result = (String)result + "Desc -> " + e.errors[i].desc + "\n";
                    result = (String)result + "Reason -> " + e.errors[i].reason + "\n";
                    result = (String)result + "Origin -> " + e.errors[i].origin + "\n";
                }
            }
        }
        return result;
    }

    public static void addPolling(String devname, String name, String type, String polling_period) throws DevFailed {
        int period;
        try {
            period = Integer.parseInt(polling_period);
        }
        catch (NumberFormatException e) {
            JiveUtils.showJiveError("Invalid polling period " + devname + "/" + name + ":" + e.toString());
            return;
        }
        DeviceProxy ds = new DeviceProxy(devname);
        if (type.equalsIgnoreCase("command")) {
            ds.poll_command(name, period);
        } else {
            ds.poll_attribute(name, period);
        }
    }

    public static void remPolling(String devname, String name, String type) throws DevFailed {
        DeviceProxy ds = new DeviceProxy(devname);
        if (type.equalsIgnoreCase("command")) {
            ds.stop_poll_command(name);
        } else {
            ds.stop_poll_attribute(name);
        }
    }

    public static void copyClassProperties(Database db, String classname) {
        try {
            int i;
            String[] list = db.get_class_property_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] res = db.get_class_property(classname, list[i]).extractStringArray();
                the_clipboard.add(list[i], JiveUtils.stringArrayToString(res));
            }
            list = db.get_class_attribute_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_class_attribute_property(classname, att_list);
                if (lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    the_clipboard.add(list2[j], list[i], lst[0].get_string_value(j));
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public static String[] getLoggingStatus(Database db, String devname, int field) {
        String[] result = null;
        try {
            DbDevImportInfo info = db.import_device(devname);
            String devadmin = "dserver/" + info.server;
            DeviceData argin = new DeviceData();
            DeviceProxy ds = new DeviceProxy(devadmin);
            switch (field) {
                case 0: {
                    String[] names = new String[]{devname};
                    argin.insert(names);
                    DeviceData argout = ds.command_inout("GetLoggingLevel", argin);
                    DevVarLongStringArray res = argout.extractLongStringArray();
                    result = new String[]{logging_level[res.lvalue[0]]};
                    return result;
                }
                case 1: {
                    argin.insert(devname);
                    DeviceData argout = ds.command_inout("GetLoggingTarget", argin);
                    result = argout.extractStringArray();
                    return result;
                }
            }
            return null;
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return null;
        }
    }

    public static void launchAtkPanel(String devName) {
        if (atkPanelCmdLine == null && (atkPanelCmdLine = System.getProperty("ATKPANEL")) == null) {
            atkPanelCmdLine = "";
        }
        String tgHost = null;
        try {
            tgHost = ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed e) {
            atkPanelCmdLine = "";
        }
        if (atkPanelCmdLine.length() > 0) {
            try {
                ProcessBuilder p = new ProcessBuilder(new String[0]);
                ArrayList<String> cmds = new ArrayList<String>();
                cmds.add(atkPanelCmdLine);
                cmds.add(tgHost);
                cmds.add(devName);
                p.inheritIO().command(cmds).start();
            }
            catch (IOException e) {
                JiveUtils.showJiveError("Cannot launch AtkPanel\n" + e.getMessage());
            }
        } else {
            new MainPanel(devName, false, true, !readOnly);
        }
    }

    public static boolean setLoggingLevel(Database db, String devname, String level) {
        int i = JiveUtils.isInsideArray(level, logging_level);
        if (i < 0) {
            Object err = "Possible value are:";
            for (i = 0; i < logging_level.length; ++i) {
                err = (String)err + " " + logging_level[i];
            }
            JiveUtils.showJiveError("Invalid logging level value.\n" + (String)err);
            return false;
        }
        try {
            DbDevImportInfo info = db.import_device(devname);
            String devadmin = "dserver/" + info.server;
            DeviceData argin = new DeviceData();
            DeviceProxy ds = new DeviceProxy(devadmin);
            int[] l = new int[1];
            String[] s = new String[1];
            l[0] = i;
            s[0] = devname;
            DevVarLongStringArray la = new DevVarLongStringArray(l, s);
            argin.insert(la);
            ds.command_inout("SetLoggingLevel", argin);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static boolean setLoggingTarget(Database db, String devname, String tg) {
        Vector<String> toAdd = new Vector<String>();
        Vector<String> toRemove = new Vector<String>();
        String[] settg = tg.split("\n");
        try {
            String[] tin;
            int i;
            DbDevImportInfo info = db.import_device(devname);
            String devadmin = "dserver/" + info.server;
            DeviceProxy ds = new DeviceProxy(devadmin);
            DeviceData argin = new DeviceData();
            argin.insert(devname);
            DeviceData argout = ds.command_inout("GetLoggingTarget", argin);
            String[] curtg = argout.extractStringArray();
            for (i = 0; i < curtg.length; ++i) {
                if (JiveUtils.contains(settg, curtg[i])) continue;
                toRemove.add(curtg[i]);
            }
            for (i = 0; i < settg.length; ++i) {
                if (JiveUtils.contains(curtg, settg[i]) || settg[i].length() <= 0) continue;
                toAdd.add(settg[i]);
            }
            if (toRemove.size() > 0) {
                tin = new String[toRemove.size() * 2];
                for (i = 0; i < toRemove.size(); ++i) {
                    tin[2 * i] = devname;
                    tin[2 * i + 1] = (String)toRemove.get(i);
                }
                argin = new DeviceData();
                argin.insert(tin);
                ds.command_inout("RemoveLoggingTarget", argin);
            }
            if (toAdd.size() > 0) {
                tin = new String[toAdd.size() * 2];
                for (i = 0; i < toAdd.size(); ++i) {
                    tin[2 * i] = devname;
                    tin[2 * i + 1] = (String)toAdd.get(i);
                }
                argin = new DeviceData();
                argin.insert(tin);
                ds.command_inout("AddLoggingTarget", argin);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static boolean removeClassProperties(Database db, String classname) {
        String value = "%";
        try {
            int i;
            String[] list = db.get_class_property_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                db.delete_class_property(classname, JiveUtils.makeDbDatum(list[i], value));
            }
            list = db.get_class_attribute_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_class_attribute_property(classname, att_list);
                if (lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    System.out.println("Removing: " + classname + " ATT " + list[i] + " PROP " + list2[j]);
                    db.delete_class_attribute_property(classname, list[i], list2[j]);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static void copyDeviceProperties(Database db, String devname) {
        try {
            int i;
            String[] list = db.get_device_property_list(devname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] res = db.get_device_property(devname, list[i]).extractStringArray();
                the_clipboard.add(list[i], JiveUtils.stringArrayToString(res));
            }
            list = db.get_device_attribute_list(devname);
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_device_attribute_property(devname, att_list);
                if (lst == null || lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    the_clipboard.add(list2[j], list[i], lst[0].get_string_value(j));
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public static boolean removeDeviceProperties(Database db, String devname) {
        String value = "%";
        try {
            int i;
            String[] list = db.get_device_property_list(devname, "*");
            for (i = 0; i < list.length; ++i) {
                db.delete_device_property(devname, JiveUtils.makeDbDatum(list[i], value));
            }
            list = db.get_device_attribute_list(devname);
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_device_attribute_property(devname, att_list);
                if (lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    DbAttribute att = new DbAttribute(list[i]);
                    att.add(list2[j], value);
                    db.delete_device_attribute_property(devname, att);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static void showTangoError(DevFailed e) {
        if (e != null) {
            String[] result = new String[e.errors.length * 3];
            for (int i = 0; i < e.errors.length; ++i) {
                result[3 * i] = "Desc -> " + e.errors[i].desc;
                result[3 * i + 1] = "Reason -> " + e.errors[i].reason;
                result[3 * i + 2] = "Origin -> " + e.errors[i].origin;
            }
            if (result.length > 0) {
                MessageDialog.showMessageDialog(parent, "Tango error", result, 1);
            }
        }
    }

    public static void printTangoError(DevFailed e) {
        Object result = "";
        if (e != null) {
            for (int i = 0; i < e.errors.length; ++i) {
                result = (String)result + " Desc -> " + e.errors[i].desc + "\n";
                result = (String)result + " Reason -> " + e.errors[i].reason + "\n";
                result = (String)result + " Origin -> " + e.errors[i].origin + "\n";
            }
            System.out.println("Tango exception:");
            System.out.print((String)result);
        }
    }

    public static void showJiveError(String msg) {
        MessageDialog.showMessageDialog(parent, "Jive error", new String[]{msg}, 1);
    }

    public static void showJiveErrors(String[] msg) {
        MessageDialog.showMessageDialog(parent, "Jive error", msg, 1);
    }

    public static void showJiveErrors(Vector<String> msg) {
        String[] errs = new String[msg.size()];
        for (int i = 0; i < msg.size(); ++i) {
            errs[i] = msg.get(i);
        }
        MessageDialog.showMessageDialog(parent, "Jive error", errs, 1);
    }

    public static void showJiveWarning(String msg) {
        MessageDialog.showMessageDialog(parent, "Jive warning", new String[]{msg}, 2);
    }

    public static Rectangle computeBounds(JTree tree, TreePath selPath) {
        tree.scrollPathToVisible(selPath);
        Rectangle r = tree.getPathBounds(selPath);
        Point pto = r.getLocation();
        SwingUtilities.convertPointToScreen(pto, tree);
        r.setLocation(pto);
        r.width += 20;
        r.height += 2;
        return r;
    }

    public static void printFormatedRes(String name, String[] vals, FileWriter fw) throws IOException {
        int k;
        if (vals == null) {
            if (fw != null) {
                fw.write("\"\"");
            } else {
                System.out.print("\"\"");
            }
            return;
        }
        if (vals.length == 0) {
            if (fw != null) {
                fw.write("\"\"");
            } else {
                System.out.print("\"\"");
            }
            return;
        }
        Vector<String> values = new Vector<String>();
        int j = 0;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].indexOf(10) != -1) {
                String[] tmpStr = JiveUtils.makeStringArray(vals[i]);
                for (k = 0; k < tmpStr.length; ++k) {
                    values.add(tmpStr[k]);
                }
                continue;
            }
            values.add(vals[i]);
        }
        Object[] value = values.toArray();
        int shift = name.length();
        if (fw != null) {
            fw.write(name, 0, shift);
        } else {
            System.out.print(name);
        }
        for (j = 0; j < value.length; ++j) {
            String str = (String)value[j];
            if (str.length() == 0) {
                value[j] = new String("\"\"");
            }
            StringBuffer qStr = new StringBuffer(str);
            int qIdx = qStr.indexOf("\"");
            while (qIdx != -1) {
                qStr.insert(qIdx, "\\");
                qIdx = qStr.indexOf("\"", qIdx + 2);
            }
            str = qStr.toString();
            qStr = new StringBuffer(str);
            qIdx = qStr.indexOf("\\");
            while (qIdx != -1) {
                qStr.insert(qIdx, "\\");
                qIdx = qStr.indexOf("\\", qIdx + 2);
            }
            str = qStr.toString();
            if (str.indexOf(32) != -1 || str.indexOf(47) != -1 || str.indexOf(44) != -1 || str.indexOf(34) != -1) {
                value[j] = new String("\"" + str + "\"");
            }
            for (k = 0; j > 0 && k < shift; ++k) {
                if (fw != null) {
                    fw.write(32);
                    continue;
                }
                System.out.print(" ");
            }
            String to_write = j < value.length - 1 ? value[j] + ",\\ \n" : value[j] + "\n";
            if (fw != null) {
                fw.write(to_write, 0, to_write.length());
                continue;
            }
            System.out.print(to_write.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void put_device_alias(Database db, String devname, String alias) throws DevFailed {
        if (JiveUtils.isDeviceName(alias)) {
            boolean alreadyExist = true;
            try {
                db.import_device(alias);
            }
            catch (DevFailed e) {
                alreadyExist = false;
            }
            if (alreadyExist) {
                Except.throw_exception((String)"AlreadyDefined", (String)(alias + " is already defined"), (String)"JiveUtils.put_device_alias");
            }
            DeviceData argin = new DeviceData();
            String request = "update device set alias='" + alias + "' where name='" + devname + "'/*select*/;";
            argin.insert(request);
            try {
                db.command_inout("DbMySqlSelect", argin);
                return;
            }
            catch (DevFailed e) {
                if (e.errors[0].desc.contains("(error=)")) return;
                throw e;
            }
        }
        db.put_device_alias(devname, alias);
    }

    public static String convertEventString(String str) {
        int idx = str.indexOf(44);
        if (idx != -1) {
            String[] ret = str.split(",");
            return ret[0] + "\n" + ret[1];
        }
        return str;
    }

    public static void printAttInfo(AttributeInfoEx ai) {
        System.out.println("------- Attribute info -------");
        System.out.println("Name             :" + ai.name);
        System.out.println("Data format      :" + ai.data_format.value());
        System.out.println("Data type        :" + ai.data_type);
        System.out.println("Description      :" + ai.description);
        System.out.println("Display unit     :" + ai.display_unit);
        System.out.println("Std unit         :" + ai.standard_unit);
        System.out.println("Unit             :" + ai.unit);
        System.out.println("Format           :" + ai.format);
        System.out.println("Label            :" + ai.label);
        System.out.println("Disp level       :" + ai.level.value());
        System.out.println("Max alarm        :" + ai.max_alarm);
        System.out.println("Min alarm        :" + ai.min_alarm);
        System.out.println("Max value        :" + ai.max_value);
        System.out.println("Min value        :" + ai.min_value);
        System.out.println("Max DimX         :" + ai.max_dim_x);
        System.out.println("Max DimY         :" + ai.max_dim_y);
        System.out.println("Alarms.delta_t   :" + ai.alarms.delta_t);
        System.out.println("Alarms.delta_v   :" + ai.alarms.delta_val);
        System.out.println("Alarms.max       :" + ai.alarms.max_alarm);
        System.out.println("Alarms.min       :" + ai.alarms.min_alarm);
        System.out.println("Alarms.max_w     :" + ai.alarms.max_warning);
        System.out.println("Alarms.min_w     :" + ai.alarms.min_warning);
        System.out.println("ArchEvent.abs_ch :" + ai.events.arch_event.abs_change);
        System.out.println("ArchEvent.rel_ch :" + ai.events.arch_event.rel_change);
        System.out.println("ArchEvent.period :" + ai.events.arch_event.period);
        System.out.println("ChEvent.abs_ch   :" + ai.events.ch_event.abs_change);
        System.out.println("ChEvent.rel_ch   :" + ai.events.ch_event.rel_change);
        System.out.println("PerEvent.abs_ch  :" + ai.events.per_event.period);
    }

    public static void centerDialog(Dialog dlg, int dlgWidth, int dlgHeight) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null && dlg.getParent().isVisible()) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = JiveUtils.screenSize.width;
            r.height = JiveUtils.screenSize.height;
        }
        dlg.pack();
        Insets insets = dlg.getInsets();
        int wx = dlgWidth + (insets.right + insets.left);
        int wy = dlgHeight + (insets.bottom + insets.top);
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        if (xe + wx > JiveUtils.screenSize.width) {
            xe = JiveUtils.screenSize.width - wx;
        }
        if (ye + wy > JiveUtils.screenSize.height) {
            ye = JiveUtils.screenSize.height - wy;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerDialog(Dialog dlg) {
        dlg.pack();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null && dlg.getParent().isVisible()) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = JiveUtils.screenSize.width;
            r.height = JiveUtils.screenSize.height;
        }
        int wx = dlg.getPreferredSize().width;
        int wy = dlg.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        if (xe + wx > JiveUtils.screenSize.width) {
            xe = JiveUtils.screenSize.width - wx;
        }
        if (ye + wy > JiveUtils.screenSize.height) {
            ye = JiveUtils.screenSize.height - wy;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrameOnScreen(Frame fr) {
        Rectangle r = new Rectangle(0, 0, JiveUtils.screenSize.width, JiveUtils.screenSize.height);
        fr.pack();
        int wx = fr.getPreferredSize().width;
        int wy = fr.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        fr.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrameOnScreen(Frame fr, int frWidth, int frHeight) {
        Rectangle r = new Rectangle(0, 0, JiveUtils.screenSize.width, JiveUtils.screenSize.height);
        fr.pack();
        int wx = frWidth;
        int wy = frHeight;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        fr.setBounds(xe, ye, wx, wy);
    }

    public static boolean isDeviceName(String devName) {
        boolean devNamePattern;
        if (devName.length() < 5 || devName.contains(" ")) {
            return false;
        }
        String s = new String(devName);
        if (s.startsWith("tango:")) {
            s = s.substring(6);
        }
        if (!(devNamePattern = Pattern.matches("//[a-zA-Z_0-9]+:[0-9]+/[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+", s))) {
            devNamePattern = Pattern.matches("[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+/[[a-zA-Z_0-9\\.][-]]+", s);
        }
        if (!devNamePattern) {
            devNamePattern = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+:[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", s);
        }
        return devNamePattern;
    }

    public static boolean isFullServerName(String srvName) {
        return Pattern.matches("[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+", srvName);
    }

    public static String getPathAsText(TreePath path) {
        StringBuffer str = new StringBuffer();
        if (path == null) {
            str.append("null");
        } else {
            for (int i = 0; i < path.getPathCount(); ++i) {
                str.append(path.getPathComponent(i).toString());
                if (i == path.getPathCount() - 1) continue;
                str.append("/");
            }
        }
        return str.toString();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getStarterDeviceHeader() {
        if (starterDeviceHeader == null) {
            try {
                DbDatum datum = new DbClass("Starter").get_property("Domain");
                starterDeviceHeader = datum.is_empty() ? "tango/admin/" : datum.extractString() + "/admin/";
            }
            catch (DevFailed e) {
                starterDeviceHeader = "tango/admin/";
            }
        }
        return starterDeviceHeader;
    }

    public static void refreshStarterDeviceHeader() {
        starterDeviceHeader = null;
    }
}

