/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import jive.JiveUtils;

public class MessageDialog
extends JDialog {
    public static final int ERROR_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int INFORMATION_MESSAGE = 3;
    private JScrollPane scroll;
    private JTextArea textArea;
    private JLabel label;
    private JButton closeButton;
    private JPanel innerPanel = new JPanel();
    private JPanel btnPanel;
    private JButton iconButton;

    static void showMessageDialog(Frame parent, String title, String[] msg) {
        MessageDialog dlg = new MessageDialog(parent, title, msg, null);
        dlg.showDialog();
    }

    static void showMessageDialog(Frame parent, String title, String[] msg, int icon) {
        (switch (icon) {
            case 1 -> new MessageDialog(parent, title, msg, UIManager.getIcon("OptionPane.errorIcon"));
            case 2 -> new MessageDialog(parent, title, msg, UIManager.getIcon("OptionPane.warningIcon"));
            case 3 -> new MessageDialog(parent, title, msg, UIManager.getIcon("OptionPane.informationIcon"));
            default -> new MessageDialog(parent, title, msg, null);
        }).showDialog();
    }

    MessageDialog(Frame parent, String title, String[] msg, Icon icon) {
        super(parent, true);
        this.innerPanel.setLayout(new BorderLayout());
        String message = JiveUtils.stringArrayToString(msg);
        if (msg.length > 1) {
            this.textArea = new JTextArea(message);
            this.textArea.setMargin(new Insets(5, 5, 5, 10));
            this.textArea.setEditable(false);
            this.textArea.setBackground(this.innerPanel.getBackground());
            this.textArea.setFont(UIManager.getFont("Label.font"));
            this.scroll = new JScrollPane(this.textArea);
            this.scroll.setBorder(null);
            this.innerPanel.add((Component)this.scroll, "Center");
            Dimension td = this.scroll.getViewport().getPreferredSize();
            if (td.width < 400) {
                td.width = 400;
            }
            if (td.width > 800) {
                td.width = 600;
            }
            if (td.height < 60) {
                td.height = 60;
            }
            if (td.height > 400) {
                td.height = 400;
            }
            this.scroll.getViewport().setPreferredSize(td);
        } else {
            this.label = new JLabel(message);
            this.innerPanel.add((Component)this.label, "Center");
            Dimension td = this.label.getPreferredSize();
            if (td.width < 400) {
                td.width = 400;
            }
            if (td.width > 800) {
                td.width = 600;
            }
            if (td.height < 60) {
                td.height = 60;
            }
            if (td.height > 400) {
                td.height = 400;
            }
            this.label.setPreferredSize(td);
        }
        this.closeButton = new JButton("OK");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDialog.this.setVisible(false);
            }
        });
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.btnPanel.add(this.closeButton);
        this.innerPanel.add((Component)this.btnPanel, "South");
        if (icon != null) {
            this.iconButton = new JButton(icon);
            this.iconButton.setBorderPainted(false);
            this.iconButton.setContentAreaFilled(false);
            this.iconButton.setFocusPainted(false);
            this.iconButton.setOpaque(false);
            this.innerPanel.add((Component)this.iconButton, "West");
        }
        this.setContentPane(this.innerPanel);
        this.setTitle(title);
    }

    void showDialog() {
        JiveUtils.centerDialog(this);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        String[] messages = new String[20];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = "This is the line " + i;
        }
        MessageDialog.showMessageDialog(null, "Error", messages, 2);
    }
}

