/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeDataElement;
import fr.esrf.TangoApi.PipeInfo;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.ArgParser;
import jive.CommonPanel;
import jive.ConsolePanel;
import jive.TransferableString;

class PipePanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TangoConst,
MouseListener,
ClipboardOwner,
DragGestureListener,
DragSourceListener {
    private List<PipeInfo> pipeInfo;
    private ConsolePanel console;
    private DeviceProxy device;
    private CommonPanel common;
    private JComboBox arginCombo;
    private JLabel arginLabel;
    private JLabel descrLabel;
    private JList pipeList;
    private JScrollPane pipeView;
    private JTextArea descrList;
    private JScrollPane descrView;
    private JButton readBtn;
    private JButton writeBtn;
    private JButton helpBtn;
    private JPopupMenu copyMenu;
    private JMenuItem copyAttributeMenuItem;
    private JMenuItem copyDevAttributeMenuItem;

    PipePanel(DeviceProxy ds, ConsolePanel console, CommonPanel common) throws DevFailed {
        this.setLayout(null);
        this.console = console;
        this.common = common;
        this.device = ds;
        this.pipeInfo = this.getPipeInfo();
        this.arginLabel = new JLabel("Argin value");
        this.arginLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginLabel);
        this.descrLabel = new JLabel();
        this.descrLabel.setFont(ATKConstant.labelFont);
        this.descrLabel.setHorizontalAlignment(4);
        this.add(this.descrLabel);
        this.arginCombo = new JComboBox();
        this.arginCombo.setEditable(true);
        this.arginCombo.setFont(ATKConstant.labelFont);
        this.add(this.arginCombo);
        DefaultListModel<String> ml = new DefaultListModel<String>();
        for (int i = 0; i < this.pipeInfo.size(); ++i) {
            ml.add(i, this.pipeInfo.get(i).getName());
        }
        this.pipeList = new JList(ml);
        this.pipeList.addListSelectionListener(this);
        this.pipeList.addMouseListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.pipeList, 2, this);
        this.pipeView = new JScrollPane(this.pipeList);
        this.add(this.pipeView);
        this.descrList = new JTextArea();
        this.descrList.setFont(new Font("monospaced", 0, 12));
        this.descrList.setEditable(false);
        this.descrView = new JScrollPane(this.descrList);
        this.add(this.descrView);
        this.readBtn = new JButton("Read");
        this.readBtn.setFont(ATKConstant.labelFont);
        this.add(this.readBtn);
        this.readBtn.addActionListener(this);
        this.writeBtn = new JButton("Write");
        this.writeBtn.setFont(ATKConstant.labelFont);
        this.add(this.writeBtn);
        this.writeBtn.addActionListener(this);
        this.helpBtn = new JButton("Help");
        this.helpBtn.setFont(ATKConstant.labelFont);
        this.add(this.helpBtn);
        this.helpBtn.addActionListener(this);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                PipePanel.this.placeComponents(PipePanel.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                PipePanel.this.placeComponents(PipePanel.this.getSize());
            }
        });
        this.pipeList.setSelectedIndex(0);
        this.copyMenu = new JPopupMenu();
        this.copyAttributeMenuItem = new JMenuItem("Copy pipe name");
        this.copyAttributeMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyAttributeMenuItem);
        this.copyDevAttributeMenuItem = new JMenuItem("Copy device/pipe name");
        this.copyDevAttributeMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyDevAttributeMenuItem);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int idx = this.pipeList.getSelectedIndex();
        if (this.pipeInfo.size() == 0) {
            return;
        }
        PipeInfo pi = this.pipeInfo.get(idx);
        if (!e.getValueIsAdjusting()) {
            if (pi.isWritable()) {
                this.descrLabel.setText("  Blobname,[ Name1,type1,value1 ],... (Help for details)");
                this.arginCombo.setEnabled(true);
                this.writeBtn.setEnabled(true);
                this.helpBtn.setEnabled(true);
            } else {
                this.descrLabel.setText("");
                this.arginCombo.setEnabled(false);
                this.writeBtn.setEnabled(false);
                this.helpBtn.setEnabled(false);
            }
            this.descrList.setText("Name         " + pi.getName() + "\nLabel        " + pi.getLabel() + "\nWritable     " + Boolean.toString(pi.isWritable()) + "\nLevel        " + pi.getLevel() + "\nDescr        " + pi.getDescription());
            this.descrList.setCaretPosition(0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object src = e.getSource();
        if (src == this.pipeList) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.readPipe();
            }
            if (e.getButton() == 3) {
                this.copyMenu.show(this.pipeList, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new TransferableString(this.getCopyString(false)), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext context = dragSourceDragEvent.getDragSourceContext();
        context.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.readBtn) {
            this.readPipe();
        } else if (src == this.writeBtn) {
            this.writePipe();
        } else if (src == this.helpBtn) {
            String helpMessage = "Argin syntax for a blob:\n Blobname,[ Name1,type1,value1 ],[ Name2,typ2,value2 ],... \n where the value is formatted as \n   D,1,2.5,3,4      (double)\n   F,1.0,2.3,4,4    (float)\n  UC,1,2,3,4        (unsigned char)\n   S,1,-2,3,4       (short)\n  US,1,2,3,4        (unsigned short)\n   L,1,-2,3,4       (long)\n  UL,1,2,3,4        (unsigned long)\n  LL,1,2,3,4        (int64)\n  ST,ON,OFF,STANDY  (state)\n STR,\"str 1\",str2   (string)\n [ blob ]   (inner blob)\n";
            JOptionPane.showMessageDialog(this, helpMessage, "Argin syntax", 1);
        } else if (src == this.copyAttributeMenuItem) {
            this.copyAttributeToClipboard(true);
        } else if (src == this.copyDevAttributeMenuItem) {
            this.copyAttributeToClipboard(false);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 210);
    }

    private String getCopyString(boolean copyNameOnly) {
        Object copyStr = "";
        PipeInfo ai = this.pipeInfo.get(this.pipeList.getSelectedIndex());
        copyStr = copyNameOnly ? ai.getName() : this.device.get_name() + "/" + ai.getName();
        return copyStr;
    }

    private void copyAttributeToClipboard(boolean copyNameOnly) {
        StringSelection stringSelection = new StringSelection(this.getCopyString(copyNameOnly));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    static String getFormatString(AttributeInfo ai) {
        switch (ai.data_format.value()) {
            case 0: {
                return "Scalar";
            }
            case 1: {
                return "Spectrum";
            }
            case 2: {
                return "Image";
            }
        }
        return "Unknown";
    }

    static String getWriteString(AttributeInfo ai) {
        switch (ai.writable.value()) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "READ_WITH_WRITE";
            }
            case 3: {
                return "READ_WRITE";
            }
            case 2: {
                return "WRITE";
            }
        }
        return "Unknown";
    }

    private List<PipeInfo> getPipeInfo() throws DevFailed {
        return this.device.getPipeConfig();
    }

    private void placeComponents(Dimension dim) {
        this.arginLabel.setBounds(10, 0, 80, 20);
        this.descrLabel.setBounds(90, 0, dim.width - 100, 20);
        this.arginCombo.setBounds(10, 20, dim.width - 20, 25);
        this.pipeView.setBounds(10, 50, 190, dim.height - 60);
        this.pipeView.revalidate();
        this.descrView.setBounds(205, 50, dim.width - 215, dim.height - 90);
        this.descrView.revalidate();
        int dim2 = (dim.width - 220) / 3;
        this.readBtn.setBounds(205, dim.height - 35, dim2, 25);
        this.writeBtn.setBounds(205 + dim2 + 2, dim.height - 35, dim2, 25);
        this.helpBtn.setBounds(205 + 2 * dim2 + 5, dim.height - 35, dim2, 25);
    }

    private void addArgin(String text) {
        boolean found = false;
        int i = 0;
        while (i < this.arginCombo.getItemCount() && !found) {
            found = text.equals(this.arginCombo.getItemAt(i).toString());
            if (found) continue;
            ++i;
        }
        if (!found) {
            this.arginCombo.addItem(text);
        }
    }

    private void writePipe() {
        try {
            PipeInfo pi = this.pipeInfo.get(this.pipeList.getSelectedIndex());
            String arginStr = (String)this.arginCombo.getSelectedItem();
            if (arginStr != null) {
                this.addArgin(arginStr);
            }
            DevicePipe argin = new DevicePipe(pi.getName(), this.parseData(arginStr));
            long t0 = System.currentTimeMillis();
            this.device.writePipe(argin);
            long t1 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Pipe: " + this.device.name() + "/" + pi.getName() + "\n");
            this.console.print("Duration: " + (t1 - t0) + " msec\n");
            this.console.print("Write OK\n");
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + e1.getMessage());
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private void indent(int level) {
        for (int i = 0; i < level; ++i) {
            this.console.print("  ");
        }
    }

    private void indent(int level, StringBuffer str) {
        for (int i = 0; i < level; ++i) {
            str.append("  ");
        }
    }

    private void printPipeBlop(PipeBlob pb, int level) throws DevFailed {
        this.indent(level);
        this.console.print("[" + pb.getName() + "]\n");
        block3: for (PipeDataElement item : pb) {
            int type = item.getType();
            this.indent(level + 1);
            this.console.print(item.getName() + ":" + TangoConst.Tango_CmdArgTypeName[type]);
            switch (type) {
                case 30: {
                    this.console.print("\n");
                    this.printPipeBlop(item.extractPipeBlob(), level + 1);
                    continue block3;
                }
            }
            this.console.print(this.extractData(level + 1, item));
        }
    }

    private void readPipe() {
        try {
            PipeInfo pi = this.pipeInfo.get(this.pipeList.getSelectedIndex());
            long t0 = System.currentTimeMillis();
            DevicePipe argout = this.device.readPipe(pi.getName());
            long t1 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Pipe: " + this.device.name() + "/" + pi.getName() + "\n");
            this.console.print("Duration: " + (t1 - t0) + " msec\n");
            TimeVal t = argout.getDevPipeDataObject().time;
            Date date = new Date((long)((double)t.tv_sec * 1000.0 + (double)t.tv_usec / 1000.0));
            SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            dateformat.setTimeZone(TimeZone.getDefault());
            this.console.print("measure date: " + dateformat.format(date) + " + " + t.tv_usec / 1000 + "ms\n");
            this.printPipeBlop(argout.getPipeBlob(), 0);
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private String getExample(AttributeInfo ai) {
        Object ret_string = "";
        switch (ai.data_type) {
            case 19: {
                ret_string = (String)ret_string + "0 (16bits value)";
                break;
            }
            case 22: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 1: {
                ret_string = (String)ret_string + "true,false or 0,1";
                break;
            }
            case 6: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                ret_string = (String)ret_string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 3: {
                ret_string = (String)ret_string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 7: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 23: {
                ret_string = (String)ret_string + "10 or 0xa (signed 64bits)";
                break;
            }
            case 24: {
                ret_string = (String)ret_string + "10 or 0xa (unsigned 64bits)";
                break;
            }
            case 4: {
                ret_string = (String)ret_string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                ret_string = (String)ret_string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                ret_string = "quotes needed for string with space or special char";
                break;
            }
            default: {
                ret_string = new String("");
            }
        }
        if (ai.data_format.value() == 1) {
            return "Array of " + (String)ret_string + " Ex: a,b,c";
        }
        if (ai.data_format.value() == 2) {
            return "Image of " + (String)ret_string + " Ex: [a,b,c][d,e,f][g,h,i]";
        }
        return "Ex: " + (String)ret_string;
    }

    private int getLimitMax(int level, StringBuffer retStr, int length) {
        if (length > this.common.getAnswerLimitMax()) {
            this.indent(level, retStr);
            retStr.append("Array cannot be fully displayed. (You may change the AnswerLimitMax)\n");
            return this.common.getAnswerLimitMax();
        }
        return length;
    }

    private int getLimitMin(int level, StringBuffer retStr, int length) {
        if (length <= this.common.getAnswerLimitMin()) {
            this.indent(level, retStr);
            retStr.append("Array cannot be displayed. (You may change the AnswerLimitMin)\n");
            return length;
        }
        return this.common.getAnswerLimitMin();
    }

    private PipeBlob parseData(String argin) throws NumberFormatException {
        ArgParser arg = new ArgParser(argin);
        return arg.parse_pipe();
    }

    private void printArrayItem(StringBuffer str, int idx, boolean printIdx, String value, int level) {
        this.indent(level + 1, str);
        if (printIdx) {
            str.append("Read [" + idx + "]\t" + value + "\n");
        } else {
            str.append("Read:\t" + value + "\n");
        }
    }

    private String extractData(int level, PipeDataElement data) {
        StringBuffer ret_string = new StringBuffer();
        try {
            switch (data.getType()) {
                case 19: {
                    boolean printIndex;
                    DevState[] dummy = data.extractDevStateArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Tango_DevStateName[dummy[i].value()], level);
                    }
                    break;
                }
                case 22: {
                    boolean printIndex;
                    short[] dummy = data.extractUCharArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Short.toString(dummy[i]), level);
                    }
                    break;
                }
                case 2: {
                    boolean printIndex;
                    short[] dummy = data.extractShortArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Short.toString(dummy[i]), level);
                    }
                    break;
                }
                case 1: {
                    boolean printIndex;
                    boolean[] dummy = data.extractBooleanArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Boolean.toString(dummy[i]), level);
                    }
                    break;
                }
                case 6: {
                    boolean printIndex;
                    int[] dummy = data.extractUShortArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Integer.toString(dummy[i]), level);
                    }
                    break;
                }
                case 3: {
                    boolean printIndex;
                    int[] dummy = data.extractLongArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Integer.toString(dummy[i]), level);
                    }
                    break;
                }
                case 7: {
                    boolean printIndex;
                    long[] dummy = data.extractULongArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i]), level);
                    }
                    break;
                }
                case 23: {
                    boolean printIndex;
                    long[] dummy = data.extractLong64Array();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i]), level);
                    }
                    break;
                }
                case 24: {
                    boolean printIndex;
                    long[] dummy = data.extractULong64Array();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i]), level);
                    }
                    break;
                }
                case 5: {
                    boolean printIndex;
                    double[] dummy = data.extractDoubleArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Double.toString(dummy[i]), level);
                    }
                    break;
                }
                case 4: {
                    boolean printIndex;
                    float[] dummy = data.extractFloatArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    } else {
                        ret_string.append("\n");
                    }
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Float.toString(dummy[i]), level);
                    }
                    break;
                }
                case 8: {
                    boolean printIndex;
                    String[] dummy = data.extractStringArray();
                    boolean bl = printIndex = dummy.length > 1;
                    if (printIndex) {
                        ret_string.append(" Array length=" + Integer.toString(dummy.length));
                    }
                    ret_string.append("\n");
                    int start = this.getLimitMin(level, ret_string, dummy.length);
                    int end = this.getLimitMax(level, ret_string, dummy.length);
                    for (int i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, dummy[i], level);
                    }
                    break;
                }
                case 28: {
                    DevEncoded[] e = data.extractDevEncodedArray();
                    for (int j = 0; j < e.length; ++j) {
                        boolean printIndex;
                        if (e.length > 1) {
                            this.indent(level, ret_string);
                            this.console.print("Item #" + j + "\n");
                        }
                        this.indent(level, ret_string);
                        ret_string.append("Format: " + e[j].encoded_format + "\n");
                        boolean bl = printIndex = e[j].encoded_data.length > 1;
                        if (printIndex) {
                            ret_string.append(" Array length=" + Integer.toString(e[j].encoded_data.length));
                        }
                        ret_string.append("\n");
                        int start = this.getLimitMin(level, ret_string, e[j].encoded_data.length);
                        int end = this.getLimitMax(level, ret_string, e[j].encoded_data.length);
                        for (int i = start; i < end; ++i) {
                            short vs = e[j].encoded_data[i];
                            vs = (short)(vs & 0xFF);
                            this.printArrayItem(ret_string, i, printIndex, Short.toString(vs), level);
                        }
                    }
                    break;
                }
                default: {
                    this.indent(level, ret_string);
                    ret_string.append("Unsupported type code=" + data.getType() + "\n");
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + data.getName()), (DevFailed)e);
        }
        return ret_string.toString();
    }
}

