/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jive.ClassPanel;
import jive.DevWizard;
import jive.JiveUtils;
import jive.StartingPanel;
import jive.WizardPanel;

class ServerPanel
extends WizardPanel
implements ActionListener {
    private JLabel serverLabel;
    private JComboBox serverCombo;
    private JLabel instanceLabel;
    private JComboBox instanceCombo;
    private static final int DO_NOT_START = 0;
    private static final int START_IT = 1;
    private static final int ALREADY_STARTED = 2;

    public ServerPanel(DevWizard parent, String[] freeList) {
        this.setLayout(null);
        this.serverLabel = new JLabel("Server name");
        this.serverLabel.setFont(DevWizard.wizFont);
        this.serverLabel.setBounds(10, 10, 100, 25);
        this.add(this.serverLabel);
        this.serverCombo = new JComboBox();
        this.serverCombo.setFont(DevWizard.wizFont);
        this.serverCombo.setBounds(120, 10, 140, 25);
        this.add(this.serverCombo);
        if (freeList != null) {
            this.serverCombo.setEditable(false);
            for (int i = 0; i < freeList.length; ++i) {
                this.serverCombo.addItem(freeList[i]);
            }
            this.serverCombo.setSelectedIndex(0);
        } else {
            this.serverCombo.setEditable(true);
            try {
                Database db = ApiUtil.get_db_obj();
                String[] srvList = db.get_server_name_list();
                for (int i = 0; i < srvList.length; ++i) {
                    this.serverCombo.addItem(srvList[i]);
                }
                this.serverCombo.setSelectedItem(null);
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
        }
        this.serverCombo.addActionListener(this);
        this.instanceLabel = new JLabel("Instance name");
        this.instanceLabel.setFont(DevWizard.wizFont);
        this.instanceLabel.setBounds(10, 40, 100, 25);
        this.add(this.instanceLabel);
        this.instanceCombo = new JComboBox();
        this.instanceCombo.setEditable(true);
        this.instanceCombo.setFont(DevWizard.wizFont);
        this.instanceCombo.setBounds(120, 40, 140, 25);
        this.add(this.instanceCombo);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/server_wz.gif"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.serverCombo && e.getActionCommand() == "comboBoxChanged") {
            String sName = (String)this.serverCombo.getSelectedItem();
            try {
                Object oldSelection = this.instanceCombo.getSelectedItem();
                this.instanceCombo.removeAllItems();
                Database db = ApiUtil.get_db_obj();
                String[] insList = db.get_instance_name_list(sName);
                for (int i = 0; i < insList.length; ++i) {
                    this.instanceCombo.addItem(insList[i]);
                }
                this.instanceCombo.setSelectedItem(oldSelection);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }
    }

    @Override
    public String getTitle() {
        return "Server Registration";
    }

    @Override
    public String getDescription() {
        return "This wizard helps you to install a Tango device. First, you have to enter the \"Server name\" (executable file name) and its \"instance name\".\nTo register the server, click [Next].";
    }

    @Override
    public boolean getNextState() {
        return true;
    }

    @Override
    public boolean next() {
        String srvName = (String)this.serverCombo.getSelectedItem();
        String srvInst = (String)this.instanceCombo.getSelectedItem();
        if (srvName == null || srvInst == null || srvName.length() == 0 || srvInst.length() == 0) {
            JiveUtils.showJiveError("Please enter a server and an instance name.");
            return false;
        }
        String dsName = "dserver/" + srvName + "/" + srvInst;
        String srName = srvName + "/" + srvInst;
        try {
            Database db = ApiUtil.get_db_obj();
            if (!this.deviceExists(dsName, srName, "DServer")) {
                DbDevInfo devInfo = new DbDevInfo(dsName, "DServer", srName);
                db.add_device(devInfo);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        DeviceProxy admin = null;
        if (DevWizard.starter != null) {
            admin = this.startServer(srName);
            this.removeNextPanel();
            if (admin == null) {
                return false;
            }
            this.parent.addPanel(new ClassPanel(this.parent, srName, admin));
        } else {
            this.removeNextPanel();
            this.parent.addPanel(new StartingPanel(this.parent, srName));
        }
        return true;
    }

    private int canBeStarted(DeviceProxy dev, String srvName, String hostname) throws DevFailed {
        String devname = "dserver/" + srvName;
        boolean running = false;
        try {
            dev.ping();
            running = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        IORdump d = new IORdump(devname);
        String running_on = d.get_host();
        if (running) {
            if (running_on.startsWith(hostname)) {
                JOptionPane.showMessageDialog(this.parent, srvName + " is alredy running on " + running_on, "Jive Message", 2);
                return 2;
            }
            Except.throw_exception((String)"StartServerFailed", (String)(srvName + " is already running on " + d.get_host()), (String)"DevWizard.startServer()");
        }
        if (running_on != null && !running_on.startsWith(hostname)) {
            Object[] options = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(this.parent, srvName + " is alredy registred on " + running_on, "Warning", -1, 2, null, options, options[0]) != 0) {
                return 0;
            }
        }
        return 1;
    }

    private DeviceProxy startServer(String srvName) {
        DeviceProxy dev = null;
        String devname = "dserver/" + srvName;
        String hostname = DevWizard.starter.name();
        hostname = hostname.substring(hostname.lastIndexOf("/") + 1);
        try {
            dev = new DeviceProxy(devname);
            switch (this.canBeStarted(dev, srvName, hostname)) {
                case 0: {
                    return null;
                }
                case 2: {
                    return dev;
                }
            }
            DbDevExportInfo info = new DbDevExportInfo(devname, "null", hostname, "null");
            ApiUtil.get_db_obj().export_device(info);
            ApiUtil.get_db_obj().unexport_device(devname);
            DeviceData argin = new DeviceData();
            argin.insert(srvName);
            DevWizard.starter.command_inout("DevStart", argin);
            DevWizard.starter.set_source(DevSource.DEV);
            boolean started = false;
            block7: for (int i = 0; !started && i < 5; ++i) {
                Thread.sleep(1000L);
                DeviceAttribute att = DevWizard.starter.read_attribute("RunningServers");
                String[] servlist = att.extractStringArray();
                for (int j = 0; j < servlist.length; ++j) {
                    if (!servlist[j].equals(srvName)) continue;
                    started = true;
                    dev = new DeviceProxy(devname);
                    DevWizard.lastServStarted = srvName;
                    String msg = srvName + " is now running on " + hostname;
                    JOptionPane.showMessageDialog(this.parent, msg, "Jive Message", 1);
                    continue block7;
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
            JiveUtils.showJiveError("Failed to start " + srvName + " :\n" + e.errors[0].desc);
            this.parent.setVisible(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return dev;
    }
}

