/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TreePanel;

class Action {
    static TangoNode[] selectedNodes = null;
    String name;
    int action;
    boolean allowMultiple;
    JMenuItem menuItem;
    KeyStroke keyStroke;

    Action(int a, boolean aM, String n) {
        this(a, aM, n, -1, 0);
    }

    Action(int a, boolean aM, String n, int keyCode, int modifier) {
        this.action = a;
        this.allowMultiple = aM;
        this.name = n;
        this.menuItem = new JMenuItem(this.name);
        this.keyStroke = null;
        if (keyCode >= 0) {
            this.keyStroke = KeyStroke.getKeyStroke(keyCode, modifier);
            this.menuItem.setAccelerator(this.keyStroke);
        }
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action.this.execAction();
            }
        });
    }

    boolean isShortcut(KeyStroke ks) {
        if (this.keyStroke == null) {
            return false;
        }
        return this.keyStroke.getKeyCode() == ks.getKeyCode() && this.keyStroke.getModifiers() == ks.getModifiers();
    }

    void execAction() {
        block19: {
            block20: {
                if (selectedNodes == null) break block19;
                if (!this.allowMultiple || selectedNodes.length <= 1) break block20;
                Vector<String> errors = new Vector<String>();
                switch (this.action) {
                    case 3: {
                        int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Delete " + selectedNodes.length + " items ?", "Confirm delete", 0);
                        if (ok == 0) {
                            for (int i = 0; i < selectedNodes.length; ++i) {
                                try {
                                    selectedNodes[i].execAction(this.action, true);
                                    continue;
                                }
                                catch (IOException e) {
                                    errors.add(e.getMessage());
                                }
                            }
                            if (errors.size() > 0) {
                                JiveUtils.showJiveErrors(errors);
                            }
                        }
                        TreePanel.panelInvoker.refresh();
                        break;
                    }
                    case 6: {
                        File file = TreePanel.getSaveFile(TreePanel.invoker);
                        if (file != null) {
                            try {
                                TreePanel.globalResFile = new FileWriter(file.getAbsolutePath());
                                Date date = new Date(System.currentTimeMillis());
                                TreePanel.globalResFile.write("#\n# Resource backup , created " + date + "\n#\n\n");
                                for (int i = 0; i < selectedNodes.length; ++i) {
                                    selectedNodes[i].execAction(this.action, true);
                                }
                                TreePanel.globalResFile.close();
                            }
                            catch (IOException e) {
                                JiveUtils.showJiveError(e.getMessage());
                            }
                            break;
                        }
                        break block19;
                    }
                    default: {
                        try {
                            for (int i = 0; i < selectedNodes.length; ++i) {
                                selectedNodes[i].execAction(this.action, true);
                            }
                            break block19;
                        }
                        catch (IOException e) {
                            JiveUtils.showJiveError("Error while performing " + this.name + " !\n");
                            break;
                        }
                    }
                }
                break block19;
            }
            try {
                if (selectedNodes.length > 0) {
                    selectedNodes[0].execAction(this.action, false);
                }
            }
            catch (IOException e) {
                JiveUtils.showJiveError("Error while performing " + this.name + " !\n");
            }
        }
    }
}

