/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbServer;
import java.io.IOException;
import jive.JiveUtils;

class DbReader {
    String srvName;
    Database db;

    DbReader(String srvName) {
        this.srvName = srvName;
        try {
            int j;
            String[] prop_list;
            this.db = ApiUtil.get_db_obj();
            DbServer dbs = new DbServer(srvName);
            String[] class_list = dbs.get_class_list();
            for (int i = 0; i < class_list.length; ++i) {
                int k;
                boolean prtOut;
                DbAttribute[] lst;
                String[] att_list;
                if (!JiveUtils.isSavedClass(class_list[i])) {
                    String[] value;
                    System.out.print("#---------------------------------------------------------\n");
                    System.out.print("# CLASS " + class_list[i] + " properties\n");
                    System.out.print("#---------------------------------------------------------\n\n");
                    prop_list = this.db.get_class_property_list(class_list[i], "*");
                    for (j = 0; j < prop_list.length; ++j) {
                        value = this.db.get_class_property(class_list[i], prop_list[j]).extractStringArray();
                        if (prop_list[j].indexOf(32) != -1) {
                            prop_list[j] = "\"" + prop_list[j] + "\"";
                        }
                        JiveUtils.printFormatedRes("CLASS/" + class_list[i] + "->" + prop_list[j] + ": ", value, null);
                    }
                    att_list = this.db.get_class_attribute_list(class_list[i], "*");
                    lst = this.db.get_class_attribute_property(class_list[i], att_list);
                    prtOut = false;
                    for (k = 0; k < lst.length; ++k) {
                        prop_list = lst[k].get_property_list();
                        for (j = 0; j < prop_list.length; ++j) {
                            if (!prtOut) {
                                System.out.print("\n# CLASS " + class_list[i] + " attribute properties\n\n");
                                prtOut = true;
                            }
                            if (prop_list[j].indexOf(32) != -1) {
                                prop_list[j] = "\"" + prop_list[j] + "\"";
                            }
                            value = lst[k].get_value(j);
                            JiveUtils.printFormatedRes("CLASS/" + class_list[i] + "/" + att_list[k] + "->" + prop_list[j] + ": ", value, null);
                        }
                    }
                    System.out.print("\n");
                    JiveUtils.addSavedClass(class_list[i]);
                }
                System.out.print("#---------------------------------------------------------\n");
                System.out.print("# SERVER " + srvName + ", " + class_list[i] + " device declaration\n");
                System.out.print("#---------------------------------------------------------\n\n");
                String[] dev_list = dbs.get_device_name(class_list[i]);
                JiveUtils.printFormatedRes(srvName + "/DEVICE/" + class_list[i] + ": ", dev_list, null);
                System.out.print("\n");
                for (int l = 0; l < dev_list.length; ++l) {
                    String[] value;
                    prop_list = this.db.get_device_property_list(dev_list[l], "*");
                    if (prop_list.length > 0) {
                        System.out.print("\n# --- " + dev_list[l] + " properties\n\n");
                        for (j = 0; j < prop_list.length; ++j) {
                            value = this.db.get_device_property(dev_list[l], prop_list[j]).extractStringArray();
                            if (prop_list[j].indexOf(32) != -1 || prop_list[j].indexOf(47) != -1) {
                                prop_list[j] = "\"" + prop_list[j] + "\"";
                            }
                            JiveUtils.printFormatedRes(dev_list[l] + "->" + prop_list[j] + ": ", value, null);
                        }
                    }
                    try {
                        att_list = this.db.get_device_attribute_list(dev_list[l]);
                        lst = this.db.get_device_attribute_property(dev_list[l], att_list);
                        prtOut = false;
                        for (k = 0; k < lst.length; ++k) {
                            prop_list = lst[k].get_property_list();
                            for (j = 0; j < prop_list.length; ++j) {
                                if (!prtOut) {
                                    System.out.print("\n# --- " + dev_list[l] + " attribute properties\n\n");
                                    prtOut = true;
                                }
                                if (prop_list[j].indexOf(32) != -1 || prop_list[j].indexOf(47) != -1) {
                                    prop_list[j] = "\"" + prop_list[j] + "\"";
                                }
                                value = lst[k].get_value(j);
                                JiveUtils.printFormatedRes(dev_list[l] + "/" + att_list[k] + "->" + prop_list[j] + ": ", value, null);
                            }
                        }
                        continue;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showJiveError("Attribute properties for " + dev_list[l] + " has not been saved !\n" + e.errors[0].desc);
                    }
                }
                System.out.print("\n");
            }
            String admDevName = "dserver/" + srvName;
            prop_list = this.db.get_device_property_list(admDevName, "*");
            if (prop_list.length > 0) {
                System.out.print("\n# --- " + admDevName + " properties\n\n");
                for (j = 0; j < prop_list.length; ++j) {
                    String[] value = this.db.get_device_property(admDevName, prop_list[j]).extractStringArray();
                    if (prop_list[j].indexOf(32) != -1) {
                        prop_list[j] = "\"" + prop_list[j] + "\"";
                    }
                    JiveUtils.printFormatedRes(admDevName + "->" + prop_list[j] + ": ", value, null);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.printTangoError(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: tg_devres server/instance");
        } else {
            new DbReader(args[0]);
        }
    }
}

