/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskLoggingNode;

public class DeviceLoggingPanel
extends JPanel
implements ActionListener,
MouseListener {
    private JScrollPane textView;
    private JTable theTable;
    private JButton refreshButton;
    private JButton applyButton;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private TaskLoggingNode[] source = null;
    private DefaultTableModel dm;
    private int selectedRow;

    DeviceLoggingPanel() {
        this.setLayout(new BorderLayout());
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceLoggingPanel.this.source.length;
                    int k = 0;
                    if (DeviceLoggingPanel.this.source.length > 1) {
                        Vector<String> propChange = new Vector<String>();
                        switch (row) {
                            case 0: {
                                propChange.add("logging_level");
                                break;
                            }
                            case 1: {
                                propChange.add("cur_logging_level");
                                break;
                            }
                            case 2: {
                                propChange.add("logging_target");
                                break;
                            }
                            case 3: {
                                propChange.add("cur_logging_target");
                                break;
                            }
                            case 4: {
                                propChange.add("logging_rft");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceLoggingPanel.this.source.length)) {
                            DeviceLoggingPanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (row) {
                        case 0: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating logging config");
                            }
                            for (int i = 0; i < DeviceLoggingPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceLoggingPanel.this.source[i].getName() + "/logging_level", ++k * 100 / nb);
                                DeviceLoggingPanel.this.source[i].setLoggingLevel((String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceLoggingPanel.this.refreshValue();
                            break;
                        }
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating logging config");
                            }
                            for (int i = 0; i < DeviceLoggingPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceLoggingPanel.this.source[i].getName() + "/cur_logging_level", ++k * 100 / nb);
                                DeviceLoggingPanel.this.source[i].setCurrentLoggingLevel((String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceLoggingPanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating logging config");
                            }
                            for (int i = 0; i < DeviceLoggingPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceLoggingPanel.this.source[i].getName() + "/logging_target", ++k * 100 / nb);
                                DeviceLoggingPanel.this.source[i].setLoggingTarget((String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceLoggingPanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating logging config");
                            }
                            for (int i = 0; i < DeviceLoggingPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceLoggingPanel.this.source[i].getName() + "/cur_logging_target", ++k * 100 / nb);
                                DeviceLoggingPanel.this.source[i].setCurrentLoggingTarget((String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceLoggingPanel.this.refreshValue();
                            break;
                        }
                        case 4: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating logging config");
                            }
                            for (int i = 0; i < DeviceLoggingPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceLoggingPanel.this.source[i].getName() + "/logging_rft", ++k * 100 / nb);
                                DeviceLoggingPanel.this.source[i].setLoggingRft((String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceLoggingPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.theTable = new JTable(this.dm);
        this.theTable.addMouseListener(this);
        this.textView = new JScrollPane(this.theTable);
        this.add((Component)this.textView, "Center");
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.textView.setBorder(b);
        this.add((Component)this.textView, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        btnPanel.add(this.refreshButton);
        btnPanel.add(this.applyButton);
        this.add((Component)btnPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row;
        if (!(e.getButton() != 3 || e.getClickCount() != 1 || JiveUtils.readOnly || (row = this.getRowForLocation(e.getY())) != 0 && row != 2 && row != 4)) {
            this.theTable.clearSelection();
            this.theTable.addRowSelectionInterval(row, row);
            this.theTable.setColumnSelectionInterval(0, this.theTable.getColumnCount() - 1);
            this.selectedRow = row;
            this.tableMenu.show(this.theTable, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        } else if (src == this.applyButton) {
            if (this.theTable.isEditing()) {
                String t = ((JTextField)this.theTable.getEditorComponent()).getText();
                this.dm.setValueAt(t, this.theTable.getEditingRow(), this.theTable.getEditingColumn());
            }
        } else if (src == this.resetMenuItem) {
            int nb = this.source.length;
            int k = 0;
            switch (this.selectedRow) {
                case 0: {
                    String message;
                    int result;
                    if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset logging level for " + this.source.length + " devices.\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                        return;
                    }
                    if (nb > 1) {
                        ProgressFrame.displayProgress("Reseting logging config");
                    }
                    for (int i = 0; i < this.source.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/logging_level", ++k * 100 / nb);
                        this.source[i].resetLoggingLevel();
                    }
                    ProgressFrame.hideProgress();
                    this.refreshValue();
                    break;
                }
                case 2: {
                    String message;
                    int result;
                    if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset logging target for " + this.source.length + " devices.\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                        return;
                    }
                    if (nb > 1) {
                        ProgressFrame.displayProgress("Reseting logging config");
                    }
                    for (int i = 0; i < this.source.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/logging_target", ++k * 100 / nb);
                        this.source[i].resetLoggingTarget();
                    }
                    ProgressFrame.hideProgress();
                    this.refreshValue();
                    break;
                }
                case 4: {
                    String message;
                    int result;
                    if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset logging rft for " + this.source.length + " devices.\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                        return;
                    }
                    if (nb > 1) {
                        ProgressFrame.displayProgress("Reseting logging config");
                    }
                    for (int i = 0; i < this.source.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/logging_rft", ++k * 100 / nb);
                        this.source[i].resetLoggingRft();
                    }
                    ProgressFrame.hideProgress();
                    this.refreshValue();
                }
            }
        }
    }

    private int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.theTable.getRowCount() && !found) {
            found = y >= h && y <= h + this.theTable.getRowHeight(i);
            if (found) continue;
            h += this.theTable.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    void setSource(TaskLoggingNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    private void refreshValue() {
        if (this.source != null) {
            Object[] colName = new String[]{"Property name", "Value"};
            Object[][] loggingInfo = new Object[5][2];
            loggingInfo[0][0] = "Logging level";
            loggingInfo[0][1] = this.source[0].getLoggingLevel();
            loggingInfo[1][0] = "Current logging level";
            loggingInfo[1][1] = this.source[0].getCurrentLoggingLevel();
            loggingInfo[2][0] = "Logging target";
            loggingInfo[2][1] = this.source[0].getLoggingTarget();
            loggingInfo[3][0] = "Current logging target";
            loggingInfo[3][1] = this.source[0].getCurrentLoggingTarget();
            loggingInfo[4][0] = "Logging RFT";
            loggingInfo[4][1] = this.source[0].getLoggingRft();
            this.dm.setDataVector(loggingInfo, colName);
            this.theTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object title = this.source[0].getTitle();
            title = this.source.length == 1 ? (String)title + " [" + this.source[0].getName() + "]" : (String)title + " [" + this.source.length + " devices selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), (String)title);
            this.textView.setBorder(b);
        }
    }
}

