/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;

public class DiffDlg
extends JFrame
implements ActionListener {
    private static final String[] colNames = new String[]{"Property", "Database value", "File value"};
    private JScrollPane textView;
    private JTable[] tables;
    private JButton dismissBtn;
    private JPanel btnPanel;
    private JPanel innerPanel = new JPanel();

    public DiffDlg(Vector<Vector<String>> diffs, File[] fileNames) {
        this.innerPanel.setLayout(new BorderLayout());
        JPanel tablesPanel = new JPanel();
        tablesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        this.tables = new JTable[fileNames.length];
        int gy = 0;
        for (int i = 0; i < fileNames.length; ++i) {
            DefaultTableModel dm = new DefaultTableModel(){

                public Class getColumnClass(int columnIndex) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                @Override
                public void setValueAt(Object aValue, int row, int column) {
                }
            };
            this.tables[i] = new JTable(dm);
            JLabel fLabel = new JLabel(fileNames[i].getAbsolutePath());
            MultiLineCellEditor editor = new MultiLineCellEditor(this.tables[i]);
            this.tables[i].setDefaultEditor(String.class, editor);
            MultiLineCellRenderer renderer = new MultiLineCellRenderer();
            this.tables[i].setDefaultRenderer(String.class, renderer);
            Vector<String> diff = diffs.get(i);
            if (diff.size() == 1) {
                gbc.gridy = gy++;
                gbc.insets.top = 10;
                gbc.insets.bottom = 2;
                tablesPanel.add((Component)fLabel, gbc);
                JLabel label = new JLabel(diff.get(0));
                label.setFont(ATKConstant.labelFont);
                gbc.insets.top = 0;
                gbc.insets.bottom = 0;
                gbc.gridy = gy++;
                tablesPanel.add((Component)label, gbc);
                continue;
            }
            Object[][] prop = new String[diff.size() / 3][3];
            for (int j = 0; j < diff.size(); j += 3) {
                prop[j / 3][0] = diff.get(j);
                prop[j / 3][1] = diff.get(j + 1);
                prop[j / 3][2] = diff.get(j + 2);
            }
            dm.setDataVector(prop, colNames);
            editor.updateRows();
            this.tables[i].validate();
            gbc.gridy = gy++;
            gbc.insets.top = 10;
            gbc.insets.bottom = 2;
            tablesPanel.add((Component)fLabel, gbc);
            gbc.insets.top = 0;
            gbc.insets.bottom = 0;
            gbc.gridy = gy++;
            tablesPanel.add((Component)this.tables[i].getTableHeader(), gbc);
            gbc.gridy = gy++;
            tablesPanel.add((Component)this.tables[i], gbc);
        }
        gbc.gridy = gy;
        gbc.weighty = 1.0;
        tablesPanel.add((Component)new JPanel(), gbc);
        this.textView = new JScrollPane(tablesPanel);
        this.textView.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.textView, "Center");
        this.innerPanel.add((Component)this.textView, "Center");
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.innerPanel.add((Component)this.btnPanel, "South");
        this.dismissBtn = new JButton("Dismiss");
        this.dismissBtn.addActionListener(this);
        this.btnPanel.add(this.dismissBtn);
        this.setContentPane(this.innerPanel);
        this.setTitle("DB diff");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dismissBtn) {
            this.setVisible(false);
        }
    }
}

