/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MainPanel;

public class JiveTable
extends JTable {
    private MultiLineCellEditor editor;
    private MainPanel parent = null;
    private Vector<ModifiedKeyListener> modifiedKeyListenerList = new Vector();

    public JiveTable(TableModel model) {
        super(model);
        this.editor = new MultiLineCellEditor(this);
        this.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer(false, true, true);
        this.setDefaultRenderer(String.class, renderer);
    }

    public void setParent(MainPanel parent) {
        this.parent = parent;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            int column;
            MouseEvent me = (MouseEvent)e;
            if (me.getButton() == 1 && me.getID() == 501 && (column = this.getColumnForLocation(me.getX())) == 1) {
                int row = this.getRowForLocation(me.getY());
                String value = (String)this.getModel().getValueAt(row, column);
                MultiLineCellRenderer c = (MultiLineCellRenderer)this.getCellRenderer(row, column);
                c.setText(value);
                if (c.hasDevice()) {
                    int y;
                    Rectangle rect = this.getCellRect(row, column, false);
                    int x = me.getX() - rect.x;
                    String name = c.getDevice(x, y = me.getY() - rect.y);
                    if (name != null && this.parent != null) {
                        this.parent.goToDeviceNode(name);
                        return;
                    }
                }
            }
        } else if (e instanceof KeyEvent && !this.isEditing()) {
            boolean found = false;
            KeyEvent ke = (KeyEvent)e;
            int i = 0;
            while (!found && i < this.modifiedKeyListenerList.size()) {
                ModifiedKeyListener kl = this.modifiedKeyListenerList.get(i);
                found = kl.keyCode == ke.getKeyCode() && ke.getModifiersEx() == kl.keyModifier;
                if (found) continue;
                ++i;
            }
            if (found) {
                switch (e.getID()) {
                    case 401: {
                        this.modifiedKeyListenerList.get((int)i).listener.keyPressed(ke);
                        return;
                    }
                    case 402: {
                        this.modifiedKeyListenerList.get((int)i).listener.keyReleased(ke);
                        return;
                    }
                    case 400: {
                        this.modifiedKeyListenerList.get((int)i).listener.keyTyped(ke);
                        return;
                    }
                }
            }
        }
        super.processEvent(e);
    }

    public MultiLineCellEditor getEditor() {
        return this.editor;
    }

    public void updateRows() {
        this.editor.updateRows();
    }

    public int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.getModel().getRowCount() && !found) {
            found = y >= h && y <= h + this.getRowHeight(i);
            if (found) continue;
            h += this.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public int getColumnForLocation(int x) {
        boolean found = false;
        int i = 0;
        int w = 0;
        while (i < this.getModel().getColumnCount() && !found) {
            int cWidth = this.getColumnModel().getColumn(i).getWidth();
            found = x >= w && x <= w + cWidth;
            if (found) continue;
            w += cWidth;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public void addKeyPressedEvent(int keyCode, int modifiers, KeyListener l) {
        this.modifiedKeyListenerList.add(new ModifiedKeyListener(l, keyCode, modifiers));
    }

    class ModifiedKeyListener {
        KeyListener listener;
        int keyCode;
        int keyModifier;

        ModifiedKeyListener(KeyListener listener, int keyCode, int keyModifier) {
            this.listener = listener;
            this.keyCode = keyCode;
            this.keyModifier = keyModifier;
        }
    }
}

