/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jive.ArgParser;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MultiChangeConfirmDlg;
import jive3.TreePanel;

public class MultipleTestDeviceDlg
extends JFrame
implements ActionListener {
    Database db = null;
    String[] colName = new String[]{"Name", "Class", "Value", "Time (ms)"};
    private MultiLineCellEditor editor;
    JTextField selectionText;
    JLabel selectionLabel;
    JButton searchButton;
    JButton dismissButton;
    JLabel infoLabel;
    DefaultTableModel dm;
    JTable theTable;
    JCheckBox showValue;
    JCheckBox ignoreUnexported;
    JButton removeButton;
    JList attList;
    JTextField attValueText;
    JButton writeAttBtn;
    JButton readAttBtn;
    JButton saveAttListBtn;
    JList cmdList;
    JTextField cmdValueText;
    JButton execCmdBtn;
    ArrayList<DItem> items;
    ArrayList<AItem> attItems;
    ArrayList<CItem> cmdItems;

    public MultipleTestDeviceDlg() {
        this.initComponents();
    }

    void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        JLabel selectionLabel = new JLabel(" Selection ");
        selectionLabel.setFont(ATKConstant.labelFont);
        innerPanel.add((Component)selectionLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.selectionText = new JTextField();
        this.selectionText.addActionListener(this);
        this.selectionText.setFont(ATKConstant.labelFont);
        innerPanel.add((Component)this.selectionText, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        innerPanel.add((Component)this.searchButton, gbc);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        JPanel attributePanel = new JPanel();
        attributePanel.setLayout(new BorderLayout());
        attributePanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        JLabel arginLabel = new JLabel("Argin ");
        valuePanel.add((Component)arginLabel, gbc);
        gbc.weightx = 1.0;
        this.attValueText = new JTextField();
        this.attValueText.setEditable(true);
        valuePanel.add((Component)this.attValueText, gbc);
        gbc.weightx = 0.0;
        this.readAttBtn = new JButton("Read");
        this.readAttBtn.addActionListener(this);
        valuePanel.add((Component)this.readAttBtn, gbc);
        this.writeAttBtn = new JButton("Write");
        this.writeAttBtn.addActionListener(this);
        valuePanel.add((Component)this.writeAttBtn, gbc);
        this.saveAttListBtn = new JButton("Save list");
        this.saveAttListBtn.addActionListener(this);
        valuePanel.add((Component)this.saveAttListBtn, gbc);
        attributePanel.add((Component)valuePanel, "North");
        this.attList = new JList();
        JScrollPane attListScrool = new JScrollPane(this.attList);
        attributePanel.add((Component)attListScrool, "Center");
        tabPane.add((Component)attributePanel, "Attribute");
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BorderLayout());
        commandPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel cmdValuePanel = new JPanel();
        cmdValuePanel.setLayout(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        JLabel cmdArginLabel = new JLabel("Argin ");
        cmdValuePanel.add((Component)cmdArginLabel, gbc);
        gbc.weightx = 1.0;
        this.cmdValueText = new JTextField();
        this.cmdValueText.setEditable(true);
        cmdValuePanel.add((Component)this.cmdValueText, gbc);
        gbc.weightx = 0.0;
        this.execCmdBtn = new JButton("Execute");
        this.execCmdBtn.addActionListener(this);
        cmdValuePanel.add((Component)this.execCmdBtn, gbc);
        commandPanel.add((Component)cmdValuePanel, "North");
        this.cmdList = new JList();
        JScrollPane cmdListScrool = new JScrollPane(this.cmdList);
        commandPanel.add((Component)cmdListScrool, "Center");
        tabPane.add((Component)commandPanel, "Command");
        JPanel bottomBtnPanel = new JPanel();
        bottomBtnPanel.setLayout(new FlowLayout(2));
        this.infoLabel = new JLabel("0 item(s)");
        this.infoLabel.setFont(ATKConstant.labelFont);
        bottomBtnPanel.add(this.infoLabel);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(this);
        bottomBtnPanel.add(this.dismissButton);
        bottomPanel.add((Component)tabPane, "Center");
        bottomPanel.add((Component)bottomBtnPanel, "South");
        this.getContentPane().add((Component)innerPanel, "North");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
            }
        };
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        this.theTable = new JTable(this.dm);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer(false, true, false);
        this.theTable.setDefaultRenderer(String.class, renderer);
        this.theTable.setSelectionMode(2);
        JScrollPane textView = new JScrollPane(this.theTable);
        tablePanel.add((Component)textView, "Center");
        JPanel tableButtonPanel = new JPanel();
        tableButtonPanel.setLayout(new FlowLayout(2));
        this.ignoreUnexported = new JCheckBox("Ignore unexported");
        this.ignoreUnexported.setSelected(false);
        this.ignoreUnexported.addActionListener(this);
        this.showValue = new JCheckBox("Show value");
        this.showValue.setSelected(true);
        this.showValue.addActionListener(this);
        tableButtonPanel.add(this.ignoreUnexported);
        tableButtonPanel.add(this.showValue);
        this.removeButton = new JButton("Remove items");
        this.removeButton.addActionListener(this);
        tableButtonPanel.add(this.removeButton);
        tablePanel.add((Component)tableButtonPanel, "South");
        this.getContentPane().add((Component)tablePanel, "Center");
        this.setTitle("Multiple device selection");
        this.setPreferredSize(new Dimension(800, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultipleTestDeviceDlg.this.exitDlg();
                super.windowClosing(e);
            }
        });
        this.items = new ArrayList();
        this.attItems = new ArrayList();
        this.cmdItems = new ArrayList();
        this.clear();
    }

    private void exitDlg() {
    }

    public void clear() {
        this.items.clear();
        this.infoLabel.setText(this.items.size() + " item(s)");
        Object[][] prop = new String[0][2];
        this.dm.setDataVector(prop, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    private void selectDevice() {
        this.refresh();
    }

    private void refresh() {
        String selectText = this.selectionText.getText().trim();
        String[] fields = selectText.split("/");
        if (fields.length != 3 && fields.length != 4) {
            JiveUtils.showJiveError("Invalid selection pattern, 3 or 4 slash separated fields expected");
            return;
        }
        try {
            String request;
            String exportedClause;
            this.items.clear();
            String string = exportedClause = this.ignoreUnexported.isSelected() ? " and exported=1" : "";
            if (fields.length == 3) {
                fields[0] = fields[0].replace('*', '%');
                fields[1] = fields[1].replace('*', '%');
                fields[2] = fields[2].replace('*', '%');
                request = "select name,class from device where domain like '" + fields[0] + "' and family like '" + fields[1] + "' and member like '" + fields[2] + "'" + exportedClause;
            } else {
                fields[0] = fields[0].replace('*', '%');
                fields[1] = fields[1].replace('*', '%');
                fields[2] = fields[2].replace('*', '%');
                fields[3] = fields[3].replace('*', '%');
                request = "select name,class from device where domain like '" + fields[0] + "' and family like '" + fields[1] + "' and member like '" + fields[2] + "' and class like '" + fields[3] + "'" + exportedClause;
            }
            DeviceData argin = new DeviceData();
            argin.insert(request);
            DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            this.items.clear();
            for (int i = 0; i < arg.svalue.length; i += 2) {
                DItem pi = new DItem();
                pi.devName = arg.svalue[i];
                pi.className = arg.svalue[i + 1];
                pi.value = "";
                this.items.add(pi);
            }
            if (this.items.size() == 0) {
                JOptionPane.showMessageDialog(this, "No device found");
            }
            this.infoLabel.setText(this.items.size() + " item(s)");
            this.refreshCommandAndAttribute();
            this.refreshTable();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private void refreshCommandAndAttribute() {
        int i;
        int i2;
        Vector<String> errStr = new Vector<String>();
        this.attItems.clear();
        this.cmdItems.clear();
        for (i2 = 0; i2 < this.items.size(); ++i2) {
            DItem pi = this.items.get(i2);
            try {
                DeviceProxy ds = new DeviceProxy(pi.devName);
                AttributeInfoEx[] conf = ds.get_attribute_info_ex();
                for (int j = 0; j < conf.length; ++j) {
                    this.addAttribute(conf[j]);
                }
                CommandInfo[] cmdInfo = ds.command_list_query();
                for (int j = 0; j < cmdInfo.length; ++j) {
                    this.addCommand(cmdInfo[j]);
                }
                continue;
            }
            catch (DevFailed e) {
                errStr.add(pi.devName + ":" + e.errors[0].desc);
            }
        }
        if (errStr.size() > 0) {
            JiveUtils.showJiveErrors(errStr);
        }
        i2 = 0;
        while (i2 < this.attItems.size()) {
            if (this.attItems.get((int)i2).count != this.items.size()) {
                this.attItems.remove(i2);
                continue;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.cmdItems.size()) {
            if (this.cmdItems.get((int)i2).count != this.items.size()) {
                this.cmdItems.remove(i2);
                continue;
            }
            ++i2;
        }
        DefaultListModel<Object> ml = new DefaultListModel<Object>();
        for (i = 0; i < this.attItems.size(); ++i) {
            ml.add(i, this.attItems.get(i));
        }
        this.attList.setModel(ml);
        ml = new DefaultListModel();
        for (i = 0; i < this.cmdItems.size(); ++i) {
            ml.add(i, this.cmdItems.get(i));
        }
        this.cmdList.setModel(ml);
    }

    private void addAttribute(AttributeInfoEx e) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.attItems.size()) {
            found = this.attItems.get((int)i).name.equalsIgnoreCase(e.name) && this.attItems.get((int)i).type == e.data_type && this.attItems.get((int)i).format == e.data_format;
            if (found) continue;
            ++i;
        }
        if (!found) {
            AItem it = new AItem();
            it.name = e.name;
            it.type = e.data_type;
            it.format = e.data_format;
            it.writeable = e.writable == AttrWriteType.READ_WRITE || e.writable == AttrWriteType.WRITE;
            it.enum_labels = e.enum_label;
            it.count = 1;
            this.attItems.add(it);
        } else {
            ++this.attItems.get((int)i).count;
        }
    }

    private void addCommand(CommandInfo e) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.cmdItems.size()) {
            found = this.cmdItems.get((int)i).name.equalsIgnoreCase(e.cmd_name) && this.cmdItems.get((int)i).in_type == e.in_type && this.cmdItems.get((int)i).out_type == e.out_type;
            if (found) continue;
            ++i;
        }
        if (!found) {
            CItem it = new CItem();
            it.name = e.cmd_name;
            it.in_type = e.in_type;
            it.out_type = e.out_type;
            it.count = 1;
            this.cmdItems.add(it);
        } else {
            ++this.cmdItems.get((int)i).count;
        }
    }

    private void refreshTable() {
        Object[][] prop = new String[this.items.size()][4];
        for (int i = 0; i < this.items.size(); ++i) {
            DItem it = this.items.get(i);
            prop[i][0] = it.devName;
            prop[i][1] = it.className;
            prop[i][2] = this.showValue.isSelected() ? it.value : "";
            prop[i][3] = Long.toString(it.time);
        }
        this.dm.setDataVector(prop, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
        this.infoLabel.setText(this.items.size() + " item(s)");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.searchButton || src == this.selectionText || src == this.ignoreUnexported) {
            this.selectDevice();
        } else if (src == this.dismissButton) {
            this.exitDlg();
            this.setVisible(false);
        } else if (src == this.readAttBtn) {
            int attId = this.attList.getSelectedIndex();
            if (attId >= 0) {
                AItem ai = this.attItems.get(attId);
                for (int i = 0; i < this.items.size(); ++i) {
                    this.readAtt(this.items.get(i), ai);
                }
                this.refreshTable();
            }
        } else if (src == this.writeAttBtn) {
            int attId = this.attList.getSelectedIndex();
            if (attId >= 0) {
                AItem ai = this.attItems.get(attId);
                try {
                    this.writeAtts(ai);
                }
                catch (NumberFormatException e) {
                    JiveUtils.showJiveError(e.getMessage());
                }
            }
        } else if (src == this.saveAttListBtn) {
            int attId = this.attList.getSelectedIndex();
            if (attId >= 0) {
                AItem ai = this.attItems.get(attId);
                try {
                    this.saveAttList(ai);
                }
                catch (NumberFormatException e) {
                    JiveUtils.showJiveError(e.getMessage());
                }
            }
        } else if (src == this.execCmdBtn) {
            int cmdId = this.cmdList.getSelectedIndex();
            if (cmdId >= 0) {
                CItem ci = this.cmdItems.get(cmdId);
                try {
                    this.execCommand(ci);
                }
                catch (NumberFormatException e) {
                    JiveUtils.showJiveError(e.getMessage());
                }
            }
        } else if (src == this.removeButton) {
            int[] sel = this.theTable.getSelectedRows();
            for (int i = sel.length - 1; i >= 0; --i) {
                this.items.remove(sel[i]);
            }
            this.refreshCommandAndAttribute();
            this.refreshTable();
        } else if (src == this.showValue) {
            this.refreshTable();
        }
    }

    private void saveAttList(AItem att) throws NumberFormatException {
        File file = TreePanel.getSaveFile(null);
        if (file != null) {
            try {
                FileWriter attFile = new FileWriter(file.getAbsolutePath());
                for (DItem item : this.items) {
                    String attName = item.devName + "/" + att.name;
                    attFile.write(attName + "\n");
                }
                attFile.close();
            }
            catch (IOException e) {
                JiveUtils.showJiveError(e.getMessage());
            }
        }
    }

    private void writeAtts(AItem att) throws NumberFormatException {
        DeviceAttribute send = new DeviceAttribute(att.name);
        ArgParser arg = new ArgParser(this.attValueText.getText());
        if (this.items.size() > 1) {
            Vector<String> propChange = new Vector<String>();
            propChange.add(att.name);
            propChange.add(this.attValueText.getText());
            if (!MultiChangeConfirmDlg.confirmChange(propChange, this.items.size(), "", "Attribute")) {
                return;
            }
        }
        switch (att.type) {
            case 19: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_state());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_state_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_state_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 22: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert_uc(arg.parse_uchar());
                        break;
                    }
                    case 1: {
                        send.insert_uc(arg.parse_uchar_array());
                        break;
                    }
                    case 2: {
                        send.insert_uc(arg.parse_uchar_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 1: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_boolean());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_boolean_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_boolean_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 2: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_short());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_short_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_short_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 6: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert_us(arg.parse_ushort());
                        break;
                    }
                    case 1: {
                        send.insert_us(arg.parse_ushort_array());
                        break;
                    }
                    case 2: {
                        send.insert_us(arg.parse_ushort_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 3: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_long());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_long_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_long_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 7: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert_ul(arg.parse_ulong());
                        break;
                    }
                    case 1: {
                        send.insert_ul(arg.parse_ulong_array());
                        break;
                    }
                    case 2: {
                        send.insert_ul(arg.parse_ulong_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 23: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_long64());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_long64_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_long64_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 24: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert_u64(arg.parse_long64());
                        break;
                    }
                    case 1: {
                        send.insert_u64(arg.parse_long64_array());
                        break;
                    }
                    case 2: {
                        send.insert_u64(arg.parse_long64_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 4: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_float());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_float_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_float_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 5: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_double());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_double_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_double_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 8: {
                switch (att.format.value()) {
                    case 0: {
                        send.insert(arg.parse_string());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_string_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_string_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 29: {
                switch (att.format.value()) {
                    case 0: {
                        String[] in = arg.parse_string();
                        short idx = (short)JiveUtils.isInsideArray((String)in, att.enum_labels);
                        if (idx < 0) {
                            throw new NumberFormatException("\"" + (String)in + "\" not known in enum\nPossible values are:\n" + JiveUtils.stringArrayToString(att.enum_labels));
                        }
                        send.insert(idx);
                        break;
                    }
                    case 1: {
                        String[] in = arg.parse_string_array();
                        short[] idx = new short[in.length];
                        for (int i = 0; i < in.length; ++i) {
                            idx[i] = (short)JiveUtils.isInsideArray(in[i], att.enum_labels);
                            if (idx[i] >= 0) continue;
                            throw new NumberFormatException("\"" + in[i] + "\" not known in enum\nPossible values are:\n" + JiveUtils.stringArrayToString(att.enum_labels));
                        }
                        send.insert(idx);
                        break;
                    }
                    case 2: {
                        String[] in = arg.parse_string_image();
                        int width = arg.get_image_width();
                        int height = arg.get_image_height();
                        short[] idx = new short[in.length];
                        for (int i = 0; i < in.length; ++i) {
                            idx[i] = (short)JiveUtils.isInsideArray(in[i], att.enum_labels);
                            if (idx[i] >= 0) continue;
                            throw new NumberFormatException("\"" + in[i] + "\" not known in enum\nPossible values are:\n" + JiveUtils.stringArrayToString(att.enum_labels));
                        }
                        send.insert(idx, width, height);
                    }
                }
                break;
            }
            default: {
                throw new NumberFormatException("Attribute type not supported code=" + att.type);
            }
        }
        Vector<String> errList = new Vector<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            DItem di = this.items.get(i);
            try {
                DeviceProxy ds = new DeviceProxy(di.devName);
                ds.write_attribute(send);
                continue;
            }
            catch (DevFailed e) {
                errList.add(di.devName + ":" + e.errors[0].desc);
            }
        }
        if (errList.size() > 0) {
            JiveUtils.showJiveErrors(errList);
        }
    }

    private void readAtt(DItem di, AItem att) {
        StringBuffer ret_string = new StringBuffer();
        long t0 = System.currentTimeMillis();
        try {
            DeviceProxy ds = new DeviceProxy(di.devName);
            t0 = System.currentTimeMillis();
            DeviceAttribute data = ds.read_attribute(att.name);
            long t1 = System.currentTimeMillis();
            if (data.getQuality().value() == 1) {
                di.value = "INVALID";
                di.time = t1 - t0;
                return;
            }
            int nbRead = data.getNbRead();
            switch (att.type) {
                case 19: {
                    DevState[] dummy = data.extractDevStateArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(TangoConst.Tango_DevStateName[dummy[i].value()]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 22: {
                    short[] dummy = data.extractUCharArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 2: {
                    short[] dummy = data.extractShortArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 1: {
                    boolean[] dummy = data.extractBooleanArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 6: {
                    int[] dummy = data.extractUShortArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 3: {
                    int[] dummy = data.extractLongArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 7: {
                    long[] dummy = data.extractULongArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 23: {
                    long[] dummy = data.extractLong64Array();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 24: {
                    long[] dummy = data.extractULong64Array();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 5: {
                    double[] dummy = data.extractDoubleArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 4: {
                    float[] dummy = data.extractFloatArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 8: {
                    String[] dummy = data.extractStringArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i]);
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                case 28: {
                    DevEncoded e = data.extractDevEncoded();
                    ret_string.append(e.encoded_format);
                    break;
                }
                case 29: {
                    short[] dummy = data.extractShortArray();
                    for (int i = 0; i < nbRead; ++i) {
                        ret_string.append(dummy[i] + " (" + att.enum_labels[i] + ")");
                        if (i >= nbRead - 1) continue;
                        ret_string.append("\n");
                    }
                    break;
                }
                default: {
                    ret_string.append("Unsupported attribute type code=" + att.type + "\n");
                }
            }
            di.value = ret_string.toString();
            di.time = t1 - t0;
        }
        catch (DevFailed e) {
            di.value = e.errors[0].desc;
            di.time = System.currentTimeMillis() - t0;
        }
    }

    private void execCommand(CItem ci) throws NumberFormatException {
        ArgParser arg = null;
        DeviceData send = null;
        if (ci.in_type != 0) {
            arg = new ArgParser(this.cmdValueText.getText());
            try {
                send = new DeviceData();
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
                return;
            }
        }
        if (this.items.size() > 1) {
            Vector<String> propChange = new Vector<String>();
            propChange.add(ci.name);
            if (arg == null) {
                propChange.add("None");
            } else {
                propChange.add(this.cmdValueText.getText());
            }
            if (!MultiChangeConfirmDlg.confirmChange(propChange, this.items.size(), "", "Command")) {
                return;
            }
        }
        if (send != null) {
            switch (ci.in_type) {
                case 1: {
                    send.insert(arg.parse_boolean());
                    break;
                }
                case 6: {
                    send.insert_us(arg.parse_ushort());
                    break;
                }
                case 2: {
                    send.insert(arg.parse_short());
                    break;
                }
                case 7: {
                    send.insert_ul(arg.parse_ulong());
                    break;
                }
                case 3: {
                    send.insert(arg.parse_long());
                    break;
                }
                case 23: {
                    send.insert(arg.parse_long64());
                    break;
                }
                case 24: {
                    send.insert_u64(arg.parse_long64());
                    break;
                }
                case 4: {
                    send.insert(arg.parse_float());
                    break;
                }
                case 5: {
                    send.insert(arg.parse_double());
                    break;
                }
                case 8: {
                    send.insert(arg.parse_string());
                    break;
                }
                case 9: {
                    send.insert(arg.parse_char_array());
                    break;
                }
                case 14: {
                    send.insert_us(arg.parse_ushort_array());
                    break;
                }
                case 10: {
                    send.insert(arg.parse_short_array());
                    break;
                }
                case 15: {
                    send.insert_ul(arg.parse_ulong_array());
                    break;
                }
                case 11: {
                    send.insert(arg.parse_long_array());
                    break;
                }
                case 25: {
                    send.insert(arg.parse_long64_array());
                    break;
                }
                case 26: {
                    send.insert_u64(arg.parse_long64_array());
                    break;
                }
                case 12: {
                    send.insert(arg.parse_float_array());
                    break;
                }
                case 13: {
                    send.insert(arg.parse_double_array());
                    break;
                }
                case 16: {
                    send.insert(arg.parse_string_array());
                    break;
                }
                case 17: {
                    send.insert(new DevVarLongStringArray(arg.parse_long_array(), arg.parse_string_array()));
                    break;
                }
                case 18: {
                    send.insert(new DevVarDoubleStringArray(arg.parse_double_array(), arg.parse_string_array()));
                    break;
                }
                case 19: {
                    send.insert(DevState.from_int((int)arg.parse_ushort()));
                    break;
                }
                default: {
                    throw new NumberFormatException("Command type not supported code=" + ci.in_type);
                }
            }
        }
        Vector<String> errList = new Vector<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            DItem di = this.items.get(i);
            this.items.get((int)i).time = 0L;
            long t0 = System.currentTimeMillis();
            try {
                DeviceProxy ds = new DeviceProxy(di.devName);
                t0 = System.currentTimeMillis();
                DeviceData data = send == null ? ds.command_inout(ci.name) : ds.command_inout(ci.name, send);
                long t1 = System.currentTimeMillis();
                this.items.get((int)i).time = t1 - t0;
                switch (ci.out_type) {
                    case 0: {
                        this.items.get((int)i).value = ci.name + " Ok";
                        break;
                    }
                    case 1: {
                        this.items.get((int)i).value = Boolean.toString(data.extractBoolean());
                        break;
                    }
                    case 6: {
                        this.items.get((int)i).value = Integer.toString(data.extractUShort());
                        break;
                    }
                    case 2: {
                        this.items.get((int)i).value = Short.toString(data.extractShort());
                        break;
                    }
                    case 7: {
                        this.items.get((int)i).value = Long.toString(data.extractULong());
                        break;
                    }
                    case 24: {
                        this.items.get((int)i).value = Long.toString(data.extractULong64());
                        break;
                    }
                    case 3: {
                        this.items.get((int)i).value = Integer.toString(data.extractLong());
                        break;
                    }
                    case 23: {
                        this.items.get((int)i).value = Long.toString(data.extractLong64());
                        break;
                    }
                    case 4: {
                        this.items.get((int)i).value = Float.toString(data.extractFloat());
                        break;
                    }
                    case 5: {
                        this.items.get((int)i).value = Double.toString(data.extractDouble());
                        break;
                    }
                    case 8: 
                    case 20: {
                        this.items.get((int)i).value = data.extractString();
                        break;
                    }
                    case 9: {
                        int j;
                        Object dummy = data.extractByteArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Integer.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 14: {
                        int j;
                        Object dummy = data.extractUShortArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Integer.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 10: {
                        int j;
                        Object dummy = data.extractShortArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Integer.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 15: {
                        int j;
                        Object dummy = data.extractULongArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Long.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 26: {
                        int j;
                        Object dummy = data.extractULong64Array();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Long.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 11: {
                        int j;
                        Object dummy = data.extractLongArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Integer.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 25: {
                        int j;
                        Object dummy = data.extractULong64Array();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Long.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 12: {
                        int j;
                        Object dummy = data.extractFloatArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Float.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 13: {
                        int j;
                        Object dummy = data.extractDoubleArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append(Double.toString(dummy[j]));
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 16: {
                        int j;
                        Object dummy = data.extractStringArray();
                        StringBuffer ret_string = new StringBuffer();
                        for (j = 0; j < ((byte[])dummy).length; ++j) {
                            ret_string.append((String)dummy[j]);
                            if (i >= ((byte[])dummy).length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 17: {
                        int j;
                        Object dummy = data.extractLongStringArray();
                        StringBuffer ret_string = new StringBuffer();
                        ret_string.append("svalue:\n");
                        for (j = 0; j < dummy.svalue.length; ++j) {
                            ret_string.append(dummy.svalue[j]);
                        }
                        ret_string.append("lvalue:\n");
                        for (j = 0; j < dummy.lvalue.length; ++j) {
                            ret_string.append(dummy.lvalue[j]);
                            if (i >= dummy.lvalue.length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 18: {
                        int j;
                        Object dummy = data.extractDoubleStringArray();
                        StringBuffer ret_string = new StringBuffer();
                        ret_string.append("svalue:\n");
                        for (j = 0; j < dummy.svalue.length; ++j) {
                            ret_string.append(dummy.svalue[j]);
                        }
                        ret_string.append("dvalue:\n");
                        for (j = 0; j < dummy.dvalue.length; ++j) {
                            ret_string.append(dummy.dvalue[j]);
                            if (i >= dummy.dvalue.length - 1) continue;
                            ret_string.append("\n");
                        }
                        this.items.get((int)i).value = ret_string.toString();
                        break;
                    }
                    case 19: {
                        this.items.get((int)i).value = TangoConst.Tango_DevStateName[data.extractDevState().value()];
                        break;
                    }
                    default: {
                        errList.add("Unsupported command type code=" + ci.out_type);
                        break;
                    }
                }
                continue;
            }
            catch (DevFailed e) {
                this.items.get((int)i).time = System.currentTimeMillis() - t0;
                errList.add(di.devName + ":" + e.errors[0].desc);
            }
        }
        if (errList.size() > 0) {
            JiveUtils.showJiveErrors(errList);
        }
        if (ci.out_type != 0) {
            this.refreshTable();
        }
    }

    class DItem {
        String devName;
        String className;
        String value;
        long time;

        DItem() {
        }
    }

    class AItem {
        String name;
        int type;
        AttrDataFormat format;
        String[] enum_labels;
        boolean writeable;
        int count;

        AItem() {
        }

        public String toString() {
            return this.name + " (" + this.format.toString() + " " + TangoConst.Tango_CmdArgTypeName[this.type] + " " + (this.writeable ? "RW" : "RO") + ")";
        }
    }

    class CItem {
        String name;
        int in_type;
        int out_type;
        int count;

        CItem() {
        }

        public String toString() {
            return this.name + " (" + TangoConst.Tango_CmdArgTypeName[this.in_type] + "," + TangoConst.Tango_CmdArgTypeName[this.out_type] + ")";
        }
    }
}

