/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jive3.JTextEditor;
import jive3.PropertyNode;

public class PropertyEditorDlg
extends JDialog
implements ActionListener {
    private PropertyNode source;
    private String propName;
    private JTextField searchText;
    private JButton searchButton;
    private JButton searchNextButton;
    private JCheckBox searchMathCase;
    private JButton applyButton;
    private JButton dismissButton;
    private JPanel innerPanel = new JPanel();
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private JTextEditor textArea;
    private static final String[] separatorList = new String[]{",", ";", "=", "(", ")", "{", "}"};
    private static final Color separatorColor = new Color(160, 70, 160);
    private static final String[] keyword1List = new String[]{"true", "false"};
    private static final Color keyword1Color = new Color(30, 120, 30);
    private static final String[] keyword2List = new String[]{"DevBoolean", "DevShort", "DevUShort", "DevULong", "DevLong", "DevULong64", "DevLong64", "DevFloat", "DevDouble", "DevEnum"};
    private static final Color keyword2Color = new Color(30, 120, 120);

    PropertyEditorDlg(JFrame parent) {
        super((Frame)parent, true);
        this.innerPanel.setLayout(new BorderLayout());
        this.textArea = new JTextEditor();
        this.textArea.setBackground(Color.WHITE);
        this.scrollPane = new JScrollPane(this.textArea);
        this.textArea.setEditable(true);
        this.textArea.setDefaultForegroundColor(new Color(50, 50, 50));
        this.textArea.setScrollPane(this.scrollPane);
        this.textArea.addActionListener(this);
        this.innerPanel.add((Component)this.scrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.innerPanel.add((Component)this.buttonPanel, "South");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 3;
        gbc.insets.right = 3;
        this.searchText = new JTextField();
        this.searchText.setEditable(true);
        this.searchText.setPreferredSize(new Dimension(150, 25));
        this.buttonPanel.add((Component)this.searchText, gbc);
        this.searchMathCase = new JCheckBox("Match case");
        this.searchMathCase.setSelected(false);
        this.buttonPanel.add((Component)this.searchMathCase, gbc);
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        this.buttonPanel.add((Component)this.searchButton, gbc);
        this.searchNextButton = new JButton("Search Next");
        this.searchNextButton.addActionListener(this);
        this.buttonPanel.add((Component)this.searchNextButton, gbc);
        JPanel dummyPanel = new JPanel();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.buttonPanel.add((Component)dummyPanel, gbc);
        gbc.fill = 0;
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.dismissButton = new JButton("Cancel");
        this.dismissButton.addActionListener(this);
        this.buttonPanel.add(this.dismissButton);
        this.innerPanel.setPreferredSize(new Dimension(640, 480));
        this.setContentPane(this.innerPanel);
    }

    public void setSource(PropertyNode source, String propName, String propValue) {
        this.source = source;
        this.propName = propName;
        this.textArea.setText(propValue);
        this.parse();
        this.setTitle("Edit property " + source.getName() + "/" + propName);
        this.requestFocus();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.dismissButton) {
            this.setVisible(false);
        } else if (src == this.applyButton) {
            this.source.setProperty(this.propName, this.textArea.getText());
            this.setVisible(false);
        } else if (src == this.textArea) {
            this.parse();
        } else if (src == this.searchButton) {
            this.textArea.searchText(this.searchText.getText(), this.searchMathCase.isSelected());
        } else if (src == this.searchNextButton) {
            this.textArea.searchNext(this.searchMathCase.isSelected());
        }
    }

    private void parse() {
        int idx;
        boolean end;
        int i;
        String text = this.textArea.getText();
        this.textArea.clearStyleAndColor();
        for (i = 0; i < separatorList.length; ++i) {
            end = false;
            idx = 0;
            while (!end) {
                end = (idx = text.indexOf(separatorList[i], idx)) == -1;
                if (end) continue;
                this.textArea.setForeground(separatorColor, idx, separatorList[i].length());
                this.textArea.setStyle(1, idx, separatorList[i].length());
                idx += separatorList[i].length();
            }
        }
        for (i = 0; i < keyword1List.length; ++i) {
            end = false;
            idx = 0;
            while (!end) {
                end = (idx = text.indexOf(keyword1List[i], idx)) == -1;
                if (end) continue;
                this.textArea.setForeground(keyword1Color, idx, keyword1List[i].length());
                idx += keyword1List[i].length();
            }
        }
        for (i = 0; i < keyword2List.length; ++i) {
            end = false;
            idx = 0;
            while (!end) {
                end = (idx = text.indexOf(keyword2List[i], idx)) == -1;
                if (end) continue;
                this.textArea.setForeground(keyword2Color, idx, keyword2List[i].length());
                this.textArea.setStyle(1, idx, keyword2List[i].length());
                idx += keyword2List[i].length();
            }
        }
    }
}

