/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jive.JiveUtils;
import jive.MultiLineCellEditor;

public class PropertyHistoryDlg
extends JFrame {
    private DevicePropertyHistPanel devicePropertyHistPanel;
    private DeviceAttributePropertyHistPanel deviceAttributePropertyHistPanel;
    private ClassPropertyHistPanel classPropertyHistPanel;
    private ClassAttributePropertyHistPanel classAttributePropertyHistPanel;
    private ObjectPropertyHistPanel objectPropertyHistPanel;
    private JTabbedPane tabPane = new JTabbedPane();

    PropertyHistoryDlg() {
        this.tabPane.setFont(ATKConstant.labelFont);
        this.devicePropertyHistPanel = new DevicePropertyHistPanel();
        this.tabPane.add((Component)this.devicePropertyHistPanel, "Device properties");
        this.deviceAttributePropertyHistPanel = new DeviceAttributePropertyHistPanel();
        this.tabPane.add((Component)this.deviceAttributePropertyHistPanel, "Device att. properties");
        this.classPropertyHistPanel = new ClassPropertyHistPanel();
        this.tabPane.add((Component)this.classPropertyHistPanel, "Class properties");
        this.classAttributePropertyHistPanel = new ClassAttributePropertyHistPanel();
        this.tabPane.add((Component)this.classAttributePropertyHistPanel, "Class att. properties");
        this.objectPropertyHistPanel = new ObjectPropertyHistPanel();
        this.tabPane.add((Component)this.objectPropertyHistPanel, "Free properties");
        this.getContentPane().add(this.tabPane);
        this.setTitle("Tango Database History");
    }

    public void viewDevicePropertyHistory(String devName, String propName) {
        this.devicePropertyHistPanel.text1.setText(devName);
        this.devicePropertyHistPanel.text2.setText(propName);
        this.devicePropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.devicePropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewDeviceAttPropertyHistory(String devName, String attName, String propName) {
        this.deviceAttributePropertyHistPanel.text1.setText(devName);
        this.deviceAttributePropertyHistPanel.text2.setText(attName);
        this.deviceAttributePropertyHistPanel.text3.setText(propName);
        this.deviceAttributePropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.deviceAttributePropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewClassAttPropertyHistory(String className, String attName, String propName) {
        this.classAttributePropertyHistPanel.text1.setText(className);
        this.classAttributePropertyHistPanel.text2.setText(attName);
        this.classAttributePropertyHistPanel.text3.setText(propName);
        this.classAttributePropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.classAttributePropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewFreePropertyHistory(String objName, String propName) {
        this.objectPropertyHistPanel.text1.setText(objName);
        this.objectPropertyHistPanel.text2.setText(propName);
        this.objectPropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.objectPropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewClassPropertyHistory(String className, String propName) {
        this.classPropertyHistPanel.text1.setText(className);
        this.classPropertyHistPanel.text2.setText(propName);
        this.classPropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.classPropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void setDatabase(Database db, String title) {
        this.devicePropertyHistPanel.setDatabase(db);
        this.deviceAttributePropertyHistPanel.setDatabase(db);
        this.classPropertyHistPanel.setDatabase(db);
        this.classAttributePropertyHistPanel.setDatabase(db);
        this.objectPropertyHistPanel.setDatabase(db);
        if (db == null) {
            this.setTitle("Tango Database History [No connection]");
        } else {
            this.setTitle("Tango Database History [" + title + "]");
        }
    }

    public static void main(String[] args) {
        Database db;
        PropertyHistoryDlg dlg = new PropertyHistoryDlg();
        try {
            db = ApiUtil.get_db_obj();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            db = null;
        }
        dlg.setDatabase(db, "");
        dlg.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen((Frame)dlg);
        dlg.setVisible(true);
    }

    class DevicePropertyHistPanel
    extends PropertyHistPanel {
        private String devName;

        DevicePropertyHistPanel() {
            this.devName = null;
            this.initComponents("Device", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.devName = this.text1.getText();
            String pName = this.text2.getText();
            try {
                DbHistory[] hist = this.db.get_device_property_history(this.devName, pName);
                this.updateHistory(hist);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.devName == null) {
                return;
            }
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                String pName = (String)this.dm.getValueAt(row, 1);
                String value = (String)this.dm.getValueAt(row, 2);
                if (value.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int ok = JOptionPane.showConfirmDialog(null, "Do you to reapply device property " + pName + "?", "Confirm reapply", 0);
                    if (ok == 0) {
                        this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(pName, value));
                    }
                }
                catch (DevFailed ex) {
                    JiveUtils.showTangoError(ex);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class DeviceAttributePropertyHistPanel
    extends AttributePropertyHistPanel {
        private String devName;

        DeviceAttributePropertyHistPanel() {
            this.devName = null;
            this.initComponents("Device", "Attribute", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.devName = this.text1.getText();
            String attName = this.text2.getText();
            String pName = this.text3.getText();
            try {
                DbHistory[] hist = this.db.get_device_attribute_property_history(this.devName, attName, pName);
                this.updateHistory(hist);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }

        @Override
        void reApply() {
            block8: {
                if (this.db == null) {
                    return;
                }
                if (this.devName == null) {
                    return;
                }
                int row = this.theTable.getSelectedRow();
                if (row >= 0) {
                    String aName = (String)this.dm.getValueAt(row, 1);
                    String pName = (String)this.dm.getValueAt(row, 2);
                    String value = (String)this.dm.getValueAt(row, 3);
                    if (value.equals("DELETED")) {
                        JiveUtils.showJiveError("Cannot reapply deleted property");
                        return;
                    }
                    try {
                        int ok = JOptionPane.showConfirmDialog(null, "Do you to reapply attribute property " + pName + "?", "Confirm reapply", 0);
                        if (ok != 0) break block8;
                        DbAttribute dba = new DbAttribute(aName);
                        dba.add(pName, JiveUtils.makeStringArray(value));
                        this.db.put_device_attribute_property(this.devName, dba);
                        ok = JOptionPane.showConfirmDialog(null, "The device " + this.devName + " need to be restarted\nDo you want to do it now ?", "Confirm restart", 0);
                        if (ok == 0) {
                            DbDevImportInfo info = this.db.import_device(this.devName);
                            DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
                            DeviceData in = new DeviceData();
                            in.insert(this.devName);
                            ds.command_inout("DevRestart", in);
                        }
                    }
                    catch (DevFailed ex) {
                        JiveUtils.showTangoError(ex);
                    }
                } else {
                    JiveUtils.showJiveError("Empty selection");
                }
            }
        }
    }

    class ClassPropertyHistPanel
    extends PropertyHistPanel {
        private String className;

        ClassPropertyHistPanel() {
            this.className = null;
            this.initComponents("Class", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.className = this.text1.getText();
            String pName = this.text2.getText();
            try {
                DbHistory[] hist = this.db.get_class_property_history(this.className, pName);
                this.updateHistory(hist);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.className == null) {
                return;
            }
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                String pName = (String)this.dm.getValueAt(row, 1);
                String value = (String)this.dm.getValueAt(row, 2);
                if (value.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int ok = JOptionPane.showConfirmDialog(null, "Do you to reapply class property " + pName + "?", "Confirm reapply", 0);
                    if (ok == 0) {
                        this.db.put_class_property(this.className, JiveUtils.makeDbDatum(pName, value));
                    }
                }
                catch (DevFailed ex) {
                    JiveUtils.showTangoError(ex);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class ClassAttributePropertyHistPanel
    extends AttributePropertyHistPanel {
        private String className;

        ClassAttributePropertyHistPanel() {
            this.className = null;
            this.initComponents("Class", "Attribute", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.className = this.text1.getText();
            String attName = this.text2.getText();
            String pName = this.text3.getText();
            try {
                DbHistory[] hist = this.db.get_class_attribute_property_history(this.className, attName, pName);
                this.updateHistory(hist);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.className == null) {
                return;
            }
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                String aName = (String)this.dm.getValueAt(row, 1);
                String pName = (String)this.dm.getValueAt(row, 2);
                String value = (String)this.dm.getValueAt(row, 3);
                if (value.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int ok = JOptionPane.showConfirmDialog(null, "Do you to reapply attribute property " + pName + "?", "Confirm reapply", 0);
                    if (ok == 0) {
                        DbAttribute dba = new DbAttribute(aName);
                        dba.add(pName, JiveUtils.makeStringArray(value));
                        this.db.put_class_attribute_property(this.className, dba);
                    }
                }
                catch (DevFailed ex) {
                    JiveUtils.showTangoError(ex);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class ObjectPropertyHistPanel
    extends PropertyHistPanel {
        private String objName;

        ObjectPropertyHistPanel() {
            this.objName = null;
            this.initComponents("Object", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.objName = this.text1.getText();
            String pName = this.text2.getText();
            try {
                DbHistory[] hist = this.db.get_property_history(this.objName, pName);
                this.updateHistory(hist);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.objName == null) {
                return;
            }
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                String pName = (String)this.dm.getValueAt(row, 1);
                String value = (String)this.dm.getValueAt(row, 2);
                if (value.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int ok = JOptionPane.showConfirmDialog(null, "Do you to reapply free property " + pName + "?", "Confirm reapply", 0);
                    if (ok == 0) {
                        this.db.put_property(this.objName, JiveUtils.makeDbDatum(pName, value));
                    }
                }
                catch (DevFailed ex) {
                    JiveUtils.showTangoError(ex);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class MultiLineCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        Color selColor = new Color(200, 200, 255);

        public MultiLineCellRenderer() {
            this.setEditable(false);
            this.setLineWrap(false);
            this.setWrapStyleWord(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                this.setText((String)value);
            } else {
                this.setText("");
            }
            if (isSelected) {
                this.setBackground(this.selColor);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    abstract class AttributePropertyHistPanel
    extends JPanel
    implements ActionListener {
        Database db;
        String[] colName = new String[]{"Date", "Attribute", "Property name", "Value"};
        private MultiLineCellEditor editor;
        JTextField text1;
        JTextField text2;
        JTextField text3;
        private JLabel selectionLabel;
        private JButton searchButton;
        private JButton reApplyButton;
        DefaultTableModel dm;
        JTable theTable;

        AttributePropertyHistPanel() {
        }

        void initComponents(String name1, String name2, String name3) {
            this.setLayout(new BorderLayout());
            JPanel innerPanel = new JPanel(null);
            innerPanel.setPreferredSize(new Dimension(640, 85));
            JLabel deviceLabel = new JLabel(name1);
            deviceLabel.setFont(ATKConstant.labelFont);
            deviceLabel.setBounds(5, 5, 100, 25);
            innerPanel.add(deviceLabel);
            this.text1 = new JTextField();
            this.text1.setMargin(JiveUtils.noMargin);
            this.text1.setFont(ATKConstant.labelFont);
            this.text1.setBounds(110, 5, 200, 25);
            innerPanel.add(this.text1);
            JLabel attributeLabel = new JLabel(name2);
            attributeLabel.setFont(ATKConstant.labelFont);
            attributeLabel.setBounds(5, 30, 100, 25);
            innerPanel.add(attributeLabel);
            this.text2 = new JTextField();
            this.text2.setMargin(JiveUtils.noMargin);
            this.text2.setFont(ATKConstant.labelFont);
            this.text2.setBounds(110, 30, 200, 25);
            innerPanel.add(this.text2);
            JLabel propertyLabel = new JLabel(name3);
            propertyLabel.setFont(ATKConstant.labelFont);
            propertyLabel.setBounds(5, 55, 100, 25);
            innerPanel.add(propertyLabel);
            this.text3 = new JTextField();
            this.text3.setMargin(JiveUtils.noMargin);
            this.text3.setFont(ATKConstant.labelFont);
            this.text3.setBounds(110, 55, 200, 25);
            innerPanel.add(this.text3);
            this.searchButton = new JButton("Search");
            this.searchButton.setBounds(320, 5, 100, 25);
            this.searchButton.addActionListener(this);
            innerPanel.add(this.searchButton);
            JPanel innerPanel2 = new JPanel(null);
            innerPanel2.setPreferredSize(new Dimension(640, 35));
            this.reApplyButton = new JButton("Reapply selection");
            this.reApplyButton.setBounds(5, 5, 200, 25);
            this.reApplyButton.addActionListener(this);
            this.reApplyButton.setEnabled(false);
            innerPanel2.add(this.reApplyButton);
            this.selectionLabel = new JLabel("Selection:");
            this.selectionLabel.setFont(ATKConstant.labelFont);
            this.selectionLabel.setHorizontalAlignment(2);
            this.selectionLabel.setBounds(210, 5, 400, 25);
            innerPanel2.add(this.selectionLabel);
            this.add((Component)innerPanel, "North");
            this.add((Component)innerPanel2, "South");
            this.dm = new DefaultTableModel(){

                public Class getColumnClass(int columnIndex) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.theTable = new JTable(this.dm);
            this.editor = new MultiLineCellEditor(this.theTable);
            this.theTable.setDefaultEditor(String.class, this.editor);
            MultiLineCellRenderer renderer = new MultiLineCellRenderer();
            this.theTable.setDefaultRenderer(String.class, renderer);
            this.theTable.setSelectionMode(0);
            this.theTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AttributePropertyHistPanel.this.refreshSelection();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AttributePropertyHistPanel.this.refreshSelection();
                }
            });
            JScrollPane textView = new JScrollPane(this.theTable);
            this.add((Component)textView, "Center");
        }

        private void refreshTable() {
            this.editor.updateRows();
            this.theTable.getColumnModel().getColumn(0).setMaxWidth(140);
            this.theTable.getColumnModel().getColumn(0).setMinWidth(140);
            this.theTable.getColumnModel().getColumn(0).setPreferredWidth(140);
            this.theTable.getColumnModel().getColumn(3).setPreferredWidth(300);
            this.theTable.validate();
        }

        private void refreshSelection() {
            int row = this.theTable.getSelectedRow();
            if (row < 0) {
                this.selectionLabel.setText("Selection:");
                this.reApplyButton.setEnabled(false);
            } else {
                String value = (String)this.dm.getValueAt(row, 3);
                if (value.equals("DELETED")) {
                    this.selectionLabel.setText("Selection:");
                    this.reApplyButton.setEnabled(false);
                } else {
                    String pDate = (String)this.dm.getValueAt(row, 0);
                    String aName = (String)this.dm.getValueAt(row, 1);
                    String pName = (String)this.dm.getValueAt(row, 2);
                    this.selectionLabel.setText("Selection: " + aName + "/" + pName + " at " + pDate);
                    this.reApplyButton.setEnabled(!JiveUtils.readOnly);
                }
            }
        }

        void setDatabase(Database db) {
            this.db = db;
            this.dm.setDataVector(new String[0][3], this.colName);
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            this.refreshTable();
        }

        void updateHistory(DbHistory[] hist) {
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            if (hist.length == 0) {
                JiveUtils.showJiveError("No data found.");
                this.dm.setDataVector(new String[0][3], this.colName);
            } else {
                Object[][] prop = new String[hist.length][4];
                for (int i = 0; i < hist.length; ++i) {
                    prop[i][0] = hist[i].getDate();
                    prop[i][1] = hist[i].getAttributeName();
                    prop[i][2] = hist[i].getName();
                    prop[i][3] = hist[i].isDeleted() ? "DELETED" : hist[i].getValue();
                }
                this.dm.setDataVector(prop, this.colName);
            }
            this.refreshTable();
        }

        abstract void performSearch();

        abstract void reApply();

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.searchButton) {
                this.performSearch();
            } else if (src == this.reApplyButton) {
                this.reApply();
            }
        }
    }

    abstract class PropertyHistPanel
    extends JPanel
    implements ActionListener {
        Database db;
        String[] colName = new String[]{"Date", "Property name", "Value"};
        private MultiLineCellEditor editor;
        JTextField text1;
        JTextField text2;
        JLabel selectionLabel;
        private JButton searchButton;
        private JButton reApplyButton;
        DefaultTableModel dm;
        JTable theTable;

        PropertyHistPanel() {
        }

        void initComponents(String name1, String name2) {
            this.setLayout(new BorderLayout());
            JPanel innerPanel = new JPanel(null);
            innerPanel.setPreferredSize(new Dimension(640, 60));
            JLabel deviceLabel = new JLabel(name1);
            deviceLabel.setFont(ATKConstant.labelFont);
            deviceLabel.setBounds(5, 5, 100, 25);
            innerPanel.add(deviceLabel);
            this.text1 = new JTextField();
            this.text1.setMargin(JiveUtils.noMargin);
            this.text1.setFont(ATKConstant.labelFont);
            this.text1.setBounds(110, 5, 200, 25);
            innerPanel.add(this.text1);
            JLabel propertyLabel = new JLabel(name2);
            propertyLabel.setFont(ATKConstant.labelFont);
            propertyLabel.setBounds(5, 30, 100, 25);
            innerPanel.add(propertyLabel);
            this.text2 = new JTextField();
            this.text2.setMargin(JiveUtils.noMargin);
            this.text2.setFont(ATKConstant.labelFont);
            this.text2.setBounds(110, 30, 200, 25);
            innerPanel.add(this.text2);
            this.searchButton = new JButton("Search");
            this.searchButton.setBounds(320, 5, 100, 25);
            this.searchButton.addActionListener(this);
            innerPanel.add(this.searchButton);
            JPanel innerPanel2 = new JPanel(null);
            innerPanel2.setPreferredSize(new Dimension(640, 35));
            this.reApplyButton = new JButton("Reapply selection");
            this.reApplyButton.setBounds(5, 5, 200, 25);
            this.reApplyButton.addActionListener(this);
            this.reApplyButton.setEnabled(false);
            innerPanel2.add(this.reApplyButton);
            this.selectionLabel = new JLabel("Selection:");
            this.selectionLabel.setFont(ATKConstant.labelFont);
            this.selectionLabel.setHorizontalAlignment(2);
            this.selectionLabel.setBounds(210, 5, 400, 25);
            innerPanel2.add(this.selectionLabel);
            this.add((Component)innerPanel, "North");
            this.add((Component)innerPanel2, "South");
            this.dm = new DefaultTableModel(){

                public Class getColumnClass(int columnIndex) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.theTable = new JTable(this.dm);
            this.editor = new MultiLineCellEditor(this.theTable);
            this.theTable.setDefaultEditor(String.class, this.editor);
            MultiLineCellRenderer renderer = new MultiLineCellRenderer();
            this.theTable.setDefaultRenderer(String.class, renderer);
            this.theTable.setSelectionMode(0);
            this.theTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PropertyHistPanel.this.refreshSelection();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PropertyHistPanel.this.refreshSelection();
                }
            });
            JScrollPane textView = new JScrollPane(this.theTable);
            this.add((Component)textView, "Center");
        }

        private void refreshTable() {
            this.editor.updateRows();
            this.theTable.getColumnModel().getColumn(0).setMaxWidth(140);
            this.theTable.getColumnModel().getColumn(0).setMinWidth(140);
            this.theTable.getColumnModel().getColumn(0).setPreferredWidth(140);
            this.theTable.getColumnModel().getColumn(2).setPreferredWidth(300);
            this.theTable.validate();
        }

        private void refreshSelection() {
            int row = this.theTable.getSelectedRow();
            if (row < 0) {
                this.selectionLabel.setText("Selection:");
                this.reApplyButton.setEnabled(false);
            } else {
                String value = (String)this.dm.getValueAt(row, 2);
                if (value.equals("DELETED")) {
                    this.selectionLabel.setText("Selection:");
                    this.reApplyButton.setEnabled(false);
                } else {
                    String pDate = (String)this.dm.getValueAt(row, 0);
                    String pName = (String)this.dm.getValueAt(row, 1);
                    this.selectionLabel.setText("Selection:" + pName + " at " + pDate);
                    this.reApplyButton.setEnabled(!JiveUtils.readOnly);
                }
            }
        }

        void setDatabase(Database db) {
            this.db = db;
            this.dm.setDataVector(new String[0][3], this.colName);
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            this.refreshTable();
        }

        void updateHistory(DbHistory[] hist) {
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            if (hist.length == 0) {
                JiveUtils.showJiveError("No data found.");
                this.dm.setDataVector(new String[0][3], this.colName);
            } else {
                Object[][] prop = new String[hist.length][3];
                for (int i = 0; i < hist.length; ++i) {
                    prop[i][0] = hist[i].getDate();
                    prop[i][1] = hist[i].getName();
                    prop[i][2] = hist[i].isDeleted() ? "DELETED" : hist[i].getValue();
                }
                this.dm.setDataVector(prop, this.colName);
            }
            this.refreshTable();
        }

        abstract void performSearch();

        abstract void reApply();

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.searchButton) {
                this.performSearch();
            } else if (src == this.reApplyButton) {
                this.reApply();
            }
        }
    }
}

