/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.ArgParser;
import jive.JiveUtils;
import jive3.JiveTable;
import jive3.MainPanel;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.PropertyEditorDlg;
import jive3.PropertyNode;
import jive3.TaskClassAttributePropertyNode;
import jive3.TaskClassPropertyNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskFreePropertyNode;
import jive3.TaskSubDevicePropertyNode;

public class PropertyPanel
extends JPanel
implements ActionListener,
MouseListener {
    private JScrollPane textView;
    private JiveTable theTable;
    private JButton refreshButton;
    private JButton applyButton;
    private JButton deleteButton;
    private JButton copyButton;
    private JButton newButton;
    private MainPanel parent;
    private PropertyEditorDlg propertyEditor = null;
    private PropertyNode[] source = null;
    private DefaultTableModel dm;
    private boolean[] updatedProp;
    private JPopupMenu tableMenu;
    private JMenuItem historyMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem toHexMenuItem;
    private JMenuItem toDecMenuItem;
    private JMenuItem descMenuItem;

    PropertyPanel() {
        this.setLayout(new BorderLayout());
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    PropertyPanel.this.applyButton.setEnabled(true);
                    PropertyPanel.this.updatedProp[row] = true;
                }
            }
        };
        this.theTable = new JiveTable(this.dm);
        this.theTable.addMouseListener(this);
        this.theTable.getEditor().getTextArea().addMouseListener(this);
        this.textView = new JScrollPane(this.theTable);
        this.add((Component)this.textView, "Center");
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.textView.setBorder(b);
        this.add((Component)this.textView, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(!JiveUtils.readOnly);
        this.deleteButton.addActionListener(this);
        this.copyButton = new JButton("Copy");
        this.copyButton.setEnabled(!JiveUtils.readOnly);
        this.copyButton.addActionListener(this);
        this.newButton = new JButton("New property");
        this.newButton.setEnabled(!JiveUtils.readOnly);
        this.newButton.addActionListener(this);
        btnPanel.add(this.refreshButton);
        btnPanel.add(this.applyButton);
        btnPanel.add(this.newButton);
        btnPanel.add(this.copyButton);
        btnPanel.add(this.deleteButton);
        this.add((Component)btnPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.theTable.addKeyPressedEvent(67, 128, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PropertyPanel.this.copy();
            }
        });
        this.renameMenuItem = new JMenuItem("Rename");
        this.renameMenuItem.addActionListener(this);
        this.renameMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.theTable.addKeyPressedEvent(113, 0, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PropertyPanel.this.rename();
            }
        });
        this.historyMenuItem = new JMenuItem("View history");
        this.historyMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.theTable.addKeyPressedEvent(127, 0, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PropertyPanel.this.delete();
            }
        });
        this.editMenuItem = new JMenuItem("Edit");
        this.editMenuItem.addActionListener(this);
        this.toHexMenuItem = new JMenuItem("Convert to Hexa");
        this.toHexMenuItem.addActionListener(this);
        this.toDecMenuItem = new JMenuItem("Convert to Decimal");
        this.toDecMenuItem.addActionListener(this);
        this.descMenuItem = new JMenuItem("Show description");
        this.descMenuItem.addActionListener(this);
        this.tableMenu.add(this.copyMenuItem);
        this.tableMenu.add(this.deleteMenuItem);
        this.tableMenu.add(this.renameMenuItem);
        this.tableMenu.add(this.editMenuItem);
        this.tableMenu.add(this.historyMenuItem);
        this.tableMenu.add(this.descMenuItem);
        this.tableMenu.add(new JSeparator());
        this.tableMenu.add(this.toHexMenuItem);
        this.tableMenu.add(this.toDecMenuItem);
        this.setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String selText;
        int row;
        Object src = e.getSource();
        if (src == this.theTable && e.getButton() == 3 && e.getClickCount() == 1 && !JiveUtils.readOnly && (row = this.theTable.getRowForLocation(e.getY())) != -1) {
            this.theTable.addRowSelectionInterval(row, row);
            this.theTable.setColumnSelectionInterval(0, 1);
            int[] rows = this.theTable.getSelectedRows();
            this.renameMenuItem.setEnabled(rows.length == 1);
            this.historyMenuItem.setEnabled(rows.length == 1);
            this.tableMenu.show(this.theTable, e.getX(), e.getY());
        }
        if (src == this.theTable.getEditor().getTextArea() && e.getButton() == 3 && e.getClickCount() == 1 && (selText = this.theTable.getEditor().getTextArea().getSelectedText()) != null) {
            int slashCount = 0;
            for (int i = 0; i < selText.length(); ++i) {
                if (selText.charAt(i) != '/') continue;
                ++slashCount;
            }
            if (slashCount == 2) {
                this.parent.goToDeviceNode(selText);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setParent(MainPanel parent) {
        this.parent = parent;
        this.theTable.setParent(parent);
    }

    public boolean hasChanged() {
        return this.applyButton.isEnabled();
    }

    public void saveChange() {
        int nb = this.getNbUpdated() * this.source.length;
        int k = 0;
        if (this.source.length > 1) {
            int i;
            Vector<String> propChange = new Vector<String>();
            for (i = 0; i < this.updatedProp.length; ++i) {
                if (!this.updatedProp[i]) continue;
                propChange.add((String)this.dm.getValueAt(i, 0));
                propChange.add((String)this.dm.getValueAt(i, 1));
            }
            if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length)) {
                this.applyButton.setEnabled(false);
                for (i = 0; i < this.updatedProp.length; ++i) {
                    this.updatedProp[i] = false;
                }
                return;
            }
        }
        if (nb > 1) {
            ProgressFrame.displayProgress("Updating properties");
        }
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            for (int j = 0; j < this.source.length; ++j) {
                ++k;
                if (nb > 1) {
                    ProgressFrame.setProgress("Applying " + this.source[j].getName() + "/" + this.dm.getValueAt(i, 0), k * 100 / nb);
                }
                this.source[j].setProperty((String)this.dm.getValueAt(i, 0), (String)this.dm.getValueAt(i, 1));
            }
            this.updatedProp[i] = false;
        }
        this.applyButton.setEnabled(false);
        ProgressFrame.hideProgress();
    }

    private String convertToHex(String s) {
        ArgParser p = new ArgParser(s);
        return p.convert_to_hex();
    }

    private String convertToDec(String s) {
        ArgParser p = new ArgParser(s);
        return p.convert_to_dec();
    }

    private void copy() {
        int[] rows = this.theTable.getSelectedRows();
        if (rows.length == 0) {
            JiveUtils.showJiveError("Nothing to copy.");
            return;
        }
        JiveUtils.the_clipboard.clear();
        for (int i = 0; i < rows.length; ++i) {
            JiveUtils.the_clipboard.add((String)this.dm.getValueAt(rows[i], 0), (String)this.dm.getValueAt(rows[i], 1));
        }
    }

    private void rename() {
        int row = this.theTable.getSelectedRow();
        String oldName = (String)this.dm.getValueAt(row, 0);
        String value = (String)this.dm.getValueAt(row, 1);
        String newName = JOptionPane.showInputDialog(null, "Rename property", oldName);
        if (newName == null) {
            return;
        }
        if (this.propertyExists(newName)) {
            JiveUtils.showJiveError("Name already exists.");
            return;
        }
        int k = 0;
        int nb = this.source.length;
        if (nb > 1) {
            ProgressFrame.displayProgress("Renaming properties");
        }
        for (int j = 0; j < this.source.length; ++j) {
            ProgressFrame.setProgress("Renaming " + this.source[j].getName() + "/" + oldName, ++k * 100 / nb);
            this.source[j].rename(oldName, value, newName);
        }
        this.refreshValue();
        ProgressFrame.hideProgress();
    }

    private void delete() {
        int[] rows = this.theTable.getSelectedRows();
        if (rows.length == 0) {
            JiveUtils.showJiveError("Selection is empty.");
            return;
        }
        int ok = JOptionPane.showConfirmDialog(this, "Delete selection ?", "Confirm delete", 0);
        if (ok == 0) {
            int nb = rows.length * this.source.length;
            int k = 0;
            if (nb > 1) {
                ProgressFrame.displayProgress("Deleting properties");
            }
            for (int i = 0; i < rows.length; ++i) {
                for (int j = 0; j < this.source.length; ++j) {
                    ProgressFrame.setProgress("Deleting " + this.source[j].getName() + "/" + this.dm.getValueAt(rows[i], 0), ++k * 100 / nb);
                    this.source[j].deleteProperty((String)this.dm.getValueAt(rows[i], 0));
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        } else if (src == this.applyButton) {
            this.saveChange();
        } else if (src == this.deleteMenuItem || src == this.deleteButton) {
            this.delete();
        } else if (src == this.renameMenuItem) {
            this.rename();
        } else if (src == this.editMenuItem) {
            if (this.propertyEditor == null) {
                this.propertyEditor = new PropertyEditorDlg(this.parent);
            }
            int row = this.theTable.getSelectedRow();
            String pName = (String)this.dm.getValueAt(row, 0);
            String pValue = (String)this.dm.getValueAt(row, 1);
            this.propertyEditor.setSource(this.source[0], pName, pValue);
            this.propertyEditor.setVisible(true);
            this.refreshValue();
        } else if (src == this.toHexMenuItem) {
            if (this.propertyEditor == null) {
                this.propertyEditor = new PropertyEditorDlg(this.parent);
            }
            int row = this.theTable.getSelectedRow();
            String pName = (String)this.dm.getValueAt(row, 0);
            String pValue = (String)this.dm.getValueAt(row, 1);
            String nValue = this.convertToHex(pValue);
            this.propertyEditor.setSource(this.source[0], pName, nValue);
            this.propertyEditor.setVisible(true);
            this.refreshValue();
        } else if (src == this.toDecMenuItem) {
            if (this.propertyEditor == null) {
                this.propertyEditor = new PropertyEditorDlg(this.parent);
            }
            int row = this.theTable.getSelectedRow();
            String pName = (String)this.dm.getValueAt(row, 0);
            String pValue = (String)this.dm.getValueAt(row, 1);
            String nValue = this.convertToDec(pValue);
            this.propertyEditor.setSource(this.source[0], pName, nValue);
            this.propertyEditor.setVisible(true);
            this.refreshValue();
        } else if (src == this.descMenuItem) {
            int row = this.theTable.getSelectedRow();
            String pName = (String)this.dm.getValueAt(row, 0);
            String desc = this.source[0].getDescription(pName);
            JOptionPane.showMessageDialog(this, desc, "Description", 1);
        } else if (src == this.historyMenuItem) {
            int row = this.theTable.getSelectedRow();
            String propName = (String)this.dm.getValueAt(row, 0);
            String objName = this.source[0].getName();
            if (this.source[0] instanceof TaskDevicePropertyNode) {
                this.parent.historyDlg.viewDevicePropertyHistory(objName, propName);
                this.parent.showHistory();
            } else if (this.source[0] instanceof TaskDeviceAttributePropertyNode) {
                String attName = ((TaskDeviceAttributePropertyNode)this.source[0]).getAttributeName();
                String devName = ((TaskDeviceAttributePropertyNode)this.source[0]).getDevName();
                this.parent.historyDlg.viewDeviceAttPropertyHistory(devName, attName, propName);
                this.parent.showHistory();
            } else if (this.source[0] instanceof TaskClassAttributePropertyNode) {
                String attName = ((TaskClassAttributePropertyNode)this.source[0]).getAttributeName();
                this.parent.historyDlg.viewClassAttPropertyHistory(objName, attName, propName);
                this.parent.showHistory();
            } else if (this.source[0] instanceof TaskFreePropertyNode) {
                this.parent.historyDlg.viewFreePropertyHistory(objName, propName);
                this.parent.showHistory();
            } else if (this.source[0] instanceof TaskClassPropertyNode) {
                this.parent.historyDlg.viewClassPropertyHistory(objName, propName);
                this.parent.showHistory();
            } else if (this.source[0] instanceof TaskSubDevicePropertyNode) {
                String devName = ((TaskSubDevicePropertyNode)this.source[0]).getDevName();
                String pName = ((TaskSubDevicePropertyNode)this.source[0]).getSubName() + "/" + propName;
                this.parent.historyDlg.viewDevicePropertyHistory(devName, pName);
                this.parent.showHistory();
            }
        } else if (src == this.newButton) {
            String newName = JOptionPane.showInputDialog(null, "Add property", "");
            if (newName == null) {
                return;
            }
            if (this.propertyExists(newName)) {
                JiveUtils.showJiveError("Name already exists.");
                return;
            }
            int k = 0;
            int nb = this.source.length;
            if (nb > 1) {
                ProgressFrame.displayProgress("Creating properties");
            }
            for (int j = 0; j < this.source.length; ++j) {
                ProgressFrame.setProgress("Creating " + this.source[j].getName() + "/" + newName, ++k * 100 / nb);
                this.source[j].setProperty(newName, "");
            }
            this.refreshValue();
            ProgressFrame.hideProgress();
        } else if (src == this.copyMenuItem || src == this.copyButton) {
            this.copy();
        }
    }

    void setSource(PropertyNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    private void refreshValue() {
        this.applyButton.setEnabled(false);
        if (this.source != null) {
            Object[] colName = new String[]{"Property name", "Value"};
            Object[][] prop = this.source[0].getProperties();
            this.dm.setDataVector(prop, colName);
            this.updatedProp = new boolean[prop.length];
            for (int i = 0; i < prop.length; ++i) {
                this.updatedProp[i] = false;
            }
            this.theTable.updateRows();
            this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.theTable.validate();
            Object title = this.source[0].getTitle();
            title = this.source.length == 1 ? (String)title + " [" + this.source[0].getName() + "]" : (String)title + " [" + this.source.length + " items selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), (String)title);
            this.textView.setBorder(b);
        }
    }

    private boolean propertyExists(String name) {
        boolean found = false;
        int i = 0;
        while (i < this.dm.getRowCount() && !found) {
            found = ((String)this.dm.getValueAt(i, 0)).equalsIgnoreCase(name);
            if (found) continue;
            ++i;
        }
        return found;
    }

    private int getNbUpdated() {
        int k = 0;
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            ++k;
        }
        return k;
    }
}

