/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.ProgressFrame;
import jive3.TaskSingleAttributeNode;

public class SingleAttributePanel
extends JPanel
implements ActionListener {
    private static final int NB_ROW = 31;
    private TaskSingleAttributeNode[] source = null;
    private JTable attTable;
    private DefaultTableModel attModel;
    MultiLineCellEditor editor;
    private JButton refreshBtn;
    private JButton applyBtn;
    private boolean[] updatedProp = new boolean[31];

    public SingleAttributePanel() {
        this.setLayout(new BorderLayout());
        this.attModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly && row != 0 && row != 3 && row != 6 && row != 10 && row != 12 && row != 15 && row != 19 && row != 22 && row != 29;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    SingleAttributePanel.this.applyBtn.setEnabled(true);
                    SingleAttributePanel.this.updatedProp[row] = true;
                }
            }
        };
        this.attTable = new JTable(this.attModel);
        this.editor = new MultiLineCellEditor(this.attTable);
        this.attTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer(true, true, false);
        this.attTable.setDefaultRenderer(String.class, renderer);
        JScrollPane attView = new JScrollPane(this.attTable);
        this.add((Component)attView, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(0));
        this.add((Component)btnPanel, "South");
        this.refreshBtn = new JButton("Refresh");
        this.refreshBtn.addActionListener(this);
        btnPanel.add(this.refreshBtn);
        this.applyBtn = new JButton("Apply");
        this.applyBtn.addActionListener(this);
        btnPanel.add(this.applyBtn);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.setBorder(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshBtn) {
            this.refreshValue();
        } else if (src == this.applyBtn) {
            this.saveChange();
        }
    }

    public void setSource(TaskSingleAttributeNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    public boolean hasChanged() {
        return this.applyBtn.isEnabled();
    }

    public void saveChange() {
        int nb = this.getNbUpdated() * this.source.length;
        int k = 0;
        if (nb > 1) {
            ProgressFrame.displayProgress("Updating properties");
        }
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            block24: for (int j = 0; j < this.source.length; ++j) {
                ProgressFrame.setProgress("Applying " + this.source[j].getTitle(), ++k * 100 / nb);
                switch (i) {
                    case 1: 
                    case 2: {
                        boolean polled = ((String)this.attModel.getValueAt(1, 1)).equalsIgnoreCase("true");
                        String period = (String)this.attModel.getValueAt(2, 1);
                        this.source[j].setAttributePolling(polled, period);
                        continue block24;
                    }
                    case 4: {
                        String newVal = (String)this.attModel.getValueAt(4, 1);
                        this.source[j].setAbsoluteChange(newVal);
                        continue block24;
                    }
                    case 5: {
                        String newVal = (String)this.attModel.getValueAt(5, 1);
                        this.source[j].setRelativeChange(newVal);
                        continue block24;
                    }
                    case 7: {
                        String newVal = (String)this.attModel.getValueAt(7, 1);
                        this.source[j].setArchAbsoluteChange(newVal);
                        continue block24;
                    }
                    case 8: {
                        String newVal = (String)this.attModel.getValueAt(8, 1);
                        this.source[j].setArchRelativeChange(newVal);
                        continue block24;
                    }
                    case 9: {
                        String newVal = (String)this.attModel.getValueAt(9, 1);
                        this.source[j].setArchPeriod(newVal);
                        continue block24;
                    }
                    case 11: {
                        String newVal = (String)this.attModel.getValueAt(11, 1);
                        this.source[j].setPeriod(newVal);
                        continue block24;
                    }
                    case 13: {
                        String newVal = (String)this.attModel.getValueAt(13, 1);
                        this.source[j].setLabel(newVal);
                        continue block24;
                    }
                    case 14: {
                        String newVal = (String)this.attModel.getValueAt(14, 1);
                        this.source[j].setFormat(newVal);
                        continue block24;
                    }
                    case 16: {
                        String newVal = (String)this.attModel.getValueAt(16, 1);
                        this.source[j].setUnit(newVal);
                        continue block24;
                    }
                    case 17: {
                        String newVal = (String)this.attModel.getValueAt(17, 1);
                        this.source[j].setDisplayUnit(newVal);
                        continue block24;
                    }
                    case 18: {
                        String newVal = (String)this.attModel.getValueAt(18, 1);
                        this.source[j].setStandardUnit(newVal);
                        continue block24;
                    }
                    case 20: {
                        String newVal = (String)this.attModel.getValueAt(20, 1);
                        this.source[j].setMin(newVal);
                        continue block24;
                    }
                    case 21: {
                        String newVal = (String)this.attModel.getValueAt(21, 1);
                        this.source[j].setMax(newVal);
                        continue block24;
                    }
                    case 23: {
                        String newVal = (String)this.attModel.getValueAt(23, 1);
                        this.source[j].setMinAlarm(newVal);
                        continue block24;
                    }
                    case 24: {
                        String newVal = (String)this.attModel.getValueAt(24, 1);
                        this.source[j].setMaxAlarm(newVal);
                        continue block24;
                    }
                    case 25: {
                        String newVal = (String)this.attModel.getValueAt(25, 1);
                        this.source[j].setMinWarning(newVal);
                        continue block24;
                    }
                    case 26: {
                        String newVal = (String)this.attModel.getValueAt(26, 1);
                        this.source[j].setMaxWarning(newVal);
                        continue block24;
                    }
                    case 27: {
                        String newVal = (String)this.attModel.getValueAt(27, 1);
                        this.source[j].setDeltaT(newVal);
                        continue block24;
                    }
                    case 28: {
                        String newVal = (String)this.attModel.getValueAt(28, 1);
                        this.source[j].setDeltaVal(newVal);
                        continue block24;
                    }
                    case 30: {
                        String newVal = (String)this.attModel.getValueAt(30, 1);
                        this.source[j].setDescr(newVal);
                    }
                }
            }
        }
        this.refreshValue();
        ProgressFrame.hideProgress();
    }

    private int getNbUpdated() {
        int k = 0;
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            ++k;
        }
        return k;
    }

    private void refreshValue() {
        if (this.source != null) {
            String title = this.source.length == 1 ? "Attribute configuration [" + this.source[0].getTitle() + "]" : "Attribute configuration [" + this.source.length + " attributes selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            this.setBorder(b);
            this.source[0].browseAttributeInfo();
            this.source[0].updatePollingInfo();
            for (int i = 0; i < 31; ++i) {
                this.updatedProp[i] = false;
            }
            this.applyBtn.setEnabled(false);
            Object[] attColName = new String[]{"Name", "Value"};
            Object[][] attInfo = new Object[31][2];
            attInfo[0][0] = "/BPolling";
            attInfo[0][1] = "";
            attInfo[1][0] = "Is Polled";
            attInfo[1][1] = Boolean.toString(this.source[0].isPolled());
            attInfo[2][0] = "Polling Period";
            attInfo[2][1] = this.source[0].getPollingPeriod();
            attInfo[3][0] = "/BChange Event";
            attInfo[3][1] = "";
            attInfo[4][0] = "Absolute";
            attInfo[4][1] = this.source[0].getAbsoluteChange();
            attInfo[5][0] = "Relative";
            attInfo[5][1] = this.source[0].getRelativeChange();
            attInfo[6][0] = "/BArchive Event";
            attInfo[6][1] = "";
            attInfo[7][0] = "Absolute";
            attInfo[7][1] = this.source[0].getArchAbsoluteChange();
            attInfo[8][0] = "Relative";
            attInfo[8][1] = this.source[0].getArchRelativeChange();
            attInfo[9][0] = "Period";
            attInfo[9][1] = this.source[0].getArchPeriod();
            attInfo[10][0] = "/BPeriodic Event";
            attInfo[10][1] = "";
            attInfo[11][0] = "Period";
            attInfo[11][1] = this.source[0].getPeriodic();
            attInfo[12][0] = "/BDisplay";
            attInfo[12][1] = "";
            attInfo[13][0] = "Label";
            attInfo[13][1] = this.source[0].getLabel();
            attInfo[14][0] = "Format";
            attInfo[14][1] = this.source[0].getFormat();
            attInfo[15][0] = "/BUnit";
            attInfo[15][1] = "";
            attInfo[16][0] = "Unit";
            attInfo[16][1] = this.source[0].getUnit();
            attInfo[17][0] = "Display Unit";
            attInfo[17][1] = this.source[0].getDisplayUnit();
            attInfo[18][0] = "Standard Unit";
            attInfo[18][1] = this.source[0].getStandardUnit();
            attInfo[19][0] = "/BRange";
            attInfo[19][1] = "";
            attInfo[20][0] = "Min value";
            attInfo[20][1] = this.source[0].getMin();
            attInfo[21][0] = "Max value";
            attInfo[21][1] = this.source[0].getMax();
            attInfo[22][0] = "/BAlarms";
            attInfo[22][1] = "";
            attInfo[23][0] = "Min Alarm";
            attInfo[23][1] = this.source[0].getMinAlarm();
            attInfo[24][0] = "Max Alarm";
            attInfo[24][1] = this.source[0].getMaxAlarm();
            attInfo[25][0] = "Min Warning";
            attInfo[25][1] = this.source[0].getMinWarning();
            attInfo[26][0] = "Max Warning";
            attInfo[26][1] = this.source[0].getMaxWarning();
            attInfo[27][0] = "Delta T";
            attInfo[27][1] = this.source[0].getDeltaT();
            attInfo[28][0] = "Delta Val";
            attInfo[28][1] = this.source[0].getDeltaVal();
            attInfo[29][0] = "/BDescription";
            attInfo[29][1] = "";
            attInfo[30][0] = "Description";
            attInfo[30][1] = this.source[0].getDescr();
            this.attModel.setDataVector(attInfo, attColName);
            this.attTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.editor.updateRows();
        } else {
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
            this.setBorder(b);
        }
    }
}

