/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jive.JiveUtils;
import jive3.JTextTips;
import jive3.MainPanel;
import jive3.ProgressFrame;
import jive3.TreePanelHostCollection;

public class StartServerDlg
extends JFrame
implements ActionListener {
    private JTextTips serverText;
    private JScrollPane serversView;
    private JTable serversTable;
    private DefaultTableModel serversModel;
    private JPanel innerPanel;
    private JButton addButton;
    private JButton addFromButton;
    private String hostName;
    private DeviceProxy starter;
    private MainPanel invoker;
    private JButton clearAllButton;
    private JButton clearButton;
    private JButton startButton;
    private JButton dismissButton;
    private ArrayList<ServerInfo> serverInfos;
    private Database db;

    public StartServerDlg(Database db, String hostName, DeviceProxy starter, MainPanel invoker) {
        this.db = db;
        this.hostName = hostName;
        this.starter = starter;
        this.invoker = invoker;
        this.serverInfos = new ArrayList();
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        String[] levels = new String[TreePanelHostCollection.NB_LEVELS + 2];
        levels[0] = "Remove Starter Info";
        levels[1] = "Not controlled";
        for (int i = 2; i < levels.length; ++i) {
            levels[i] = "Level " + (i - 1);
        }
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new GridBagLayout());
        upPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        JLabel serverLabel = new JLabel("Server");
        upPanel.add((Component)serverLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.serverText = new JTextTips();
        this.serverText.addActionListener(this);
        upPanel.add((Component)this.serverText, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        upPanel.add((Component)this.addButton, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.addFromButton = new JButton("Move servers from an other host");
        this.addFromButton.addActionListener(this);
        upPanel.add((Component)this.addFromButton, gbc);
        this.innerPanel.add((Component)upPanel, "North");
        this.serversModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Integer.class;
                    }
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (column == 1) {
                    int level;
                    StartServerDlg.this.serverInfos.get((int)row).level = level = ((Integer)aValue).intValue();
                    StartServerDlg.this.updateTable();
                }
            }
        };
        this.serversTable = new JTable();
        this.serversTable.setDefaultRenderer(Integer.class, new LevelComboBoxRenderer(levels));
        this.serversTable.setDefaultEditor(Integer.class, new LevelComboBoxEditor(levels));
        this.serversTable.setModel(this.serversModel);
        this.serversTable.setRowHeight(25);
        this.serversView = new JScrollPane(this.serversTable);
        this.innerPanel.add((Component)this.serversView, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.setBorder(BorderFactory.createEtchedBorder());
        this.innerPanel.add((Component)btnPanel, "South");
        this.clearButton = new JButton("Clear selected");
        this.clearButton.addActionListener(this);
        btnPanel.add(this.clearButton);
        this.clearAllButton = new JButton("Clear all");
        this.clearAllButton.addActionListener(this);
        btnPanel.add(this.clearAllButton);
        this.startButton = new JButton("Start server(s) on " + hostName);
        this.startButton.addActionListener(this);
        btnPanel.add(this.startButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(this);
        btnPanel.add(this.dismissButton);
        this.innerPanel.setPreferredSize(new Dimension(640, 480));
        this.setContentPane(this.innerPanel);
        this.setTitle("Start Servers on " + hostName);
        this.updateTable();
    }

    public String getHost() throws DevFailed {
        final JDialog dlg = new JDialog((Frame)this, true);
        final StringBuffer result = new StringBuffer();
        final JList<String> list = new JList<String>(this.db.get_host_list());
        JScrollPane listView = new JScrollPane(list);
        listView.setPreferredSize(new Dimension(0, 300));
        list.setSelectionMode(0);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object s;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (s = list.getSelectedValue()) != null) {
                    result.append(s.toString());
                    dlg.setVisible(false);
                }
            }
        });
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)listView, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.setBorder(BorderFactory.createEtchedBorder());
        innerPanel.add((Component)btnPanel, "South");
        JButton selectButton = new JButton("Select");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result.append(list.getSelectedValue().toString());
                dlg.setVisible(false);
            }
        });
        btnPanel.add(selectButton);
        JButton dismissButton = new JButton("Dismiss");
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
            }
        });
        btnPanel.add(dismissButton);
        innerPanel.add((Component)btnPanel, "South");
        dlg.setTitle("Select Host");
        dlg.setContentPane(innerPanel);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        return result.toString();
    }

    public void setServerList(String[] list) {
        this.serverText.setTips(list);
    }

    private void updateTable() {
        Object[] colNames = new String[]{"Server", "Level", "Current host"};
        Object[][] info = new Object[this.serverInfos.size()][3];
        for (int i = 0; i < this.serverInfos.size(); ++i) {
            info[i][0] = this.serverInfos.get((int)i).serverName;
            info[i][1] = new Integer(this.serverInfos.get((int)i).level);
            info[i][2] = this.serverInfos.get((int)i).host;
        }
        this.serversModel.setDataVector(info, colNames);
        this.serversTable.getColumnModel().getColumn(0).setPreferredWidth(250);
    }

    private void addServer(String srvName) throws DevFailed {
        if (srvName.startsWith("Starter")) {
            return;
        }
        boolean found = false;
        int i = 0;
        while (!found && i < this.serverInfos.size()) {
            found = srvName.equals(this.serverInfos.get((int)i).serverName);
            if (found) continue;
            ++i;
        }
        if (!found) {
            DbServInfo srvInfo = this.db.get_server_info(srvName);
            ServerInfo si = new ServerInfo();
            si.serverName = srvName;
            si.level = srvInfo.controlled ? srvInfo.startup_level + 1 : 1;
            si.host = srvInfo.host;
            this.serverInfos.add(si);
        }
    }

    private void addServers() {
        try {
            String srvName = this.serverText.getText();
            String[] toAdd = srvName.contains("*") ? this.db.get_server_list(srvName) : new String[]{srvName};
            for (int i = 0; i < toAdd.length; ++i) {
                this.addServer(toAdd[i]);
            }
        }
        catch (DevFailed ex) {
            JiveUtils.showTangoError(ex);
        }
        this.updateTable();
    }

    private void addServerFromHost(String hostName) throws DevFailed {
        if (hostName.length() > 0) {
            String[] toAdd = this.db.get_host_server_list(hostName);
            for (int i = 0; i < toAdd.length; ++i) {
                this.addServer(toAdd[i]);
            }
        }
    }

    private boolean ping(String srvName) throws DevFailed {
        String deviceName = "dserver/" + srvName;
        DeviceProxy dev = new DeviceProxy(deviceName);
        try {
            dev.ping();
            return true;
        }
        catch (DevFailed devFailed) {
            return false;
        }
    }

    private void registerServer(String srvName, String hostName) throws DevFailed {
        String devname = "dserver/" + srvName;
        DbDevExportInfo info = new DbDevExportInfo(devname, "null", hostName, "null");
        this.db.export_device(info);
        this.db.unexport_device(devname);
    }

    private void startServer(String srvName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(srvName);
        this.starter.command_inout("DevStart", argin);
    }

    private void updateLevel(String srvName, int level) throws DevFailed {
        DbServer dbServer = new DbServer(srvName);
        DbServInfo info = dbServer.get_info();
        if (level == 0) {
            dbServer.put_info(new DbServInfo(srvName, this.hostName, false, 0));
            String[] deviceName = dbServer.get_device_class_list();
            for (int i = 0; i < deviceName.length; i += 2) {
                this.db.export_device(new DbDevExportInfo(deviceName[i], "", "", ""));
                this.db.unexport_device(deviceName[i]);
            }
        } else {
            info.host = this.hostName;
            info.startup_level = level - 1;
            info.controlled = info.startup_level != 0;
            dbServer.put_info(info);
        }
    }

    public boolean startServers() {
        StringBuffer errStr = new StringBuffer();
        if (this.serverInfos.size() == 0) {
            JiveUtils.showJiveError("Nothing to start !");
            return false;
        }
        if (this.serverInfos.size() > 1) {
            ProgressFrame.displayProgress("Starting servers");
        }
        for (int i = 0; i < this.serverInfos.size(); ++i) {
            String srvName = this.serverInfos.get((int)i).serverName;
            ProgressFrame.setProgress("Processing " + srvName, i * 100 / this.serverInfos.size());
            try {
                if (this.ping(srvName)) {
                    errStr.append(srvName + " is already running !\n");
                    continue;
                }
                this.registerServer(srvName, this.hostName);
                this.startServer(srvName);
                this.updateLevel(srvName, this.serverInfos.get((int)i).level);
                continue;
            }
            catch (DevFailed e) {
                errStr.append(srvName + ":" + e.errors[0].desc + "\n");
            }
        }
        try {
            this.starter.command_inout("UpdateServersInfo");
        }
        catch (DevFailed e) {
            errStr.append("UpdateServersInfo failed on " + this.starter.get_name() + " : " + e.errors[0].desc);
        }
        ProgressFrame.hideProgress();
        if (errStr.length() > 0) {
            JiveUtils.showJiveError(errStr.toString());
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.dismissButton) {
            this.setVisible(false);
        } else if (src == this.addButton || src == this.serverText) {
            this.addServers();
        } else if (src == this.addFromButton) {
            try {
                this.addServerFromHost(this.getHost());
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
            this.updateTable();
        } else if (src == this.clearButton) {
            int[] rows = this.serversTable.getSelectedRows();
            Arrays.sort(rows);
            for (int i = rows.length - 1; i >= 0; --i) {
                this.serverInfos.remove(rows[i]);
            }
            this.updateTable();
        } else if (src == this.clearAllButton) {
            this.serverInfos.clear();
            this.updateTable();
        } else if (src == this.startButton && this.startServers()) {
            this.setVisible(false);
            this.invoker.getHsotCollectionTreePanel().refresh();
        }
    }

    class LevelComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public LevelComboBoxRenderer(String[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            int idx = (Integer)value;
            this.setSelectedIndex(idx);
            return this;
        }
    }

    class LevelComboBoxEditor
    extends DefaultCellEditor {
        public LevelComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox cb = (JComboBox)this.editorComponent;
            int idx = (Integer)value;
            cb.setSelectedIndex(idx);
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            JComboBox cb = (JComboBox)this.editorComponent;
            return cb.getSelectedIndex();
        }
    }

    class ServerInfo {
        String serverName;
        int level;
        String host;

        ServerInfo() {
        }
    }
}

