/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jive.JiveUtils;

public class TangoClassSelector
extends JDialog
implements ActionListener {
    private String[] devList;
    private String[] classList;
    private String[] classInfo;
    private JLabel label1;
    private JList classSel;
    private JScrollPane classScroll;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okFlag = false;

    public TangoClassSelector(JFrame parent, String[] list, String selectField) {
        super((Frame)parent, true);
        this.devList = list;
        this.buildClassList();
        this.setLayout(null);
        this.setTitle("Class for " + selectField + " node selection");
        this.label1 = new JLabel(this.classList.length + " class(es) found, choose class to select");
        this.label1.setBounds(10, 10, 300, 25);
        this.add(this.label1);
        this.classSel = new JList();
        this.classSel.setSelectionMode(0);
        this.classSel.setListData(this.classInfo);
        this.classScroll = new JScrollPane(this.classSel);
        this.classScroll.setBounds(10, 40, 300, 300);
        this.add(this.classScroll);
        this.okButton = new JButton("Select");
        this.okButton.setBounds(10, 350, 80, 25);
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setBounds(230, 345, 80, 25);
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.okButton) {
            this.okFlag = true;
            this.setVisible(false);
        } else if (src == this.cancelButton) {
            this.okFlag = false;
            this.setVisible(false);
        }
    }

    private void buildClassList() {
        int i;
        Vector<String> classVector = new Vector<String>();
        int[] countDev = new int[32768];
        for (i = 0; i < this.devList.length; i += 2) {
            int idx = classVector.indexOf(this.devList[i + 1]);
            if (idx < 0) {
                classVector.add(this.devList[i + 1]);
                countDev[classVector.size() - 1] = 1;
                continue;
            }
            int n = idx;
            countDev[n] = countDev[n] + 1;
        }
        this.classList = new String[classVector.size()];
        this.classInfo = new String[classVector.size()];
        for (i = 0; i < this.classList.length; ++i) {
            this.classList[i] = (String)classVector.get(i);
            this.classInfo[i] = (String)classVector.get(i) + "     (" + Integer.toString(countDev[i]) + " devices)";
        }
    }

    public String getSelectedClass() {
        ATKGraphicsUtils.centerDialog((Dialog)this, (int)320, (int)380);
        this.setVisible(true);
        this.dispose();
        if (!this.okFlag) {
            return null;
        }
        int id = this.classSel.getSelectedIndex();
        if (id < 0) {
            JiveUtils.showJiveError("No class selected");
            return null;
        }
        return this.classList[id];
    }
}

