/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskLoggingNode
extends TangoNode {
    private Database db;
    private String devName;

    TaskLoggingNode(Database db, String devName) {
        this.db = db;
        this.devName = devName;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaflogicon;
    }

    @Override
    public String toString() {
        return "Logging";
    }

    @Override
    String getTitle() {
        return "Logging";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    void execAction(int number, boolean multipleCall) {
    }

    String getCurrentLoggingLevel() {
        String[] res = JiveUtils.getLoggingStatus(this.db, this.devName, 0);
        return JiveUtils.stringArrayToString(res);
    }

    void setCurrentLoggingLevel(String value) {
        JiveUtils.setLoggingLevel(this.db, this.devName, value);
    }

    String getCurrentLoggingTarget() {
        String[] res = JiveUtils.getLoggingStatus(this.db, this.devName, 1);
        return JiveUtils.stringArrayToString(res);
    }

    void setCurrentLoggingTarget(String value) {
        JiveUtils.setLoggingTarget(this.db, this.devName, value);
    }

    String getLoggingLevel() {
        try {
            String[] res = this.db.get_device_property(this.devName, "logging_level").extractStringArray();
            return JiveUtils.stringArrayToString(res);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return "";
        }
    }

    void setLoggingLevel(String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("logging_level", value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLoggingLevel() {
        try {
            this.db.delete_device_property(this.devName, "logging_level");
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getLoggingTarget() {
        try {
            String[] res = this.db.get_device_property(this.devName, "logging_target").extractStringArray();
            return JiveUtils.stringArrayToString(res);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return "";
        }
    }

    void setLoggingTarget(String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("logging_target", value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLoggingTarget() {
        try {
            this.db.delete_device_property(this.devName, "logging_target");
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getLoggingRft() {
        try {
            String[] res = this.db.get_device_property(this.devName, "logging_rft").extractStringArray();
            return JiveUtils.stringArrayToString(res);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return "2";
        }
    }

    void setLoggingRft(String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("logging_rft", value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLoggingRft() {
        try {
            this.db.delete_device_property(this.devName, "logging_rft");
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }
}

