/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.PipeInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskPipeNode
extends TangoNode {
    private Database db;
    private String devName;
    private List<PipeInfo> pipeInfo;

    TaskPipeNode(Database db, String devName) {
        this.db = db;
        this.devName = devName;
        this.pipeInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.pipeicon;
    }

    @Override
    public String toString() {
        return "Pipe config";
    }

    @Override
    String getTitle() {
        return "Pipe configuration";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    void execAction(int number, boolean multipleCall) {
    }

    int getAttributeNumber() {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.size();
    }

    String getAttName(int idx) {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.get(idx).getName();
    }

    String getLabel(int idx) {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.get(idx).getLabel();
    }

    void setLabel(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setLabel(value);
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetDisplay(int idx) {
        this.resetLDisplay(idx);
    }

    void resetLDisplay(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setLabel("Not specified");
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULDisplay(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setLabel("");
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULDisplay(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setLabel("NaN");
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getDescription(int idx) {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.get(idx).getDescription();
    }

    void setDescription(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setDescription(value);
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetDescription(int idx) {
        this.resetLDescription(idx);
    }

    void resetLDescription(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setDescription("Not specified");
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULDescription(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setDescription("");
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULDescription(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo.get(idx).setDescription("NaN");
            ds.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void browsePipeInfo() {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.pipeInfo = ds.getPipeConfig();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        if (this.pipeInfo == null) {
            this.pipeInfo = new List<PipeInfo>(){

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }

                @Override
                public boolean contains(Object o) {
                    return false;
                }

                @Override
                public Iterator<PipeInfo> iterator() {
                    return null;
                }

                @Override
                public Object[] toArray() {
                    return new Object[0];
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    return null;
                }

                @Override
                public boolean add(PipeInfo pipeInfo) {
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    return false;
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    return false;
                }

                @Override
                public boolean addAll(Collection<? extends PipeInfo> c) {
                    return false;
                }

                @Override
                public boolean addAll(int index, Collection<? extends PipeInfo> c) {
                    return false;
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    return false;
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    return false;
                }

                @Override
                public void clear() {
                }

                @Override
                public PipeInfo get(int index) {
                    return null;
                }

                @Override
                public PipeInfo set(int index, PipeInfo element) {
                    return null;
                }

                @Override
                public void add(int index, PipeInfo element) {
                }

                @Override
                public PipeInfo remove(int index) {
                    return null;
                }

                @Override
                public int indexOf(Object o) {
                    return 0;
                }

                @Override
                public int lastIndexOf(Object o) {
                    return 0;
                }

                @Override
                public ListIterator<PipeInfo> listIterator() {
                    return null;
                }

                @Override
                public ListIterator<PipeInfo> listIterator(int index) {
                    return null;
                }

                @Override
                public List<PipeInfo> subList(int fromIndex, int toIndex) {
                    return null;
                }
            };
        }
    }

    public void restartDevice() {
        try {
            DbDevImportInfo info = this.db.import_device(this.devName);
            DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
            DeviceData in = new DeviceData();
            in.insert(this.devName);
            ds.command_inout("DevRestart", in);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }
}

