/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.DbFileWriter;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskSubDevicePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;
    private String subName;

    TaskSubDevicePropertyNode(TreePanel parent, Database db, String devName, String subName) {
        this.db = db;
        this.devName = devName;
        this.parentPanel = parent;
        this.subName = subName;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    @Override
    public String toString() {
        return this.subName;
    }

    @Override
    String getTitle() {
        return "Device properties";
    }

    @Override
    String getName() {
        return this.devName + "/" + this.subName;
    }

    String getDevName() {
        return this.devName;
    }

    String getSubName() {
        return this.subName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    void execAction(int number, boolean multipleCall) {
        this.defaultPropertyAction(number);
    }

    private boolean acceptProperty(String name) {
        return !JiveUtils.IsPollCfgItem(name) && !JiveUtils.IsLogCfgItem(name) && !JiveUtils.IsHdbCfgItem(name) && !JiveUtils.IsSystemItem(name);
    }

    @Override
    public void viewHistory() {
        TreePanel.invoker.historyDlg.viewDevicePropertyHistory(this.devName, this.subName + "/*");
        TreePanel.invoker.showHistory();
    }

    @Override
    void saveProperties() {
        try {
            DbFileWriter.SaveDeviceProperties(this.devName);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        catch (IOException e2) {
            JiveUtils.showJiveError(e2.getMessage());
        }
    }

    @Override
    String[][] getProperties() {
        String[][] ret = new String[0][0];
        try {
            int i;
            String[] plist = this.db.get_device_property_list(this.devName, this.subName + "/*");
            Vector<String> pvec = new Vector<String>();
            int cutIdx = this.subName.length() + 1;
            for (i = 0; i < plist.length; ++i) {
                if (!this.acceptProperty(plist[i])) continue;
                pvec.add(plist[i].substring(cutIdx));
                String[] res = this.db.get_device_property(this.devName, plist[i]).extractStringArray();
                pvec.add(JiveUtils.stringArrayToString(res));
            }
            ret = new String[pvec.size() / 2][2];
            for (i = 0; i < ret.length; ++i) {
                ret[i][0] = (String)pvec.get(2 * i);
                ret[i][1] = (String)pvec.get(2 * i + 1);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    @Override
    void setProperty(String propName, String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(this.subName + "/" + propName, value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    void deleteProperty(String propName) {
        try {
            this.db.delete_device_property(this.devName, JiveUtils.makeDbDatum(this.subName + "/" + propName, ""));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }
}

